/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class EclipseLogAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String BUNDLE_ID = "org.eclipse.m2e.logback.appender";
    private static final ILog ECLIPSE_LOG = Platform.getLog(EclipseLogAppender.class);

    protected void append(ILoggingEvent logEvent) {
        int severity;
        switch (logEvent.getLevel().levelInt) {
            case 40000: {
                int n = 4;
                break;
            }
            case 30000: {
                int n = 2;
                break;
            }
            case 20000: {
                int n = 1;
                break;
            }
            default: {
                int n = severity = -1;
            }
        }
        if (severity != -1) {
            Status status = new Status(severity, BUNDLE_ID, logEvent.getFormattedMessage().strip(), EclipseLogAppender.getThrowable(logEvent));
            ECLIPSE_LOG.log((IStatus)status);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Throwable getThrowable(ILoggingEvent logEvent) {
        Throwable throwable;
        Object object;
        IThrowableProxy iThrowableProxy = logEvent.getThrowableProxy();
        if (iThrowableProxy instanceof ThrowableProxy) {
            void proxy;
            ThrowableProxy throwableProxy = (ThrowableProxy)iThrowableProxy;
            ThrowableProxy cfr_ignored_0 = (ThrowableProxy)iThrowableProxy;
            return proxy.getThrowable();
        }
        Object[] args = logEvent.getArgumentArray();
        if (args != null && args.length > 0 && (object = args[args.length - 1]) instanceof Throwable) {
            void throwable2;
            Throwable throwable3 = (Throwable)object;
            Throwable cfr_ignored_1 = (Throwable)object;
            throwable = throwable2;
        } else {
            throwable = null;
        }
        return throwable;
    }
}

