/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class PHPDebugUICompositeImageDescriptor
extends CompositeImageDescriptor {
    public static final Point SIZE_16x16 = new Point(16, 16);
    public static final Point SIZE_22x16 = new Point(22, 16);
    public static final int TOP_RIGHT = 0;
    public static final int TOP_LEFT = 1;
    public static final int BOTTOM_RIGHT = 2;
    public static final int BOTTOM_LEFT = 3;
    private ImageDescriptor baseImage;
    private ImageDescriptor overlayImage;
    private int overlayPlacement;
    private Point size;

    public PHPDebugUICompositeImageDescriptor(ImageDescriptor baseImage, ImageDescriptor overlayImage, int overlayPlacement) {
        this(baseImage, overlayImage, overlayPlacement, SIZE_16x16);
    }

    public PHPDebugUICompositeImageDescriptor(ImageDescriptor baseImage, ImageDescriptor overlayImage, int overlayPlacement, Point size) {
        this.baseImage = baseImage;
        Assert.isNotNull((Object)this.baseImage);
        this.overlayImage = overlayImage;
        Assert.isNotNull((Object)this.overlayImage);
        this.overlayPlacement = overlayPlacement;
        Assert.isTrue((this.overlayPlacement >= 0 ? 1 : 0) != 0);
        this.size = size;
        Assert.isNotNull((Object)this.size);
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.size = size;
    }

    public Point getImageSize() {
        return new Point(this.size.x, this.size.y);
    }

    public boolean equals(Object object) {
        if (object == null || !PHPDebugUICompositeImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        PHPDebugUICompositeImageDescriptor other = (PHPDebugUICompositeImageDescriptor)((Object)object);
        return this.baseImage.equals(other.baseImage) && this.overlayImage.equals(other.overlayImage) && this.overlayPlacement == other.overlayPlacement;
    }

    public int hashCode() {
        return this.baseImage.hashCode() | this.overlayImage.hashCode() | this.overlayPlacement | this.size.hashCode();
    }

    protected Point getSize() {
        return this.size;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.baseImage);
        this.drawImage(bg, 0, 0);
        this.drawOverlay();
    }

    private void drawOverlay() {
        ImageData data = this.getImageData(this.overlayImage);
        switch (this.overlayPlacement) {
            case 0: {
                int x = this.size.x;
                this.drawImage(data, x -= data.width, 0);
                break;
            }
            case 1: {
                int x = 0;
                this.drawImage(data, x, 0);
                break;
            }
            case 2: {
                int x = this.size.x;
                this.drawImage(data, x -= data.width, this.size.y - data.height);
                break;
            }
            case 3: {
                int x = 0;
                this.drawImage(data, x, this.size.y - data.height);
                break;
            }
        }
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            PHPDebugUIPlugin.logErrorMessage("Image data not available: " + descriptor.toString());
        }
        return data;
    }
}

