/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ChangeBuildpathOperation;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.Util;

public class SetContainerOperation
extends ChangeBuildpathOperation {
    final IPath containerPath;
    final IScriptProject[] affectedProjects;
    final IBuildpathContainer[] respectiveContainers;

    public SetContainerOperation(IPath containerPath, IScriptProject[] affectedProjects, IBuildpathContainer[] respectiveContainers) {
        super(new IModelElement[]{ModelManager.getModelManager().getModel()}, !ResourcesPlugin.getWorkspace().isTreeLocked());
        this.containerPath = containerPath;
        this.affectedProjects = affectedProjects;
        this.respectiveContainers = respectiveContainers;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void executeOperation() throws ModelException {
        this.checkCanceled();
        try {
            this.beginTask("", 1);
            if (ModelManager.BP_RESOLVE_VERBOSE) {
                this.verboseSetContainer();
                this.verboseSetContainer_Trace();
            }
            if ((manager = ModelManager.getModelManager()).containerPutIfInitializingWithSameEntries(this.containerPath, this.affectedProjects, this.respectiveContainers)) {
                return;
            }
            projectLength = this.affectedProjects.length;
            modifiedProjects = new IScriptProject[projectLength];
            System.arraycopy(this.affectedProjects, 0, modifiedProjects, 0, projectLength);
            remaining = 0;
            i = 0;
            while (i < projectLength) {
                if (this.isCanceled()) {
                    return;
                }
                affectedProject = (ScriptProject)this.affectedProjects[i];
                newContainer = this.respectiveContainers[i];
                if (newContainer == null) {
                    newContainer = ModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS;
                }
                found = false;
                if (ScriptProject.hasScriptNature(affectedProject.getProject())) {
                    rawClasspath = affectedProject.getRawBuildpath();
                    j = 0;
                    cpLength = rawClasspath.length;
                    while (j < cpLength) {
                        entry = rawClasspath[j];
                        if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)this.containerPath)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!found) {
                    modifiedProjects[i] = null;
                    manager.containerPut(affectedProject, this.containerPath, newContainer);
                } else {
                    oldContainer = manager.containerGet(affectedProject, this.containerPath);
                    if (oldContainer == ModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
                        oldContainer = null;
                    }
                    if (oldContainer != null && oldContainer.equals(this.respectiveContainers[i]) || oldContainer == this.respectiveContainers[i]) {
                        modifiedProjects[i] = null;
                    } else {
                        ++remaining;
                        manager.containerPut(affectedProject, this.containerPath, newContainer);
                    }
                }
                ++i;
            }
            if (remaining == 0) {
                return;
            }
            try {
                i = 0;
                while (i < projectLength) {
                    block41: {
                        block42: {
                            if (!this.isCanceled()) break block42;
                            i = 0;
                            if (true) ** GOTO lbl91
                        }
                        affectedProject = (ScriptProject)modifiedProjects[i];
                        if (affectedProject != null) {
                            if (ModelManager.BP_RESOLVE_VERBOSE) {
                                this.verboseUpdateProject(affectedProject);
                            }
                            buildpathChange = affectedProject.getPerProjectInfo().resetResolvedBuildpath();
                            this.buildpathChanged(buildpathChange);
                            if (this.canChangeResources) {
                                try {
                                    affectedProject.getProject().touch(this.progressMonitor);
                                }
                                catch (CoreException e) {
                                    if (" ".equals(affectedProject.getElementName())) break block41;
                                    throw e;
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable var9_13) {
                i = 0;
                if (true) ** GOTO lbl103
            }
            {
                catch (CoreException e) {
                    if (ModelManager.BP_RESOLVE_VERBOSE) {
                        this.verboseFailure(e);
                    }
                    ModelException.propagate(e);
                    i = 0;
                    if (true) ** GOTO lbl97
                    break;
                }
            }
            i = 0;
            if (true) ** GOTO lbl109
            do {
                if (this.respectiveContainers[i] == null) {
                    manager.containerPut(this.affectedProjects[i], this.containerPath, null);
                }
                ++i;
lbl91:
                // 2 sources

            } while (i < projectLength);
            return;
            do {
                if (this.respectiveContainers[i] == null) {
                    manager.containerPut(this.affectedProjects[i], this.containerPath, null);
                }
                ++i;
lbl97:
                // 2 sources

            } while (i < projectLength);
            return;
            do {
                if (this.respectiveContainers[i] == null) {
                    manager.containerPut(this.affectedProjects[i], this.containerPath, null);
                }
                ++i;
lbl103:
                // 2 sources

            } while (i < projectLength);
            throw var9_13;
            do {
                if (this.respectiveContainers[i] == null) {
                    manager.containerPut(this.affectedProjects[i], this.containerPath, null);
                }
                ++i;
lbl109:
                // 2 sources

            } while (i < projectLength);
            return;
        }
        finally {
            this.done();
        }
    }

    private void verboseFailure(CoreException e) {
        Util.verbose("CPContainer SET  - FAILED DUE TO EXCEPTION\n\tcontainer path: " + String.valueOf(this.containerPath), System.err);
        e.printStackTrace();
    }

    private void verboseUpdateProject(ScriptProject affectedProject) {
        Util.verbose("BPContainer SET  - updating affected project due to setting container\n\tproject: " + affectedProject.getElementName() + "\n\tcontainer path: " + String.valueOf(this.containerPath));
    }

    private void verboseSetContainer_Trace() {
        new Exception("<Fake exception>").printStackTrace(System.out);
    }

    private void verboseSetContainer() {
        Util.verbose("BPContainer SET  - setting container\n\tcontainer path: " + String.valueOf(this.containerPath) + "\n\tprojects: {" + Util.toString(this.affectedProjects, o -> ((IScriptProject)o).getElementName()) + "}\n\tvalues: {\n" + Util.toString(this.respectiveContainers, o -> {
            StringBuilder buffer = new StringBuilder("\t\t");
            if (o == null) {
                buffer.append("<null>");
                return buffer.toString();
            }
            IBuildpathContainer container = (IBuildpathContainer)o;
            buffer.append(container.getDescription());
            buffer.append(" {\n");
            IBuildpathEntry[] entries = container.getBuildpathEntries();
            if (entries != null) {
                int i = 0;
                while (i < entries.length) {
                    buffer.append(" \t\t\t");
                    buffer.append(entries[i]);
                    buffer.append('\n');
                    ++i;
                }
            }
            buffer.append(" \t\t}");
            return buffer.toString();
        }) + "\n\t}\n\tinvocation stack trace:");
    }
}

