/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.dialogs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.NopTypeNameRequestor;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.TypeNameMatchRequestor;
import org.eclipse.dltk.core.search.TypeNameRequestor;
import org.eclipse.dltk.internal.core.search.DLTKSearchTypeNameMatch;
import org.eclipse.dltk.internal.corext.util.OpenTypeHistory;
import org.eclipse.dltk.internal.corext.util.Strings;
import org.eclipse.dltk.internal.corext.util.TypeFilter;
import org.eclipse.dltk.internal.corext.util.TypeInfoRequestorAdapter;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.dltk.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.internal.ui.util.TypeNameMatchLabelProvider;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.dltk.ui.dialogs.ITypeInfoImageProvider;
import org.eclipse.dltk.ui.dialogs.ITypeSelectionComponent;
import org.eclipse.dltk.ui.dialogs.TypeSelectionExtension;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SearchPattern;

public class FilteredTypesSelectionDialog
extends FilteredItemsSelectionDialog
implements ITypeSelectionComponent {
    private static final String DIALOG_SETTINGS = "org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog";
    private static final String WORKINGS_SET_SETTINGS = "WorkingSet";
    private WorkingSetFilterActionGroup fFilterActionGroup;
    private final TypeItemLabelProvider fTypeInfoLabelProvider;
    private String fTitle;
    private IDLTKSearchScope fSearchScope;
    private boolean fAllowScopeSwitching;
    private final int fElementKinds;
    private final ITypeInfoFilterExtension fFilterExtension;
    private final TypeSelectionExtension fExtension;
    private ISelectionStatusValidator fValidator;
    private final TypeInfoUtil fTypeInfoUtil;
    private static boolean fgFirstTime = true;
    private final TypeItemsComparator fTypeItemsComparator;
    private int fTypeFilterVersion = 0;
    private IDLTKLanguageToolkit fToolkit;

    public FilteredTypesSelectionDialog(Shell parent, boolean multi, IRunnableContext context, IDLTKSearchScope scope, int elementKinds, IDLTKLanguageToolkit toolkit) {
        this(parent, multi, context, scope, elementKinds, null, toolkit);
    }

    public FilteredTypesSelectionDialog(Shell shell, boolean multi, IRunnableContext context, IDLTKSearchScope scope, int elementKinds, TypeSelectionExtension extension, IDLTKLanguageToolkit toolkit) {
        super(shell, multi);
        this.fToolkit = toolkit;
        this.setSelectionHistory(new TypeSelectionHistory());
        if (scope == null) {
            this.fAllowScopeSwitching = true;
            scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
        }
        this.fElementKinds = elementKinds;
        this.fExtension = extension;
        this.fFilterExtension = extension == null ? null : extension.getFilterExtension();
        this.fSearchScope = scope;
        if (extension != null) {
            this.fValidator = extension.getSelectionValidator();
        }
        this.fTypeInfoUtil = new TypeInfoUtil(extension != null ? extension.getImageProvider() : null);
        this.fTypeInfoLabelProvider = new TypeItemLabelProvider();
        this.setListLabelProvider((ILabelProvider)this.fTypeInfoLabelProvider);
        this.setListSelectionLabelDecorator(this.fTypeInfoLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)new TypeItemDetailsLabelProvider(this.fTypeInfoUtil));
        this.fTypeItemsComparator = new TypeItemsComparator();
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.fTitle = title;
    }

    private void setSubtitle(String text) {
        if (text == null || text.length() == 0) {
            this.getShell().setText(this.fTitle);
        } else {
            this.getShell().setText(MessageFormat.format(DLTKUIMessages.FilteredTypeSelectionDialog_titleFormat, this.fTitle, text));
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = DLTKUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = DLTKUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
        if (this.fFilterActionGroup != null) {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"workingSet");
            this.fFilterActionGroup.saveState((IMemento)memento);
            this.fFilterActionGroup.dispose();
            StringWriter writer = new StringWriter();
            try {
                memento.save((Writer)writer);
                settings.put(WORKINGS_SET_SETTINGS, writer.getBuffer().toString());
            }
            catch (IOException e) {
                DLTKUIPlugin.log(e);
            }
        }
    }

    protected void restoreDialog(IDialogSettings settings) {
        super.restoreDialog(settings);
        this.fTypeInfoLabelProvider.setContainerInfo(true);
        if (this.fAllowScopeSwitching) {
            IWorkingSet ws;
            String setting = settings.get(WORKINGS_SET_SETTINGS);
            if (setting != null) {
                try {
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(setting));
                    this.fFilterActionGroup.restoreState((IMemento)memento);
                }
                catch (WorkbenchException e) {
                    DLTKUIPlugin.log(e);
                }
            }
            if ((ws = this.fFilterActionGroup.getWorkingSet()) == null || ws.isAggregateWorkingSet() && ws.isEmpty()) {
                this.setSearchScope(SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)this.fToolkit));
                this.setSubtitle(null);
            } else {
                this.setSearchScope(DLTKSearchScopeFactory.getInstance().createSearchScope(ws, true, this.fToolkit));
                this.setSubtitle(ws.getLabel());
            }
        }
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        if (this.fAllowScopeSwitching) {
            this.fFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), DLTKUIPlugin.getActivePage(), event -> {
                IWorkingSet ws = (IWorkingSet)event.getNewValue();
                if (ws == null || ws.isAggregateWorkingSet() && ws.isEmpty()) {
                    this.setSearchScope(SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)this.fToolkit));
                    this.setSubtitle(null);
                } else {
                    this.setSearchScope(DLTKSearchScopeFactory.getInstance().createSearchScope(ws, true, this.fToolkit));
                    this.setSubtitle(ws.getLabel());
                }
                this.applyFilter();
            });
            this.fFilterActionGroup.fillViewMenu(menuManager);
        }
    }

    protected Control createExtendedContentArea(Composite parent) {
        Control addition = null;
        if (this.fExtension != null) {
            addition = this.fExtension.createContentArea(parent);
            if (addition != null) {
                GridData gd = new GridData(768);
                gd.horizontalSpan = 2;
                addition.setLayoutData((Object)gd);
            }
            this.fExtension.initialize(this);
        }
        return addition;
    }

    protected void setResult(List newResult) {
        ArrayList<IType> resultToReturn = new ArrayList<IType>();
        int i = 0;
        while (i < newResult.size()) {
            if (newResult.get(i) instanceof TypeNameMatch) {
                IType type = ((TypeNameMatch)newResult.get(i)).getType();
                if (type.exists()) {
                    resultToReturn.add(type);
                } else {
                    TypeNameMatch typeInfo = (TypeNameMatch)newResult.get(i);
                    IProjectFragment root = typeInfo.getProjectFragment();
                    IDLTKUILanguageToolkit uiToolkit = DLTKUILanguageManager.getLanguageToolkit(this.fToolkit.getNatureId());
                    ScriptElementLabels labels = uiToolkit.getScriptElementLabels();
                    String containerName = labels.getElementLabel((IModelElement)root, ScriptElementLabels.ALL_FULLY_QUALIFIED);
                    String message = MessageFormat.format(DLTKUIMessages.FilteredTypesSelectionDialog_dialogMessage, typeInfo.getFullyQualifiedName(), containerName);
                    MessageDialog.openError((Shell)this.getShell(), (String)this.fTitle, (String)message);
                    this.getSelectionHistory().remove((Object)typeInfo);
                }
            }
            ++i;
        }
        super.setResult(resultToReturn);
    }

    public void create() {
        super.create();
        Control patternControl = this.getPatternControl();
        if (patternControl instanceof Text) {
            TextFieldNavigationHandler.install((Text)patternControl);
        }
    }

    public int open() {
        String text;
        ISelection selection;
        IWorkbenchWindow window;
        if (this.getInitialPattern() == null && (window = DLTKUIPlugin.getActiveWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) instanceof ITextSelection && (text = ((ITextSelection)selection).getText()) != null && (text = text.trim()).length() > 0) {
            this.setInitialPattern(text, 2);
        }
        return super.open();
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new TypeItemsFilter(this.fSearchScope, this.fElementKinds, this.fFilterExtension);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        return contents;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        TypeItemsFilter typeSearchFilter = (TypeItemsFilter)itemsFilter;
        TypeSearchRequestor requestor = new TypeSearchRequestor(provider, typeSearchFilter);
        String typePattern = itemsFilter.getPattern();
        progressMonitor.setTaskName(DLTKUIMessages.FilteredTypesSelectionDialog_searchJob_taskName);
        IType[] types = new ModelAccess().findTypes(typePattern, ModelAccess.convertSearchRule((int)itemsFilter.getMatchRule()), 0, 2048, typeSearchFilter.getSearchScope(), progressMonitor);
        if (types != null) {
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                requestor.acceptTypeNameMatch((TypeNameMatch)new DLTKSearchTypeNameMatch(type, type.getFlags()));
                ++n2;
            }
        } else {
            SearchEngine engine = new SearchEngine(null);
            String packPattern = typeSearchFilter.getPackagePattern();
            int matchRule = typeSearchFilter.getMatchRule();
            if (matchRule == 128) {
                char lastChar = typePattern.charAt(typePattern.length() - 1);
                if (lastChar == '<' || lastChar == ' ') {
                    typePattern = typePattern.substring(0, typePattern.length() - 1);
                } else {
                    typeSearchFilter.setMatchEverythingMode(true);
                }
            } else {
                typeSearchFilter.setMatchEverythingMode(true);
            }
            try {
                engine.searchAllTypeNames(packPattern == null ? null : packPattern.toCharArray(), typeSearchFilter.getPackageFlags(), typePattern.toCharArray(), matchRule, typeSearchFilter.getElementKind(), typeSearchFilter.getSearchScope(), (TypeNameMatchRequestor)requestor, 3, progressMonitor);
            }
            finally {
                typeSearchFilter.setMatchEverythingMode(false);
            }
        }
    }

    protected Comparator getItemsComparator() {
        return this.fTypeItemsComparator;
    }

    public String getElementName(Object item) {
        TypeNameMatch type = (TypeNameMatch)item;
        return this.fTypeInfoUtil.getText(type);
    }

    protected IStatus validateItem(Object item) {
        if (item == null) {
            return new Status(4, DLTKUIPlugin.getPluginId(), 4, "", null);
        }
        if (this.fValidator != null) {
            IType type = ((TypeNameMatch)item).getType();
            if (!type.exists()) {
                return new Status(4, DLTKUIPlugin.getPluginId(), 4, MessageFormat.format(DLTKUIMessages.FilteredTypesSelectionDialog_error_type_doesnot_exist, ((TypeNameMatch)item).getFullyQualifiedName()), null);
            }
            Object[] elements = new Object[]{type};
            return this.fValidator.validate(elements);
        }
        return new Status(0, DLTKUIPlugin.getPluginId(), 0, "", null);
    }

    private void setSearchScope(IDLTKSearchScope scope) {
        this.fSearchScope = scope;
    }

    public void reloadCache(boolean checkDuplicates, IProgressMonitor monitor) {
        SubMonitor remainingMonitor;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)DLTKUIMessages.TypeSelectionDialog_progress_consistency, (int)10);
        if (ConsistencyRunnable.needsExecution(this.fToolkit)) {
            try {
                ConsistencyRunnable runnable = new ConsistencyRunnable(this.fToolkit);
                runnable.run((IProgressMonitor)subMonitor.split(1));
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, DLTKUIMessages.TypeSelectionDialog_error3Title, DLTKUIMessages.TypeSelectionDialog_error3Message);
                this.close();
                return;
            }
            catch (InterruptedException e) {
                this.close();
                return;
            }
            remainingMonitor = subMonitor.split(9);
        } else {
            remainingMonitor = subMonitor;
        }
        super.reloadCache(checkDuplicates, (IProgressMonitor)remainingMonitor);
    }

    @Override
    public void triggerSearch() {
        ++this.fTypeFilterVersion;
        this.applyFilter();
    }

    private IDLTKUILanguageToolkit getUIToolkit() {
        return DLTKUILanguageManager.getLanguageToolkit(this.fToolkit.getNatureId());
    }

    private static class ConsistencyRunnable
    implements IRunnableWithProgress {
        private IDLTKUILanguageToolkit tookit;

        ConsistencyRunnable(IDLTKLanguageToolkit toolkit) {
            this.tookit = DLTKUILanguageManager.getLanguageToolkit(toolkit.getNatureId());
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (fgFirstTime) {
                IJobManager manager = Job.getJobManager();
                manager.join((Object)"org.eclipse.dltk.ui", monitor);
            }
            OpenTypeHistory history = OpenTypeHistory.getInstance(this.tookit);
            if (fgFirstTime || history.isEmpty()) {
                if (history.needConsistencyCheck()) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)DLTKUIMessages.TypeSelectionDialog_progress_consistency, (int)100);
                    this.refreshSearchIndices((IProgressMonitor)subMonitor.split(90));
                    history.checkConsistency((IProgressMonitor)subMonitor.split(10));
                } else {
                    this.refreshSearchIndices(monitor);
                }
                fgFirstTime = false;
            } else {
                history.checkConsistency(monitor);
            }
        }

        public static boolean needsExecution(IDLTKLanguageToolkit toolkit) {
            OpenTypeHistory history = OpenTypeHistory.getInstance(DLTKUILanguageManager.getLanguageToolkit(toolkit.getNatureId()));
            return fgFirstTime || history.isEmpty() || history.needConsistencyCheck();
        }

        private void refreshSearchIndices(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                new SearchEngine().searchAllTypeNames(null, 0, "_______________".toCharArray(), 8, 0, SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)this.tookit.getCoreToolkit()), (TypeNameRequestor)new NopTypeNameRequestor(), 3, monitor);
            }
            catch (ModelException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    private class TypeInfoUtil {
        private final ITypeInfoImageProvider fProviderExtension;
        private final TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
        private final Map<String, String> fLib2Name = new HashMap<String, String>();
        private final String[] fInstallLocations;
        private final String[] fVMNames;

        public TypeInfoUtil(ITypeInfoImageProvider extension) {
            this.fProviderExtension = extension;
            ArrayList<String> locations = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            IInterpreterInstallType[] installs = ScriptRuntime.getInterpreterInstallTypes((String)FilteredTypesSelectionDialog.this.fToolkit.getNatureId());
            int i = 0;
            while (i < installs.length) {
                this.processInterpreterInstallType(installs[i], locations, labels);
                ++i;
            }
            this.fInstallLocations = locations.toArray(new String[locations.size()]);
            this.fVMNames = labels.toArray(new String[labels.size()]);
        }

        private void processInterpreterInstallType(IInterpreterInstallType installType, List<String> locations, List<String> labels) {
            if (installType != null) {
                IInterpreterInstall[] installs = installType.getInterpreterInstalls();
                boolean isMac = "macosx".equals(Platform.getOS());
                String HOME_SUFFIX = "/Home";
                int i = 0;
                while (i < installs.length) {
                    String label = this.getFormattedLabel(installs[i].getName());
                    LibraryLocation[] libLocations = installs[i].getLibraryLocations();
                    if (libLocations != null) {
                        this.processLibraryLocation(libLocations, label);
                    } else {
                        String filePath = installs[i].getInstallLocation().toOSString();
                        if (filePath != null) {
                            if (isMac && filePath.endsWith("/Home")) {
                                filePath = filePath.substring(0, filePath.length() - "/Home".length() + 1);
                            }
                            locations.add(filePath);
                            labels.add(label);
                        }
                    }
                    ++i;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libLocations, String label) {
            int l = 0;
            while (l < libLocations.length) {
                LibraryLocation location = libLocations[l];
                this.fLib2Name.put(location.getLibraryPath().toOSString(), label);
                ++l;
            }
        }

        private String getFormattedLabel(String name) {
            return MessageFormat.format(DLTKUIMessages.FilteredTypesSelectionDialog_library_name_format, name);
        }

        public String getText(Object element) {
            return ((TypeNameMatch)element).getSimpleTypeName();
        }

        public String getQualifiedText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getSimpleTypeName());
            return result.toString();
        }

        public String getFullyQualifiedText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getSimpleTypeName());
            IType stype = type.getType();
            if (stype.getParent().getElementType() == 7) {
                result.append(" - ");
                IType parent = (IType)stype.getParent();
                result.append(parent.getTypeQualifiedName("."));
            }
            return result.toString();
        }

        public String getQualificationText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getType().getTypeQualifiedName("."));
            result.append(" - ");
            result.append(this.getContainerName(type));
            return result.toString();
        }

        private String getContainerName(TypeNameMatch type) {
            IProjectFragment root = type.getProjectFragment();
            if (root.isExternal()) {
                String name = root.getPath().toOSString();
                int i = 0;
                while (i < this.fInstallLocations.length) {
                    if (name.startsWith(this.fInstallLocations[i])) {
                        return this.fVMNames[i];
                    }
                    ++i;
                }
                String lib = this.fLib2Name.get(name);
                if (lib != null) {
                    return lib;
                }
            }
            StringBuffer buf = new StringBuffer();
            ScriptElementLabels labels = DLTKUILanguageManager.getLanguageToolkit(FilteredTypesSelectionDialog.this.fToolkit.getNatureId()).getScriptElementLabels();
            labels.getProjectFragmentLabel(root, 0x30000000000L, buf);
            return buf.toString();
        }
    }

    private class TypeItemDetailsLabelProvider
    extends LabelProvider {
        private TypeNameMatchLabelProvider fLabelProvider;
        private final TypeInfoUtil fTypeInfoUtil;

        public TypeItemDetailsLabelProvider(TypeInfoUtil typeInfoUtil) {
            this.fTypeInfoUtil = typeInfoUtil;
            this.fLabelProvider = new TypeNameMatchLabelProvider(17, DLTKUILanguageManager.getLanguageToolkit(FilteredTypesSelectionDialog.this.fToolkit.getNatureId()));
        }

        public Image getImage(Object element) {
            if (element instanceof TypeNameMatch) {
                return this.fLabelProvider.getImage(element);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof TypeNameMatch) {
                return this.fTypeInfoUtil.getQualificationText((TypeNameMatch)element);
            }
            return super.getText(element);
        }
    }

    private class TypeItemLabelProvider
    extends LabelProvider
    implements ILabelDecorator {
        private boolean fContainerInfo;

        public void setContainerInfo(boolean containerInfo) {
            this.fContainerInfo = containerInfo;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }

        public Image getImage(Object element) {
            if (!(element instanceof TypeNameMatch)) {
                return super.getImage(element);
            }
            TypeNameMatch type = (TypeNameMatch)element;
            ImageDescriptor iD = ScriptElementImageProvider.getTypeImageDescriptor(type.getModifiers(), false);
            return DLTKUIPlugin.getImageDescriptorRegistry().get(iD);
        }

        public String getText(Object element) {
            if (!(element instanceof TypeNameMatch)) {
                return super.getText(element);
            }
            if (this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(element)) {
                return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getFullyQualifiedText((TypeNameMatch)element);
            }
            if (!this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(element)) {
                return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getQualifiedText((TypeNameMatch)element);
            }
            return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getText(element);
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }

        public String decorateText(String text, Object element) {
            if (!(element instanceof TypeNameMatch)) {
                return null;
            }
            if (this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(element)) {
                return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getFullyQualifiedText((TypeNameMatch)element);
            }
            return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getQualifiedText((TypeNameMatch)element);
        }
    }

    private class TypeItemsComparator
    implements Comparator<TypeNameMatch> {
        private final Map<String, String> fLib2Name = new HashMap<String, String>();
        private final String[] fInstallLocations;
        private final String[] fVMNames;

        public TypeItemsComparator() {
            ArrayList<String> locations = new ArrayList<String>();
            ArrayList<String> labels = new ArrayList<String>();
            IInterpreterInstallType[] installs = ScriptRuntime.getInterpreterInstallTypes();
            int i = 0;
            while (i < installs.length) {
                this.processVMInstallType(installs[i], locations, labels);
                ++i;
            }
            this.fInstallLocations = locations.toArray(new String[locations.size()]);
            this.fVMNames = labels.toArray(new String[labels.size()]);
        }

        private void processVMInstallType(IInterpreterInstallType installType, List<String> locations, List<String> labels) {
            if (installType != null) {
                IInterpreterInstall[] installs = installType.getInterpreterInstalls();
                boolean isMac = "macosx".equals(Platform.getOS());
                String HOME_SUFFIX = "/Home";
                int i = 0;
                while (i < installs.length) {
                    String label = this.getFormattedLabel(installs[i].getName());
                    LibraryLocation[] libLocations = installs[i].getLibraryLocations();
                    if (libLocations != null) {
                        this.processLibraryLocation(libLocations, label);
                    } else {
                        String filePath = installs[i].getInstallLocation().toOSString();
                        if (isMac && filePath.endsWith("/Home")) {
                            filePath = filePath.substring(0, filePath.length() - "/Home".length() + 1);
                        }
                        locations.add(filePath);
                        labels.add(label);
                    }
                    ++i;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libLocations, String label) {
            int l = 0;
            while (l < libLocations.length) {
                LibraryLocation location = libLocations[l];
                this.fLib2Name.put(location.getLibraryPath().toString(), label);
                ++l;
            }
        }

        private String getFormattedLabel(String name) {
            return NLS.bind((String)DLTKUIMessages.FilteredTypesSelectionDialog_library_name_format, (Object)name);
        }

        @Override
        public int compare(TypeNameMatch leftInfo, TypeNameMatch rightInfo) {
            int rightCategory;
            int result = this.compareName(leftInfo.getSimpleTypeName(), rightInfo.getSimpleTypeName());
            if (result != 0) {
                return result;
            }
            result = this.compareTypeContainerName(leftInfo.getTypeContainerName(), rightInfo.getTypeContainerName());
            if (result != 0) {
                return result;
            }
            int leftCategory = this.getElementTypeCategory(leftInfo);
            if (leftCategory < (rightCategory = this.getElementTypeCategory(rightInfo))) {
                return -1;
            }
            if (leftCategory > rightCategory) {
                return 1;
            }
            return this.compareContainerName(leftInfo, rightInfo);
        }

        private int compareName(String leftString, String rightString) {
            int result = leftString.compareToIgnoreCase(rightString);
            if (result != 0 || rightString.length() == 0) {
                return result;
            }
            if (Strings.isLowerCase(leftString.charAt(0)) && !Strings.isLowerCase(rightString.charAt(0))) {
                return 1;
            }
            if (Strings.isLowerCase(rightString.charAt(0)) && !Strings.isLowerCase(leftString.charAt(0))) {
                return -1;
            }
            return leftString.compareTo(rightString);
        }

        private int compareTypeContainerName(String leftString, String rightString) {
            int leftLength = leftString.length();
            int rightLength = rightString.length();
            if (leftLength == 0 && rightLength > 0) {
                return -1;
            }
            if (leftLength == 0 && rightLength == 0) {
                return 0;
            }
            if (leftLength > 0 && rightLength == 0) {
                return 1;
            }
            return this.compareName(leftString, rightString);
        }

        private int compareContainerName(TypeNameMatch leftType, TypeNameMatch rightType) {
            return this.getContainerName(leftType).compareTo(this.getContainerName(rightType));
        }

        private String getContainerName(TypeNameMatch type) {
            IProjectFragment root = type.getProjectFragment();
            if (root.isExternal()) {
                String name = root.getPath().toOSString();
                int i = 0;
                while (i < this.fInstallLocations.length) {
                    if (name.startsWith(this.fInstallLocations[i])) {
                        return this.fVMNames[i];
                    }
                    ++i;
                }
                String lib = this.fLib2Name.get(name);
                if (lib != null) {
                    return lib;
                }
            }
            StringBuffer buf = new StringBuffer();
            ScriptElementLabels labels = FilteredTypesSelectionDialog.this.getUIToolkit().getScriptElementLabels();
            labels.getProjectFragmentLabel(root, 0x30000000000L, buf);
            return buf.toString();
        }

        private int getElementTypeCategory(TypeNameMatch type) {
            try {
                if (type.getProjectFragment().getKind() == 1) {
                    return 0;
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
            return 1;
        }
    }

    private class TypeItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private static final int TYPE_MODIFIERS = 4104;
        private final IDLTKSearchScope fScope;
        private final boolean fIsWorkspaceScope;
        private final int fElemKind;
        private final ITypeInfoFilterExtension fFilterExt;
        private final TypeInfoRequestorAdapter fAdapter;
        private SearchPattern fPackageMatcher;
        private boolean fMatchEverything;
        private final int fMyTypeFilterVersion;

        public TypeItemsFilter(IDLTKSearchScope scope, int elementKind, ITypeInfoFilterExtension extension) {
            super((FilteredItemsSelectionDialog)FilteredTypesSelectionDialog.this, (SearchPattern)new TypeSearchPattern());
            this.fAdapter = new TypeInfoRequestorAdapter();
            this.fMatchEverything = false;
            this.fMyTypeFilterVersion = FilteredTypesSelectionDialog.this.fTypeFilterVersion;
            this.fScope = scope;
            this.fIsWorkspaceScope = scope == null ? false : scope.equals(SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)FilteredTypesSelectionDialog.this.fToolkit));
            this.fElemKind = elementKind;
            this.fFilterExt = extension;
            String stringPackage = ((TypeSearchPattern)this.patternMatcher).getPackagePattern();
            if (stringPackage != null) {
                this.fPackageMatcher = new SearchPattern();
                this.fPackageMatcher.setPattern(stringPackage);
            } else {
                this.fPackageMatcher = null;
            }
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            TypeItemsFilter typeItemsFilter = (TypeItemsFilter)filter;
            if (this.fScope != typeItemsFilter.getSearchScope()) {
                return false;
            }
            if (this.fMyTypeFilterVersion != typeItemsFilter.getMyTypeFilterVersion()) {
                return false;
            }
            return this.getPattern().indexOf(46, filter.getPattern().length()) == -1;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter iFilter) {
            if (!super.equalsFilter(iFilter)) {
                return false;
            }
            if (!(iFilter instanceof TypeItemsFilter)) {
                return false;
            }
            TypeItemsFilter typeItemsFilter = (TypeItemsFilter)iFilter;
            if (this.fScope != typeItemsFilter.getSearchScope()) {
                return false;
            }
            return this.fMyTypeFilterVersion == typeItemsFilter.getMyTypeFilterVersion();
        }

        public int getElementKind() {
            return this.fElemKind;
        }

        public IDLTKSearchScope getSearchScope() {
            return this.fScope;
        }

        public int getMyTypeFilterVersion() {
            return this.fMyTypeFilterVersion;
        }

        public String getPackagePattern() {
            if (this.fPackageMatcher == null) {
                return null;
            }
            return this.fPackageMatcher.getPattern();
        }

        public int getPackageFlags() {
            if (this.fPackageMatcher == null) {
                return 0;
            }
            return this.fPackageMatcher.getMatchRule();
        }

        public boolean matchesRawNamePattern(TypeNameMatch type) {
            return Strings.startsWithIgnoreCase(type.getSimpleTypeName(), this.getPattern());
        }

        public boolean matchesFilterExtension(TypeNameMatch type) {
            if (this.fFilterExt == null) {
                return true;
            }
            this.fAdapter.setMatch(type);
            return this.fFilterExt.select(this.fAdapter);
        }

        private boolean matchesName(TypeNameMatch type) {
            return this.matches(type.getSimpleTypeName());
        }

        private boolean matchesPackage(TypeNameMatch type) {
            if (this.fPackageMatcher == null) {
                return true;
            }
            return this.fPackageMatcher.matches(type.getPackageName());
        }

        private boolean matchesScope(TypeNameMatch type) {
            if (this.fIsWorkspaceScope) {
                return true;
            }
            return this.fScope.encloses((IModelElement)type.getType());
        }

        private boolean matchesModifiers(TypeNameMatch type) {
            if (this.fElemKind == 0) {
                return true;
            }
            int modifiers = type.getModifiers() & 0x1008;
            switch (this.fElemKind) {
                case 0: {
                    return modifiers == 0;
                }
                case 8: {
                    return false;
                }
            }
            return false;
        }

        public void setMatchEverythingMode(boolean matchEverything) {
            this.fMatchEverything = matchEverything;
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            if (this.fMatchEverything) {
                return true;
            }
            TypeNameMatch type = (TypeNameMatch)item;
            if (!(this.matchesPackage(type) && this.matchesModifiers(type) && this.matchesScope(type) && this.matchesFilterExtension(type))) {
                return false;
            }
            return this.matchesName(type);
        }

        public boolean matchesRawNamePattern(Object item) {
            TypeNameMatch type = (TypeNameMatch)item;
            return this.matchesRawNamePattern(type);
        }
    }

    private static class TypeSearchPattern
    extends SearchPattern {
        private String packagePattern;

        private TypeSearchPattern() {
        }

        public void setPattern(String stringPattern) {
            String pattern = stringPattern;
            String packPattern = null;
            int index = stringPattern.lastIndexOf(".");
            if (index != -1) {
                packPattern = this.evaluatePackagePattern(stringPattern.substring(0, index));
                pattern = stringPattern.substring(index + 1);
                if (pattern.length() == 0) {
                    pattern = "**";
                }
            }
            super.setPattern(pattern);
            this.packagePattern = packPattern;
        }

        private String evaluatePackagePattern(String s) {
            StringBuffer buf = new StringBuffer();
            boolean hasWildCard = false;
            int i = 0;
            while (i < s.length()) {
                char ch = s.charAt(i);
                if (ch == '.') {
                    if (!hasWildCard) {
                        buf.append('*');
                    }
                    hasWildCard = false;
                } else if (ch == '*' || ch == '?') {
                    hasWildCard = true;
                }
                buf.append(ch);
                ++i;
            }
            if (!hasWildCard) {
                buf.append('*');
            }
            return buf.toString();
        }

        protected boolean isNameCharAllowed(char nameChar) {
            return super.isNameCharAllowed(nameChar);
        }

        protected boolean isPatternCharAllowed(char patternChar) {
            return super.isPatternCharAllowed(patternChar);
        }

        protected boolean isValidCamelCaseChar(char ch) {
            return super.isValidCamelCaseChar(ch);
        }

        public String getPackagePattern() {
            return this.packagePattern;
        }
    }

    private class TypeSearchRequestor
    extends TypeNameMatchRequestor {
        private volatile boolean fStop;
        private final FilteredItemsSelectionDialog.AbstractContentProvider fContentProvider;
        private final TypeItemsFilter fTypeItemsFilter;
        Set<String> addedNames = new HashSet<String>();

        public TypeSearchRequestor(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, TypeItemsFilter typeItemsFilter) {
            this.fContentProvider = contentProvider;
            this.fTypeItemsFilter = typeItemsFilter;
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            if (this.fStop) {
                return;
            }
            if (new TypeFilter(DLTKUILanguageManager.getLanguageToolkit(FilteredTypesSelectionDialog.this.fToolkit.getNatureId())).isFiltered(match)) {
                return;
            }
            if (!this.addedNames.contains(match.getTypeQualifiedName())) {
                this.addedNames.add(match.getTypeQualifiedName());
                if (this.fTypeItemsFilter.matchesFilterExtension(match)) {
                    this.fContentProvider.add((Object)match, (FilteredItemsSelectionDialog.ItemsFilter)this.fTypeItemsFilter);
                }
            }
        }
    }

    protected class TypeSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        public synchronized void accessed(Object object) {
            super.accessed(object);
        }

        public synchronized boolean remove(Object element) {
            OpenTypeHistory.getInstance(FilteredTypesSelectionDialog.this.getUIToolkit()).remove((TypeNameMatch)element);
            return super.remove(element);
        }

        public void load(IMemento memento) {
            TypeNameMatch[] types = OpenTypeHistory.getInstance(FilteredTypesSelectionDialog.this.getUIToolkit()).getTypeInfos();
            int i = 0;
            while (i < types.length) {
                TypeNameMatch type = types[i];
                this.accessed(type);
                ++i;
            }
        }

        public void save(IMemento memento) {
            this.persistHistory();
        }

        private synchronized void persistHistory() {
            if (FilteredTypesSelectionDialog.this.getReturnCode() == 0) {
                Object[] items = this.getHistoryItems();
                int i = 0;
                while (i < items.length) {
                    OpenTypeHistory.getInstance(FilteredTypesSelectionDialog.this.getUIToolkit()).accessed((TypeNameMatch)items[i]);
                    ++i;
                }
            }
        }

        protected Object restoreItemFromMemento(IMemento element) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
        }
    }
}

