/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.security;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.cdo.server.internal.security.bundle.OM;
import org.eclipse.emf.cdo.server.spi.security.SecurityManagerFactory;
import org.eclipse.emf.cdo.spi.server.AbstractAppExtension;
import org.eclipse.emf.cdo.spi.server.IAppExtension2;
import org.eclipse.emf.cdo.spi.server.IAppExtension4;
import org.eclipse.emf.cdo.spi.server.IAppExtension5;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryFactory;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SecurityExtension
extends AbstractAppExtension
implements IAppExtension2,
IAppExtension4,
IAppExtension5 {
    public static final String DEFAULT_REALM_PATH = "security";
    public static final String DEFAULT_FACTORY_TYPE = "default";

    public String getName() {
        return "Security";
    }

    public boolean startBeforeRepositories() {
        return false;
    }

    public int getPriority() {
        return 100;
    }

    public void start(File configFile) throws Exception {
        this.start(this.getDocument(configFile));
    }

    public void startDynamic(Reader xmlConfigReader) throws Exception {
        this.start(this.getDocument(xmlConfigReader));
    }

    protected void start(Document document) throws Exception {
        NodeList children = document.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element childElement;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && (childElement = (Element)child).getNodeName().equalsIgnoreCase("repository")) {
                this.configureRepository(childElement);
            }
            ++i;
        }
    }

    public void stop() throws Exception {
    }

    protected Document getDocument(Reader configReader) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(configReader));
    }

    protected void configureRepository(Element repositoryConfig) {
        String repositoryName;
        IManagedContainer container = this.getContainer();
        InternalRepository repository = (InternalRepository)RepositoryFactory.get((IManagedContainer)container, (String)(repositoryName = repositoryConfig.getAttribute("name")));
        if (repository == null) {
            throw new IllegalStateException("Repository not registered with container: " + repositoryName);
        }
        NodeList securityManagers = repositoryConfig.getElementsByTagName("securityManager");
        if (securityManagers.getLength() > 1) {
            throw new IllegalStateException("A maximum of one security manager can be configured for repository " + repository);
        }
        if (securityManagers.getLength() == 1) {
            String description;
            Element securityManagerElement = (Element)securityManagers.item(0);
            String type = this.getAttribute(securityManagerElement, "type");
            if (StringUtil.isEmpty((String)type)) {
                type = DEFAULT_FACTORY_TYPE;
            }
            if (StringUtil.isEmpty((String)(description = this.getAttribute(securityManagerElement, "description")))) {
                description = this.getAttribute(securityManagerElement, "realmPath");
            }
            if (StringUtil.isEmpty((String)description)) {
                description = DEFAULT_REALM_PATH;
            }
            if (SecurityManagerFactory.get(container, type, repositoryName, description) != null) {
                OM.LOG.info("Security manager for repository " + repositoryName + ": " + description);
            }
        }
    }
}

