/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.modulecore.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jem.util.emf.workbench.WorkbenchByteArrayOutputStream;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.internal.modulecore.util.ArchiveManifest;
import org.eclipse.jst.common.internal.modulecore.util.ArchiveManifestImpl;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;

public class ManifestUtilities {
    public static final String MANIFEST_HEADER = "Manifest-Version: 1.0\r\nClass-Path: \r\n\r\n";
    private static ConcurrentHashMap<String, String> manifestClasspaths = new ConcurrentHashMap();

    public static void createManifestFile(IFile file) throws CoreException, IOException {
        WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(file);
        out.write(MANIFEST_HEADER.getBytes());
        out.close();
    }

    public static String[] getTokens(String aString) {
        return ManifestUtilities.getTokens(aString, null);
    }

    public static String[] getTokens(String aString, String delimiter) {
        StringTokenizer tok = delimiter == null ? new StringTokenizer(aString) : new StringTokenizer(aString, delimiter);
        int size = tok.countTokens();
        String[] tokens = new String[size];
        int i = 0;
        while (i < size && tok.hasMoreTokens()) {
            tokens[i] = tok.nextToken();
            ++i;
        }
        return tokens;
    }

    public static String getValueIgnoreKeyCase(String key, Attributes attr) {
        for (Map.Entry<Object, Object> entry : attr.entrySet()) {
            String entryKey = entry.getKey().toString();
            if (!entryKey.equalsIgnoreCase(key)) continue;
            return entry.getValue() == null ? null : entry.getValue().toString();
        }
        return null;
    }

    public static ArchiveManifest getManifest(IVirtualComponent component, IPath manifestPath) {
        if (!component.isBinary()) {
            return ManifestUtilities.getNonBinaryComponentManifest(component, manifestPath);
        }
        return ManifestUtilities.getBinaryComponentManifest(component, manifestPath);
    }

    public static ArchiveManifest getBinaryComponentManifest(IVirtualComponent component, IPath manifestPath) {
        File file = (File)component.getAdapter(File.class);
        if (file != null && file.exists()) {
            ArchiveManifest manifest = ManifestUtilities.readBinaryManifest(file, manifestPath);
            return manifest;
        }
        return null;
    }

    public static ArchiveManifest getManifest(IFile f) {
        File f2 = f.getLocation().toFile();
        return ManifestUtilities.getManifest(f2);
    }

    public static ArchiveManifest getManifest(File f) {
        if (f != null && f.exists()) {
            try {
                FileInputStream in = new FileInputStream(f);
                ArchiveManifestImpl manifest = new ArchiveManifestImpl(in);
                return manifest;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static void writeManifest(IFile aFile, ArchiveManifest manifest) throws IOException {
        WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(aFile);
        manifest.writeSplittingClasspath((OutputStream)out);
        out.close();
    }

    public static ArchiveManifest getNonBinaryComponentManifest(IVirtualComponent component, IPath manifestPath) {
        block7: {
            ArchiveManifestImpl archiveManifestImpl;
            block8: {
                IVirtualFile vManifest;
                if (component.isBinary() || !(vManifest = component.getRootFolder().getFile(manifestPath)).exists()) break block7;
                IFile manifestFile = vManifest.getUnderlyingFile();
                InputStream in = null;
                try {
                    ArchiveManifestImpl manifest;
                    in = manifestFile.getContents();
                    archiveManifestImpl = manifest = new ArchiveManifestImpl(in);
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                            in = null;
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        break block7;
                    }
                    catch (CoreException coreException) {}
                }
                in.close();
                in = null;
            }
            return archiveManifestImpl;
        }
        return null;
    }

    public static String[] getManifestClasspath(IVirtualComponent component, IPath manifestPath) {
        ArchiveManifest mf = ManifestUtilities.getManifest(component, manifestPath);
        if (mf != null) {
            return mf.getClassPathTokenized();
        }
        return new String[0];
    }

    public static ArchiveManifest readBinaryManifest(File file, IPath manifestPath) {
        ArchiveManifestImpl manifest;
        block6: {
            manifest = null;
            ZipFile zipFile = null;
            if (file != null) {
                try {
                    zipFile = ManifestUtilities.newZipFile(file);
                    ZipEntry entry = zipFile.getEntry(manifestPath.toString());
                    if (entry != null) {
                        InputStream entryStream = ManifestUtilities.getInputstreamForZipEntry(zipFile, manifestPath.toString());
                        manifest = new ArchiveManifestImpl(entryStream);
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {
                    if (zipFile == null) break block6;
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
        }
        return manifest;
    }

    public static InputStream getInputstreamForZipEntry(ZipFile zipFile, String uri) throws IOException {
        try {
            ZipEntry entry = zipFile.getEntry(uri);
            if (entry == null) {
                char[] chars = uri.toCharArray();
                int[] slashIndices = new int[chars.length];
                int slashCount = 0;
                int i = 0;
                while (i < uri.length()) {
                    if (chars[i] == '/' || chars[i] == '\\') {
                        slashIndices[slashCount] = i;
                        ++slashCount;
                    }
                    ++i;
                }
                int slashPow = (int)Math.pow(2.0, slashCount);
                boolean foundIt = false;
                int i2 = 0;
                while (i2 < slashPow && !foundIt) {
                    int j = 0;
                    while (j < slashCount) {
                        chars[slashIndices[j]] = (i2 >> j & 1) == 1 ? 47 : 92;
                        ++j;
                    }
                    entry = zipFile.getEntry(new String(chars));
                    if (entry != null) {
                        foundIt = true;
                    }
                    ++i2;
                }
                if (entry == null) {
                    FileNotFoundException del = new FileNotFoundException(uri);
                    throw new IOException(del.toString());
                }
            }
            return new BufferedInputStream(zipFile.getInputStream(entry));
        }
        catch (IllegalStateException zipClosed) {
            throw new IOException(zipClosed.toString());
        }
    }

    public static String[] getNonBinaryComponentManifestClasspath(IVirtualComponent component, IPath manifestPath) throws IOException, CoreException {
        IVirtualFile vManifest;
        String[] manifestClasspath = null;
        if (!component.isBinary() && (vManifest = component.getRootFolder().getFile(manifestPath)).exists()) {
            IFile manifestFile = vManifest.getUnderlyingFile();
            InputStream in = null;
            try {
                in = manifestFile.getContents();
                ArchiveManifestImpl manifest = new ArchiveManifestImpl(in);
                manifestClasspath = manifest.getClassPathTokenized();
            }
            finally {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
        }
        return manifestClasspath;
    }

    public static ZipFile newZipFile(String fileName) throws ZipException, IOException {
        return ManifestUtilities.newZipFile(new File(fileName), 1);
    }

    public static ZipFile newZipFile(File aFile) throws ZipException, IOException {
        return ManifestUtilities.newZipFile(aFile, 1);
    }

    public static ZipFile newZipFile(File aFile, int mode) throws ZipException, IOException {
        return new ZipFile(aFile, mode){
            Collection<InputStream> openStreams = null;

            @Override
            public InputStream getInputStream(ZipEntry entry) throws IOException {
                InputStream in = super.getInputStream(entry);
                if (in != null) {
                    if (this.openStreams == null) {
                        this.openStreams = new ArrayList<InputStream>();
                    }
                    this.openStreams.add(in);
                }
                return in;
            }

            @Override
            public void close() throws IOException {
                this.closeOpenStreams();
                super.close();
            }

            private void closeOpenStreams() {
                if (this.openStreams != null) {
                    Iterator<InputStream> iterator = this.openStreams.iterator();
                    while (iterator.hasNext()) {
                        InputStream in = iterator.next();
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            Logger.getLogger().logWarning((Throwable)e);
                        }
                        iterator.remove();
                    }
                }
            }
        };
    }

    /*
     * Loose catch block
     */
    public static ArchiveManifest readManifest(IFile aFile) {
        ArchiveManifestImpl archiveManifestImpl;
        InputStream in;
        block16: {
            block14: {
                block15: {
                    in = null;
                    if (aFile != null && aFile.exists()) break block14;
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
            in = aFile.getContents();
            archiveManifestImpl = new ArchiveManifestImpl(in);
            if (in == null) break block16;
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return archiveManifestImpl;
        catch (Exception exception) {
            block17: {
                try {
                    if (in == null) break block17;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    public static void updateManifestClasspath(IFile manifestFile, List dynamicURIs, OutputStream outputStream) throws IOException, FileNotFoundException {
        ManifestUtilities.updateManifestClasspathImpl(manifestFile, dynamicURIs, null, outputStream);
    }

    public static void updateManifestClasspath(IFile manifestFile, List dynamicURIs, File outputFile) throws IOException, FileNotFoundException {
        ManifestUtilities.updateManifestClasspathImpl(manifestFile, dynamicURIs, outputFile, null);
    }

    private static void updateManifestClasspathImpl(IFile manifestFile, List dynamicURIs, File outputFile, OutputStream stream) throws IOException, FileNotFoundException {
        try (OutputStream outputStream = stream;){
            InputStream in = null;
            ArchiveManifestImpl manifest = null;
            try {
                try {
                    in = manifestFile.getContents();
                    manifest = new ArchiveManifestImpl(in);
                }
                catch (CoreException ce) {
                    throw new IOException(ce.getLocalizedMessage());
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                        in = null;
                    }
                    catch (IOException e) {
                        Logger.getLogger().logWarning((Throwable)e);
                    }
                }
            }
            String[] manifestClasspath = manifest.getClassPathTokenized();
            ArrayList<String> updatedCP = new ArrayList<String>();
            int i = 0;
            while (i < manifestClasspath.length) {
                updatedCP.add(manifestClasspath[i]);
                ++i;
            }
            int j = 0;
            while (j < dynamicURIs.size()) {
                String containerURI = (String)dynamicURIs.get(j);
                boolean exists = false;
                int i2 = 0;
                while (i2 < manifestClasspath.length) {
                    if (manifestClasspath[i2].equals(containerURI)) {
                        exists = true;
                        break;
                    }
                    ++i2;
                }
                if (!exists) {
                    updatedCP.add(containerURI);
                }
                ++j;
            }
            StringBuffer cpBuffer = new StringBuffer();
            boolean first = true;
            int j2 = 0;
            while (j2 < updatedCP.size()) {
                if (!first) {
                    cpBuffer.append(" ");
                } else {
                    first = false;
                }
                cpBuffer.append((String)updatedCP.get(j2));
                ++j2;
            }
            String cp = cpBuffer.toString();
            if (outputStream != null) {
                manifest.setClassPath(cp);
                manifest.write(outputStream);
                outputStream.flush();
            } else {
                String manifestPath = manifestFile.getFullPath().toString();
                String priorClasspath = manifestClasspaths.get(manifestPath);
                if (priorClasspath == null || !priorClasspath.equals(cp) || !outputFile.exists()) {
                    manifestClasspaths.put(manifestPath, cp);
                    manifest.setClassPath(cp);
                    outputStream = new FileOutputStream(outputFile);
                    manifest.write(outputStream);
                    outputStream.flush();
                }
            }
        }
    }
}

