/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.context;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.IViewRootHandle;

final class ViewRootHolder
implements IViewRootHandle,
Cloneable {
    private final Object _recalcViewRootExclusion;
    private final DTFacesContext _facesContext;
    private DTUIViewRoot _viewRoot;
    private final List<DTUIViewRoot.StalenessListener> _waitingToAdd;
    private final List<DTUIViewRoot.StalenessListener> _waitingToRemove;

    public ViewRootHolder(DTFacesContext facesContext, Object recalcViewRootExclusion) {
        this._facesContext = facesContext;
        this._recalcViewRootExclusion = recalcViewRootExclusion;
        this._waitingToAdd = new ArrayList<DTUIViewRoot.StalenessListener>();
        this._waitingToRemove = new ArrayList<DTUIViewRoot.StalenessListener>();
    }

    private ViewRootHolder(ViewRootHolder cloneFrom) {
        this._recalcViewRootExclusion = cloneFrom._recalcViewRootExclusion;
        this._facesContext = cloneFrom._facesContext;
        this._viewRoot = cloneFrom.getCachedViewRoot();
        this._waitingToAdd = new ArrayList<DTUIViewRoot.StalenessListener>();
        this._waitingToRemove = new ArrayList<DTUIViewRoot.StalenessListener>();
    }

    @Override
    public synchronized DTUIViewRoot getCachedViewRoot() {
        return this._viewRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DTUIViewRoot updateViewRoot() {
        DTUIViewRoot viewRoot = null;
        IResource contextResource = this._facesContext.adaptContextObject();
        Object object = this._recalcViewRootExclusion;
        synchronized (object) {
            IDTViewHandler viewHandler;
            viewRoot = this.getCachedViewRoot();
            if ((viewRoot == null || viewRoot.isStale()) && (viewHandler = this._facesContext.getViewHandler(contextResource)) != null) {
                String viewId = viewHandler.getViewId(this._facesContext, contextResource);
                try {
                    viewRoot = viewHandler.createView(this._facesContext, viewId);
                    if (viewRoot != null) {
                        this.setCachedViewRoot(viewRoot);
                    }
                    for (DTUIViewRoot.StalenessListener addListener : this._waitingToAdd) {
                        viewRoot.addListener(addListener);
                    }
                    for (DTUIViewRoot.StalenessListener removeListener : this._waitingToRemove) {
                        viewRoot.removeListener(removeListener);
                    }
                }
                catch (IDTViewHandler.ViewHandlerException e) {
                    JSFCorePlugin.log(e, "While creating dt viewroot for viewId: " + viewId);
                }
            }
        }
        return viewRoot;
    }

    private synchronized void setCachedViewRoot(DTUIViewRoot newViewRoot) {
        if (!Thread.holdsLock(this._recalcViewRootExclusion)) {
            throw new IllegalStateException("Must hold _recalcViewRootExclusion to modify view root");
        }
        this._viewRoot = newViewRoot;
    }

    protected synchronized IViewRootHandle clone() {
        return new ViewRootHolder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DTUIViewRoot.StalenessListener listener) {
        if (this._viewRoot != null) {
            ViewRootHolder viewRootHolder = this;
            synchronized (viewRootHolder) {
                this._viewRoot.addListener(listener);
            }
        }
        Object object = this._recalcViewRootExclusion;
        synchronized (object) {
            ViewRootHolder viewRootHolder = this;
            synchronized (viewRootHolder) {
                this._waitingToAdd.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DTUIViewRoot.StalenessListener listener) {
        DTUIViewRoot viewRoot = null;
        Object object = this;
        synchronized (object) {
            viewRoot = this._viewRoot;
        }
        if (viewRoot != null) {
            object = this;
            synchronized (object) {
                viewRoot.removeListener(listener);
            }
        }
        object = this._recalcViewRootExclusion;
        synchronized (object) {
            ViewRootHolder viewRootHolder = this;
            synchronized (viewRootHolder) {
                this._waitingToAdd.add(listener);
            }
        }
    }
}

