/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.pde.target.BNDInstructions;
import org.eclipse.m2e.pde.target.DependencyDepth;
import org.eclipse.m2e.pde.target.DomXmlFeature;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.m2e.pde.target.MavenTargetDependencyFilter;
import org.eclipse.m2e.pde.target.MavenTargetLocation;
import org.eclipse.m2e.pde.target.MavenTargetRepository;
import org.eclipse.m2e.pde.target.MissingMetadataMode;
import org.eclipse.pde.core.target.ITargetLocationFactory;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenTargetLocationFactory
implements ITargetLocationFactory {
    private static final String ATTRIBUTE_DEPENDENCY_SCOPE = "includeDependencyScope";

    public MavenTargetLocation getTargetLocation(String type, String serializedXML) throws CoreException {
        try {
            Element location = MavenTargetLocationFactory.parseXMLDocument(serializedXML).getDocumentElement();
            MissingMetadataMode mode = this.parseMissingMetadataMode(location);
            DependencyDepth dependencyDepth = this.parseDependencyDepth(location);
            Collection<String> locationScopes = this.parseDependencyScopes(location);
            List<MavenTargetDependency> dependencies = MavenTargetLocationFactory.descendants(location, "dependency").map(MavenTargetLocationFactory::parseDependency).toList();
            if (dependencies.isEmpty()) {
                dependencies = List.of(MavenTargetLocationFactory.parseDependency(location));
            }
            List<MavenTargetRepository> repositories = MavenTargetLocationFactory.descendants(location, "repository").map(element -> {
                String id = MavenTargetLocationFactory.getText("id", element);
                String url = MavenTargetLocationFactory.getText("url", element);
                return new MavenTargetRepository(id, url);
            }).toList();
            List<BNDInstructions> instructions = MavenTargetLocationFactory.descendants(location, "instructions").map(element -> {
                String reference = element.getAttribute("reference");
                return new BNDInstructions(reference, element.getTextContent());
            }).toList();
            List<String> excludes = MavenTargetLocationFactory.descendants(location, "exclude").map(Node::getTextContent).toList();
            IFeature templateFeature = MavenTargetLocationFactory.descendants(location, "feature").map(DomXmlFeature::new).findFirst().orElse(null);
            String label = location.getAttribute("label");
            boolean includeSource = Boolean.parseBoolean(location.getAttribute("includeSource"));
            return new MavenTargetLocation(label, dependencies, repositories, mode, dependencyDepth, locationScopes, includeSource, instructions, excludes, templateFeature);
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
    }

    private Collection<String> parseDependencyScopes(Element location) {
        LinkedHashSet<String> locationScopesSet = new LinkedHashSet<String>();
        if (location.hasAttribute("includeDependencyScopes")) {
            String dependencyScopes = location.getAttribute("includeDependencyScopes");
            String[] stringArray = dependencyScopes.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String scope = stringArray[n2];
                locationScopesSet.add(scope.strip().toLowerCase(Locale.ENGLISH));
                ++n2;
            }
        } else {
            String dependencyScope = location.getAttribute(ATTRIBUTE_DEPENDENCY_SCOPE);
            locationScopesSet.addAll(MavenTargetDependencyFilter.expandScope(dependencyScope));
        }
        return locationScopesSet;
    }

    private DependencyDepth parseDependencyDepth(Element location) {
        if (location.hasAttribute("includeDependencyDepth")) {
            return MavenTargetLocationFactory.parseEnumAttribute(location, "includeDependencyDepth", DependencyDepth::valueOf, DependencyDepth.NONE);
        }
        if (location.getAttribute(ATTRIBUTE_DEPENDENCY_SCOPE).isEmpty()) {
            return DependencyDepth.NONE;
        }
        return DependencyDepth.INFINITE;
    }

    private MissingMetadataMode parseMissingMetadataMode(Element location) {
        return MavenTargetLocationFactory.parseEnumAttribute(location, "missingManifest", MissingMetadataMode::valueOf, MissingMetadataMode.ERROR);
    }

    private static MavenTargetDependency parseDependency(Element element) {
        String artifactId = MavenTargetLocationFactory.getText("artifactId", element);
        String groupId = MavenTargetLocationFactory.getText("groupId", element);
        String version = MavenTargetLocationFactory.getText("version", element);
        String artifactType = MavenTargetLocationFactory.getText("type", element);
        String classifier = MavenTargetLocationFactory.getText("classifier", element);
        return new MavenTargetDependency(groupId, artifactId, version, artifactType, classifier);
    }

    private static String getText(String tagName, Element location) {
        return MavenTargetLocationFactory.descendants(location, tagName).map(Node::getTextContent).filter(Objects::nonNull).findFirst().orElse("");
    }

    public static Document parseXMLDocument(String serializedXML) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return docBuilder.parse(new ByteArrayInputStream(serializedXML.getBytes(StandardCharsets.UTF_8)));
    }

    private static Stream<Element> descendants(Element parent, String name) {
        return MavenTargetLocationFactory.elements(parent.getElementsByTagName(name));
    }

    public static Stream<Element> elements(NodeList list) {
        return IntStream.range(0, list.getLength()).mapToObj(list::item).filter(Element.class::isInstance).map(Element.class::cast);
    }

    private static <T> T parseEnumAttribute(Element location, String attribute, Function<String, T> parser, T defaultValue) {
        try {
            return parser.apply(location.getAttribute(attribute).toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }
}

