/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.protocol.JSON;

class MemoryMapItemDialog
extends Dialog {
    private final Map<String, Object> props;
    private final boolean enable_editing;
    private Text addr_text;
    private Text size_text;
    private Text offset_text;
    private Text query_text;
    private Text file_text;
    private Button loc_original;
    private Button loc_addrress;
    private Button loc_offset;
    private Button rd_button;
    private Button wr_button;
    private Button ex_button;
    private Color text_enabled;
    private Color text_disabled;

    MemoryMapItemDialog(Shell parent, Map<String, Object> props, boolean enable_editing) {
        super(parent);
        this.props = props;
        this.enable_editing = enable_editing;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Symbol File");
        shell.setImage(ImageCache.getImage("icons/memory-map"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.enable_editing) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createStatusFields(composite);
        this.createFileNameFields(composite);
        this.createAddressFields(composite);
        this.createPropsFields(composite);
        this.createQueryFields(composite);
        this.setData();
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    protected void createStatusFields(Composite parent) {
    }

    private void createFileNameFields(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label file_label = new Label(composite, 64);
        file_label.setLayoutData((Object)new GridData(32));
        file_label.setFont(font);
        file_label.setText("File name:");
        GridData gd = new GridData(768);
        gd.widthHint = 400;
        this.file_text = new Text(composite, 2052);
        this.file_text.setLayoutData((Object)gd);
        this.file_text.setFont(font);
        if (!this.enable_editing) {
            this.file_text.setEditable(false);
            this.file_text.setBackground(parent.getBackground());
        }
        this.file_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MemoryMapItemDialog.this.updateButtons();
            }
        });
        Button button = new Button(composite, 8);
        button.setFont(font);
        button.setText("...");
        button.setLayoutData((Object)new GridData(32));
        button.setEnabled(this.enable_editing);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog file_dialog = new FileDialog(MemoryMapItemDialog.this.getShell(), 0);
                file_dialog.setFileName(MemoryMapItemDialog.this.file_text.getText());
                String path = file_dialog.open();
                if (path != null) {
                    MemoryMapItemDialog.this.file_text.setText(path);
                }
            }
        });
    }

    private void createAddressFields(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Memory location");
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        this.loc_original = new Button((Composite)group, 16);
        this.loc_original.setText("No relocation: use program headers from the file");
        this.loc_original.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MemoryMapItemDialog.this.loc_original.getSelection()) {
                    MemoryMapItemDialog.this.updateButtons();
                }
            }
        });
        this.loc_offset = new Button((Composite)group, 16);
        this.loc_offset.setText("Offset - difference between load address and link address");
        this.loc_offset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MemoryMapItemDialog.this.loc_offset.getSelection()) {
                    MemoryMapItemDialog.this.updateButtons();
                }
            }
        });
        this.loc_addrress = new Button((Composite)group, 16);
        this.loc_addrress.setText("Absolute memory address");
        this.loc_addrress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MemoryMapItemDialog.this.loc_addrress.getSelection()) {
                    MemoryMapItemDialog.this.updateButtons();
                }
            }
        });
        GridData gd = new GridData();
        gd.widthHint = 200;
        this.addr_text = new Text((Composite)group, 2052);
        this.addr_text.setLayoutData((Object)gd);
        this.addr_text.setFont(font);
        this.text_enabled = this.addr_text.getBackground();
        this.text_disabled = parent.getBackground();
        this.addr_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MemoryMapItemDialog.this.updateButtons();
            }
        });
    }

    private void createPropsFields(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setFont(font);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        this.createTextFields(composite);
        this.createFlagsGroup(composite);
    }

    private void createTextFields(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        composite.setLayoutData((Object)gd);
        Label size_label = new Label(composite, 64);
        size_label.setLayoutData((Object)new GridData(32));
        size_label.setFont(font);
        size_label.setText("Size:");
        this.size_text = new Text(composite, 2052);
        this.size_text.setLayoutData((Object)new GridData(768));
        this.size_text.setFont(font);
        Label offset_label = new Label(composite, 64);
        offset_label.setLayoutData((Object)new GridData(32));
        offset_label.setFont(font);
        offset_label.setText("File offset:");
        this.offset_text = new Text(composite, 2052);
        this.offset_text.setLayoutData((Object)new GridData(768));
        this.offset_text.setFont(font);
    }

    private void createFlagsGroup(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        group.setFont(font);
        group.setText("Flags");
        this.rd_button = new Button((Composite)group, 32);
        this.rd_button.setFont(font);
        this.rd_button.setText("Data read");
        this.rd_button.setLayoutData((Object)new GridData(768));
        this.wr_button = new Button((Composite)group, 32);
        this.wr_button.setFont(font);
        this.wr_button.setText("Data write");
        this.wr_button.setLayoutData((Object)new GridData(768));
        this.ex_button = new Button((Composite)group, 32);
        this.ex_button.setFont(font);
        this.ex_button.setText("Instructions read");
        this.ex_button.setLayoutData((Object)new GridData(768));
    }

    private void createQueryFields(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label query_label = new Label(composite, 64);
        query_label.setLayoutData((Object)new GridData(32));
        query_label.setFont(font);
        query_label.setText("Context query:");
        this.query_text = new Text(composite, 2052);
        this.query_text.setLayoutData((Object)new GridData(768));
        this.query_text.setFont(font);
        if (!this.enable_editing) {
            this.query_text.setEditable(false);
            this.query_text.setBackground(parent.getBackground());
        }
    }

    private String toHex(Number n) {
        if (n == null) {
            return null;
        }
        BigInteger x = JSON.toBigInteger((Number)n);
        String s = x.toString(16);
        int l = 16 - s.length();
        if (l < 0) {
            l = 0;
        }
        if (l > 16) {
            l = 16;
        }
        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
    }

    private void setText(Text text, String str) {
        if (str == null) {
            str = "";
        }
        text.setText(str);
    }

    private void setData() {
        if (this.props.get("Addr") != null) {
            this.setText(this.addr_text, this.toHex((Number)this.props.get("Addr")));
            this.loc_addrress.setSelection(true);
        } else if (this.props.get("BaseAddress") != null) {
            this.setText(this.addr_text, this.toHex((Number)this.props.get("BaseAddress")));
            this.loc_offset.setSelection(true);
        } else {
            this.addr_text.setText("");
            this.loc_original.setSelection(true);
        }
        this.setText(this.size_text, this.toHex((Number)this.props.get("Size")));
        if (this.props.get("SectionName") != null) {
            this.setText(this.offset_text, (String)this.props.get("SectionName"));
        } else {
            this.setText(this.offset_text, this.toHex((Number)this.props.get("Offs")));
        }
        this.setText(this.query_text, (String)this.props.get("ContextQuery"));
        this.setText(this.file_text, (String)this.props.get("FileName"));
        int flags = 0;
        Number n = (Number)this.props.get("Flags");
        if (n != null) {
            flags = n.intValue();
        }
        this.rd_button.setSelection((flags & 1) != 0);
        this.wr_button.setSelection((flags & 2) != 0);
        this.ex_button.setSelection((flags & 4) != 0);
        this.updateButtons();
    }

    private void getNumber(Text text, String key) {
        String s = text.getText().trim();
        if (s == null || s.length() == 0) {
            this.props.remove(key);
        } else if (s.startsWith("0x")) {
            this.props.put(key, new BigInteger(s.substring(2), 16));
        } else {
            this.props.put(key, new BigInteger(s));
        }
    }

    private void getText(Text text, String key) {
        String s = text.getText().trim();
        if (s == null || s.length() == 0) {
            this.props.remove(key);
        } else {
            this.props.put(key, s);
        }
    }

    private void getData() {
        this.props.remove("Addr");
        this.props.remove("BaseAddress");
        this.props.remove("Size");
        this.props.remove("Offs");
        this.props.remove("SectionName");
        this.getText(this.file_text, "FileName");
        if (this.loc_addrress.getSelection()) {
            this.getNumber(this.addr_text, "Addr");
            this.getNumber(this.size_text, "Size");
            String s = this.offset_text.getText().trim();
            if (s.length() > 0 && !Character.isDigit(s.charAt(0))) {
                this.props.put("SectionName", s);
            } else {
                this.getNumber(this.offset_text, "Offs");
            }
        } else if (this.loc_offset.getSelection()) {
            this.getNumber(this.addr_text, "BaseAddress");
        }
        int flags = 0;
        if (this.rd_button.getSelection()) {
            flags |= 1;
        }
        if (this.wr_button.getSelection()) {
            flags |= 2;
        }
        if (this.ex_button.getSelection()) {
            flags |= 4;
        }
        this.props.put("Flags", flags);
        this.getText(this.query_text, "ContextQuery");
    }

    private void updateButtons() {
        Button btn = this.getButton(0);
        if (btn != null) {
            btn.setEnabled(!this.enable_editing || this.file_text != null && this.file_text.getText().trim().length() > 0 || this.addr_text != null && this.addr_text.getText().trim().length() > 0);
        }
        this.loc_original.setEnabled(this.enable_editing);
        this.loc_offset.setEnabled(this.enable_editing);
        this.loc_addrress.setEnabled(this.enable_editing);
        if (!this.enable_editing || this.loc_original.getSelection()) {
            this.addr_text.setEditable(false);
            this.addr_text.setBackground(this.text_disabled);
        } else {
            this.addr_text.setEditable(true);
            this.addr_text.setBackground(this.text_enabled);
        }
        if (!this.enable_editing || this.loc_original.getSelection() || this.loc_offset.getSelection()) {
            this.size_text.setEditable(false);
            this.size_text.setBackground(this.text_disabled);
            this.offset_text.setEditable(false);
            this.offset_text.setBackground(this.text_disabled);
            this.rd_button.setEnabled(false);
            this.wr_button.setEnabled(false);
            this.ex_button.setEnabled(false);
        } else {
            this.size_text.setEditable(true);
            this.size_text.setBackground(this.text_enabled);
            this.offset_text.setEditable(true);
            this.offset_text.setBackground(this.text_enabled);
            this.rd_button.setEnabled(true);
            this.wr_button.setEnabled(true);
            this.ex_button.setEnabled(true);
        }
    }

    protected void okPressed() {
        if (this.enable_editing) {
            try {
                this.getData();
            }
            catch (Throwable x) {
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setText("Invalid data");
                mb.setMessage(TCFModel.getErrorMessage(x, true));
                mb.open();
                return;
            }
        }
        super.okPressed();
    }
}

