/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IStackTrace;
import org.eclipse.tcf.util.TCFDataCache;

public class TCFChildrenStackTrace
extends TCFChildren {
    private final TCFNodeExecContext node;
    private final IStackTrace service;
    private String top_frame_id;
    private int limit_factor = 1;

    TCFChildrenStackTrace(TCFNodeExecContext node) {
        super(node, 16);
        this.node = node;
        this.service = (IStackTrace)node.model.getLaunch().getService(IStackTrace.class);
    }

    void onSourceMappingChange() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onSourceMappingChange();
        }
    }

    void onExpressionAddedOrRemoved() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onExpressionAddedOrRemoved();
        }
    }

    void onSuspended(boolean func_call) {
        this.limit_factor = 1;
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onSuspended(func_call);
        }
        this.reset();
    }

    void onRegistersChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onRegistersChanged();
        }
        this.reset();
    }

    void onMemoryMapChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onMemoryMapChanged();
        }
        this.reset();
    }

    void onMemoryChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onMemoryChanged();
        }
        this.reset();
    }

    void onRegisterValueChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).onRegisterValueChanged();
        }
        this.reset();
    }

    void onPreferencesChanged() {
        this.reset();
    }

    void riseTraceLimit() {
        ++this.limit_factor;
        this.reset();
    }

    void postAllChangedDelta() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeStackFrame)n).postAllChangedDelta();
        }
    }

    Boolean checkHasChildren(Runnable done) {
        TCFDataCache<TCFContextState> state = this.node.getMinState();
        if (!state.validate(done)) {
            return null;
        }
        if (state.getError() != null) {
            return false;
        }
        TCFContextState state_data = (TCFContextState)state.getData();
        if (state_data == null) {
            return false;
        }
        if (!state_data.is_suspended) {
            return false;
        }
        if (state_data.isNotActive()) {
            return false;
        }
        return true;
    }

    public TCFNodeStackFrame getTopFrame() {
        assert (this.isValid());
        return (TCFNodeStackFrame)this.node.model.getNode(this.top_frame_id);
    }

    @Override
    public void set(IToken token, Throwable error, Map<String, TCFNode> data) {
        for (TCFNode n : this.getNodes()) {
            if (data != null && data.get(n.id) != null) continue;
            ((TCFNodeStackFrame)n).setFrameNo(-1);
        }
        super.set(token, error, data);
    }

    private void addEmulatedTopFrame(HashMap<String, TCFNode> data) {
        this.top_frame_id = String.valueOf(this.node.id) + "-TF";
        TCFNodeStackFrame n = (TCFNodeStackFrame)this.node.model.getNode(this.top_frame_id);
        if (n == null) {
            n = new TCFNodeStackFrame(this.node, this.top_frame_id, true);
        }
        n.setFrameNo(0);
        n.setTraceLimit(false);
        data.put(n.id, n);
    }

    private void runCompleteStackTrace(final HashMap<String, TCFNode> data) {
        this.command = this.service.getChildren(this.node.id, new IStackTrace.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                if (TCFChildrenStackTrace.this.command == token) {
                    if (error == null && contexts != null) {
                        int limit_value = 0;
                        boolean limit_enabled = ((TCFChildrenStackTrace)TCFChildrenStackTrace.this).node.model.getStackFramesLimitEnabled();
                        if (limit_enabled && (limit_value = ((TCFChildrenStackTrace)TCFChildrenStackTrace.this).node.model.getStackFramesLimitValue() * TCFChildrenStackTrace.this.limit_factor) <= 0) {
                            limit_value = TCFChildrenStackTrace.this.limit_factor;
                        }
                        int cnt = contexts.length;
                        String[] stringArray = contexts;
                        int n = contexts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String id = stringArray[n2];
                            if (!limit_enabled || --cnt <= limit_value) {
                                TCFNodeStackFrame n3 = (TCFNodeStackFrame)((TCFChildrenStackTrace)TCFChildrenStackTrace.this).node.model.getNode(id);
                                if (n3 == null) {
                                    n3 = new TCFNodeStackFrame(TCFChildrenStackTrace.this.node, id, false);
                                }
                                if (!$assertionsDisabled && n3.parent != TCFChildrenStackTrace.this.node) {
                                    throw new AssertionError();
                                }
                                n3.setFrameNo(cnt);
                                n3.setTraceLimit(limit_enabled && cnt == limit_value);
                                data.put(id, n3);
                                if (cnt == 0) {
                                    TCFChildrenStackTrace.this.top_frame_id = id;
                                }
                            }
                            ++n2;
                        }
                    }
                    if (data.size() == 0) {
                        TCFChildrenStackTrace.this.addEmulatedTopFrame(data);
                    }
                    TCFChildrenStackTrace.this.set(token, (Throwable)error, data);
                }
            }
        });
    }

    private void runIncrementalStackTrace(final HashMap<String, TCFNode> data) {
        int n = this.node.model.getStackFramesLimitValue() * this.limit_factor;
        if (n <= 0) {
            n = this.limit_factor;
        }
        final int limit_value = n;
        this.command = this.service.getChildrenRange(this.node.id, 0, limit_value, new IStackTrace.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                if (TCFChildrenStackTrace.this.command == token) {
                    if (error instanceof IErrorReport && ((IErrorReport)error).getErrorCode() == 25) {
                        ((TCFChildrenStackTrace)TCFChildrenStackTrace.this).node.model.no_incremental_trace = true;
                        TCFChildrenStackTrace.this.runCompleteStackTrace(data);
                        return;
                    }
                    if (error == null && contexts != null) {
                        int cnt = 0;
                        String[] stringArray = contexts;
                        int n = contexts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String id = stringArray[n2];
                            TCFNodeStackFrame n3 = (TCFNodeStackFrame)((TCFChildrenStackTrace)TCFChildrenStackTrace.this).node.model.getNode(id);
                            if (n3 == null) {
                                n3 = new TCFNodeStackFrame(TCFChildrenStackTrace.this.node, id, false);
                            }
                            if (!$assertionsDisabled && n3.parent != TCFChildrenStackTrace.this.node) {
                                throw new AssertionError();
                            }
                            n3.setFrameNo(cnt);
                            n3.setTraceLimit(cnt == limit_value);
                            data.put(id, n3);
                            if (cnt == 0) {
                                TCFChildrenStackTrace.this.top_frame_id = id;
                            }
                            ++cnt;
                            ++n2;
                        }
                    }
                    if (data.size() == 0) {
                        TCFChildrenStackTrace.this.addEmulatedTopFrame(data);
                    }
                    TCFChildrenStackTrace.this.set(token, (Throwable)error, data);
                }
            }
        });
    }

    protected boolean startDataRetrieval() {
        Boolean has_children = this.checkHasChildren((Runnable)((Object)this));
        if (has_children == null) {
            return false;
        }
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        if (!has_children.booleanValue()) {
            this.top_frame_id = null;
            TCFDataCache<TCFContextState> state = this.node.getMinState();
            if (!state.validate((Runnable)((Object)this))) {
                return false;
            }
            this.set(null, state.getError(), data);
            return true;
        }
        if (this.service == null) {
            this.addEmulatedTopFrame(data);
            this.set(null, null, data);
            return true;
        }
        assert (this.command == null);
        if (this.node.model.no_incremental_trace || !this.node.model.getStackFramesLimitEnabled()) {
            this.runCompleteStackTrace(data);
        } else {
            this.runIncrementalStackTrace(data);
        }
        return false;
    }
}

