/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class LoadQueriesHandler extends AbstractHandler {
  public static final String COMMAND_ID = "org.eclipse.viatra.query.tooling.ui.result.loadqueries";

  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    final ISelection selection = HandlerUtil.getCurrentSelection(event);
    final IViewPart resultView = HandlerUtil.getActiveSite(event).getPage().findView(QueryResultView.ID);
    if ((resultView instanceof QueryResultView)) {
      final boolean active = ((QueryResultView)resultView).hasActiveEngine();
      if ((active && (selection instanceof IStructuredSelection))) {
        final Set<QueryRegistryTreeEntry> selectedQueries = QueryResultViewUtil.getRegistryEntriesFromSelection(((IStructuredSelection) selection));
        ((QueryResultView)resultView).loadQueriesIntoActiveEngineInBackground(selectedQueries);
      } else {
        LoadQueriesHandler.queryLoadingFailed(((QueryResultView)resultView).getSite().getShell());
      }
    }
    return null;
  }

  public static void queryLoadingFailed(final Shell parent) {
    MessageDialog.openError(parent, "Query loading failed", 
      "Please load a model into the Query Results view before loading queries!");
  }
}
