/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.completion;

import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IJavaType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;

public class VariableDeclarationCompletionProposal
implements ICompletionProposal {
    private final IType type;

    public VariableDeclarationCompletionProposal(IType type) {
        this.type = type;
    }

    @Override
    public String getProposal() {
        String name;
        IType rawType = this.type;
        while (rawType instanceof ICollectionType) {
            rawType = ((ICollectionType)rawType).getCollectionType();
        }
        if (rawType instanceof EClassifierType) {
            name = ((EClassifierType)rawType).getType().getName();
        } else if (rawType instanceof NothingType) {
            name = "Nothing";
        } else if (rawType instanceof IJavaType) {
            name = ((Class)((IJavaType)rawType).getType()).getSimpleName();
        } else {
            throw new IllegalArgumentException("Cannot handle input type " + rawType);
        }
        String result = "my" + name + " | ";
        return result;
    }

    @Override
    public int getCursorOffset() {
        return this.getProposal().length();
    }

    @Override
    public IType getObject() {
        return this.type;
    }

    public String toString() {
        return this.getProposal();
    }

    @Override
    public String getDescription() {
        return this.toString();
    }
}

