/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.launch.DownloadFileDialog;
import org.eclipse.tcf.internal.debug.ui.launch.TCFTargetTab;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.PlatformUI;

public class TCFDownloadTab
extends AbstractLaunchConfigurationTab {
    private TableViewer viewer;
    private Button button_add;
    private Button button_edit;
    private Button button_remove;
    private MenuItem item_add;
    private MenuItem item_edit;
    private MenuItem item_remove;
    private static final String[] column_ids = new String[]{"Context", "File"};
    private static final int[] column_size = new int[]{300, 400};
    private final List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
    private static final String TAB_ID = "org.eclipse.tcf.launch.downloadTab";
    private Exception init_error;

    public String getName() {
        return "Download";
    }

    public Image getImage() {
        return ImageCache.getImage("icons/download_tab");
    }

    public String getId() {
        return TAB_ID;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createTable(composite);
        this.setControl((Control)composite);
    }

    private void createTable(Composite parent) {
        Font font = parent.getFont();
        Label map_label = new Label(parent, 64);
        map_label.setLayoutData((Object)new GridData(768));
        map_label.setFont(font);
        map_label.setText("Files to download during launch:");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer = new TableViewer(composite, 68354);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        this.viewer.setContentProvider((IContentProvider)new FileListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FileListLabelProvider());
        this.viewer.setColumnProperties(column_ids);
        int i = 0;
        while (i < column_ids.length) {
            TableColumn c = new TableColumn(table, 0, i);
            c.setText(column_ids[i]);
            c.setWidth(column_size[i]);
            ++i;
        }
        this.createTableButtons(composite);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TCFDownloadTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (TCFDownloadTab.this.button_edit.isEnabled()) {
                    TCFDownloadTab.this.onEdit((IStructuredSelection)TCFDownloadTab.this.viewer.getSelection());
                }
            }
        });
    }

    private void createTableButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(272);
        composite.setLayoutData((Object)gd);
        Menu menu = new Menu((Control)this.viewer.getTable());
        SelectionAdapter sel_adapter = null;
        this.button_add = new Button(composite, 8);
        this.button_add.setText(" &Add... ");
        gd = new GridData(256);
        this.button_add.setLayoutData((Object)gd);
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                DownloadFileDialog dialog = new DownloadFileDialog(TCFDownloadTab.this.getShell(), TCFDownloadTab.this.getPeerID(), m);
                if (dialog.open() == 0) {
                    TCFDownloadTab.this.list.add(m);
                    TCFDownloadTab.this.viewer.add(m);
                    TCFDownloadTab.this.viewer.setSelection((ISelection)new StructuredSelection(m), true);
                    TCFDownloadTab.this.viewer.getTable().setFocus();
                    TCFDownloadTab.this.updateLaunchConfigurationDialog();
                }
            }
        };
        this.button_add.addSelectionListener((SelectionListener)sel_adapter);
        this.item_add = new MenuItem(menu, 8);
        this.item_add.setText("&Add...");
        this.item_add.addSelectionListener((SelectionListener)sel_adapter);
        this.item_add.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        this.button_edit = new Button(composite, 8);
        this.button_edit.setText(" &Edit... ");
        this.button_edit.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TCFDownloadTab.this.onEdit((IStructuredSelection)TCFDownloadTab.this.viewer.getSelection());
            }
        };
        this.button_edit.addSelectionListener((SelectionListener)sel_adapter);
        this.item_edit = new MenuItem(menu, 8);
        this.item_edit.setText("&Edit...");
        this.item_edit.addSelectionListener((SelectionListener)sel_adapter);
        this.button_remove = new Button(composite, 8);
        this.button_remove.setText(" &Remove ");
        this.button_remove.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Map m : (IStructuredSelection)TCFDownloadTab.this.viewer.getSelection()) {
                    TCFDownloadTab.this.list.remove(m);
                    TCFDownloadTab.this.viewer.remove((Object)m);
                }
                TCFDownloadTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.button_remove.addSelectionListener((SelectionListener)sel_adapter);
        this.item_remove = new MenuItem(menu, 8);
        this.item_remove.setText("&Remove");
        this.item_remove.addSelectionListener((SelectionListener)sel_adapter);
        this.item_remove.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
        this.viewer.getTable().setMenu(menu);
    }

    private void onEdit(IStructuredSelection selection) {
        Map m = (Map)selection.getFirstElement();
        DownloadFileDialog dialog = new DownloadFileDialog(this.getShell(), this.getPeerID(), m);
        dialog.open();
        this.viewer.refresh((Object)m);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)m), true);
        this.viewer.getTable().setFocus();
        this.updateLaunchConfigurationDialog();
    }

    private String getPeerID() {
        String peer_id = "TCP:127.0.0.1:1534";
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.getLaunchConfigurationDialog().getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab t = iLaunchConfigurationTabArray[n2];
            if (t instanceof TCFTargetTab) {
                peer_id = ((TCFTargetTab)t).getPeerID();
            }
            ++n2;
        }
        return peer_id;
    }

    protected final TableViewer getViewer() {
        return this.viewer;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        try {
            this.list.clear();
            final String s = config.getAttribute("org.eclipse.tcf.debug.Files", "");
            this.list.addAll((Collection)new TCFTask<Collection<Map<String, Object>>>(10000L){

                public void run() {
                    try {
                        ArrayList l = new ArrayList();
                        if (s != null && s.length() > 0) {
                            Collection c = (Collection)JSON.parseOne((byte[])s.getBytes("UTF-8"));
                            for (Map m : c) {
                                l.add(new HashMap(m));
                            }
                        }
                        this.done(l);
                    }
                    catch (Throwable e) {
                        this.error(e);
                    }
                }
            }.get());
            this.viewer.setInput((Object)config);
            this.button_remove.setEnabled(!this.viewer.getSelection().isEmpty());
            this.button_edit.setEnabled(((IStructuredSelection)this.viewer.getSelection()).size() == 1);
            this.item_remove.setEnabled(!this.viewer.getSelection().isEmpty());
            this.item_edit.setEnabled(((IStructuredSelection)this.viewer.getSelection()).size() == 1);
        }
        catch (Exception e) {
            this.init_error = e;
            this.setErrorMessage("Cannot read launch configuration: " + e);
            Activator.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.list.size() == 0) {
            config.removeAttribute("org.eclipse.tcf.debug.Files");
        } else {
            String s = (String)new TCFTask<String>(10000L){

                public void run() {
                    try {
                        this.done(JSON.toJSON((Object)TCFDownloadTab.this.list));
                    }
                    catch (Throwable e) {
                        this.error(e);
                    }
                }
            }.getE();
            config.setAttribute("org.eclipse.tcf.debug.Files", s);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.removeAttribute("org.eclipse.tcf.debug.Files");
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.button_remove.setEnabled(!this.viewer.getSelection().isEmpty());
        this.button_edit.setEnabled(((IStructuredSelection)this.viewer.getSelection()).size() == 1);
        this.item_remove.setEnabled(!this.viewer.getSelection().isEmpty());
        this.item_edit.setEnabled(((IStructuredSelection)this.viewer.getSelection()).size() == 1);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setMessage(null);
        if (this.init_error != null) {
            this.setErrorMessage("Cannot read launch configuration: " + this.init_error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private class FileListContentProvider
    implements IStructuredContentProvider {
        private FileListContentProvider() {
        }

        public Object[] getElements(Object input) {
            return TCFDownloadTab.this.list.toArray(new Map[TCFDownloadTab.this.list.size()]);
        }

        public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
        }

        public void dispose() {
        }
    }

    private class FileListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FileListLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            if (column == 0) {
                return ImageCache.getImage("icons/attribute");
            }
            return null;
        }

        public String getColumnText(Object element, int column) {
            Map e = (Map)element;
            Object o = e.get(column_ids[column]);
            if (o == null) {
                return "";
            }
            return o.toString();
        }
    }
}

