/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import org.apache.wsil.Abstract;
import org.apache.wsil.Base64Converter;
import org.apache.wsil.Description;
import org.apache.wsil.DocumentReader;
import org.apache.wsil.DocumentWriter;
import org.apache.wsil.Inspection;
import org.apache.wsil.Link;
import org.apache.wsil.Service;
import org.apache.wsil.ServiceName;
import org.apache.wsil.WSILDocumentFactory;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionRegistry;
import org.apache.wsil.xml.XMLReader;
import org.apache.wsil.xml.XMLWriter;

public abstract class WSILDocument {
    protected DocumentReader docReader = new XMLReader();
    protected DocumentWriter docWriter = new XMLWriter();
    protected ExtensionRegistry extRegistry = null;
    protected Inspection inspection = null;
    protected String documentURL = null;

    public abstract Abstract createAbstract();

    public abstract Description createDescription();

    public abstract Link createLink();

    public abstract Service createService();

    public abstract ServiceName createServiceName();

    public ExtensionRegistry getExtensionRegistry() {
        return this.extRegistry;
    }

    public Inspection getInspection() {
        return this.inspection;
    }

    public DocumentReader getReader() {
        return this.docReader;
    }

    public DocumentWriter getWriter() {
        return this.docWriter;
    }

    public static void main(String[] args) {
        String filename = null;
        if (args.length == 0) {
            System.out.println("Usage: WSILDocument <filename>");
        } else {
            try {
                filename = args[0];
                System.out.println("Reading WS-Inspection document [" + filename + "]...");
                WSILDocument wsilDocument = WSILDocument.newInstance();
                wsilDocument.read(filename);
                System.out.println(wsilDocument.toString());
            }
            catch (Exception e) {
                System.out.println("EXCEPTION: Could not process WS-Inspection document [" + filename + "].");
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    public static WSILDocument newInstance() throws WSILException {
        WSILDocument wsilDocument = null;
        WSILDocumentFactory factory = WSILDocumentFactory.newInstance();
        wsilDocument = factory.newDocument();
        return wsilDocument;
    }

    public void read(Reader reader) throws WSILException {
        this.docReader.parseDocument(this, reader);
    }

    public void read(String urlString) throws WSILException {
        try {
            this.read(new URL(urlString));
        }
        catch (Exception e) {
            throw new WSILException("Could not read WS-Inspection file URL string: " + urlString + ".", e);
        }
    }

    public void read(URL url) throws WSILException {
        try {
            InputStream is;
            this.documentURL = url.toString();
            String proxyUserName = System.getProperty("http.proxyUserName");
            String proxyPassword = System.getProperty("http.proxyPassword");
            if (proxyUserName != null && proxyPassword != null) {
                String userPassword = String.valueOf(proxyUserName) + ":" + proxyPassword;
                String encoding = Base64Converter.encode(userPassword);
                URLConnection uc = url.openConnection();
                uc.setRequestProperty("Proxy-authorization", "Basic " + encoding);
                is = uc.getInputStream();
            } else {
                is = url.openStream();
            }
            this.read(new InputStreamReader(is));
        }
        catch (Exception e) {
            throw new WSILException("Could not read WS-Inspection document from: " + url.toString(), e);
        }
    }

    public void setExtensionRegistry(ExtensionRegistry extRegistry) throws WSILException {
        if (this.extRegistry != null) {
            throw new WSILException("ExtensionRegistry is already set in WSILDocument.");
        }
        this.extRegistry = extRegistry;
    }

    public void setReader(DocumentReader docReader) {
        this.docReader = docReader;
    }

    public void setWriter(DocumentWriter docWriter) {
        this.docWriter = docWriter;
    }

    public String toString() {
        return "WS-Inspection Document: \n" + this.inspection.toString();
    }

    public void write(Writer writer) throws WSILException {
        this.docWriter.writeDocument(this, writer);
    }

    public void write(String filename) throws WSILException {
        try {
            this.write(new FileWriter(filename));
        }
        catch (IOException ioe) {
            throw new WSILException("Could not write to " + filename + ".", ioe);
        }
    }

    public String resolveURL(String relativeURL) {
        String resolvedURL = relativeURL;
        if (this.documentURL != null && relativeURL != null && relativeURL.indexOf("://") == -1) {
            int index = this.documentURL.lastIndexOf(47);
            resolvedURL = String.valueOf(this.documentURL.substring(0, index + 1)) + relativeURL;
        }
        return resolvedURL;
    }

    public void setDocumentURL(String documentURL) {
        this.documentURL = documentURL;
    }
}

