/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.editor.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;

public class SQLTemplateFormatter {
    public void format(TemplateBuffer buffer, String indent) throws BadLocationException {
        try {
            this.indent(buffer, indent);
        }
        catch (MalformedTreeException malformedTreeException) {
            throw new BadLocationException();
        }
    }

    private void indent(TemplateBuffer templateBuffer, String indent) throws BadLocationException, MalformedTreeException {
        TemplateVariable[] variables = templateBuffer.getVariables();
        List positions = SQLTemplateFormatter.variablesToPositions(variables);
        Document document = new Document(templateBuffer.getString());
        MultiTextEdit root = new MultiTextEdit(0, document.getLength());
        root.addChildren(positions.toArray(new TextEdit[positions.size()]));
        int lineCount = document.getNumberOfLines();
        int line = 1;
        while (line < lineCount) {
            IRegion region = document.getLineInformation(line);
            int offset = region.getOffset();
            if (indent != null) {
                InsertEdit edit = new InsertEdit(offset, indent);
                root.addChild((TextEdit)edit);
                root.apply((IDocument)document, 2);
                root.removeChild((TextEdit)edit);
            }
            ++line;
        }
        SQLTemplateFormatter.positionsToVariables(positions, variables);
        templateBuffer.setContent(document.get(), variables);
    }

    private static List variablesToPositions(TemplateVariable[] variables) {
        ArrayList<RangeMarker> positions = new ArrayList<RangeMarker>(5);
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            String value = variables[i].getDefaultValue();
            int wsStart = 0;
            while (wsStart < value.length() && Character.isWhitespace(value.charAt(wsStart))) {
                ++wsStart;
            }
            variables[i].getValues()[0] = value.substring(wsStart);
            int j = 0;
            while (j != offsets.length) {
                int n = j;
                offsets[n] = offsets[n] + wsStart;
                positions.add(new RangeMarker(offsets[j], 0));
                ++j;
            }
            ++i;
        }
        return positions;
    }

    private static void positionsToVariables(List positions, TemplateVariable[] variables) {
        Iterator iterator = positions.iterator();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = ((TextEdit)iterator.next()).getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }
}

