/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ddl;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.DeltaDDLGenerator;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ddl.IDDLGeneratorWrapper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;

public class DDLGeneratorWrapper
implements IDDLGeneratorWrapper {
    protected DDLGenerator _ddlGen;
    protected DeltaDDLGenerator _deltaDdlGen;
    protected DatabaseIdentifier _databaseIdentifier;
    protected DatabaseDefinition _databaseDefn;
    protected boolean _fullQualified;
    protected boolean _quotedIdentifier;
    protected boolean _setUser;

    public DDLGeneratorWrapper(DatabaseIdentifier identifier) {
        this._databaseIdentifier = identifier;
        this._databaseDefn = ProfileUtil.getDatabaseDefinition((String)this._databaseIdentifier.getProfileName());
        this._ddlGen = this._databaseDefn.getDDLGenerator();
        this._deltaDdlGen = this._databaseDefn.getDeltaDDLGenerator();
        this._quotedIdentifier = SQLDevToolsUtil.isQuotedIdentifierOn((DatabaseIdentifier)this._databaseIdentifier);
        this._fullQualified = true;
    }

    @Override
    public String[] getCreateStatementsDDL(SQLObject[] objs) {
        if (this._ddlGen == null) {
            return new String[0];
        }
        String[] ddl = this._ddlGen.createSQLObjects(objs, this._quotedIdentifier, this._fullQualified, null);
        return ddl == null ? new String[]{} : ddl;
    }

    @Override
    public String[] generateDeltaDDL(EObject rootObject, ChangeDescription changeDescription, IProgressMonitor monitor) {
        if (this._deltaDdlGen == null) {
            return new String[0];
        }
        return this._deltaDdlGen.generateDeltaDDL(rootObject, changeDescription, monitor);
    }

    @Override
    public void setFullQualified(boolean qualified) {
        this._fullQualified = qualified;
    }

    @Override
    public void setGenSetUser(boolean setUser) {
        this._setUser = setUser;
    }
}

