/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.ltk.core.refactoring.TextChange;

public class TextChangeManager {
    private Map<ISourceModule, TextChange> fMap = new HashMap<ISourceModule, TextChange>(10);
    private final boolean fKeepExecutedTextEdits;

    public TextChangeManager() {
        this(false);
    }

    public TextChangeManager(boolean keepExecutedTextEdits) {
        this.fKeepExecutedTextEdits = keepExecutedTextEdits;
    }

    public void manage(ISourceModule cu, TextChange change) {
        this.fMap.put(cu, change);
    }

    public TextChange get(ISourceModule cu) {
        Object result = this.fMap.get(cu);
        if (result == null) {
            result = new SourceModuleChange(cu.getElementName(), cu);
            result.setKeepPreviewEdits(this.fKeepExecutedTextEdits);
            this.fMap.put(cu, (TextChange)result);
        }
        return result;
    }

    public TextChange remove(ISourceModule unit) {
        return this.fMap.remove(unit);
    }

    public TextChange[] getAllChanges() {
        Set<ISourceModule> cuSet = this.fMap.keySet();
        ISourceModule[] cus = cuSet.toArray(new ISourceModule[cuSet.size()]);
        Arrays.sort(cus, (o1, o2) -> {
            String name1 = o1.getElementName();
            String name2 = o2.getElementName();
            return name1.compareTo(name2);
        });
        TextChange[] textChanges = new TextChange[cus.length];
        int i = 0;
        while (i < cus.length) {
            textChanges[i] = this.fMap.get(cus[i]);
            ++i;
        }
        return textChanges;
    }

    public ISourceModule[] getAllSourceModules() {
        return this.fMap.keySet().toArray(new ISourceModule[this.fMap.keySet().size()]);
    }

    public void clear() {
        this.fMap.clear();
    }

    public boolean containsChangesIn(ISourceModule cu) {
        return this.fMap.containsKey(cu);
    }
}

