/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.DLTKElementContainmentAdapter;
import org.eclipse.dltk.internal.ui.DLTKWorkbenchAdapter;
import org.eclipse.dltk.internal.ui.IResourceLocator;
import org.eclipse.dltk.internal.ui.ModelElementActionFilterAdapter;
import org.eclipse.dltk.internal.ui.PersistableModelElementFactory;
import org.eclipse.dltk.internal.ui.ResourceLocator;
import org.eclipse.dltk.internal.ui.ScriptElementProperties;
import org.eclipse.dltk.internal.ui.model.DLTKElementResourceMapping;
import org.eclipse.dltk.internal.ui.search.DLTKSearchPageScoreComputer;
import org.eclipse.dltk.internal.ui.search.SearchUtil;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.ResourcePropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

public class ModelElementAdapterFactory
implements IAdapterFactory,
IContributorResourceAdapter,
IContributorResourceAdapter2 {
    private static Class<?>[] PROPERTIES = new Class[]{IPropertySource.class, IResource.class, IWorkbenchAdapter.class, IResourceLocator.class, IPersistableElement.class, IContributorResourceAdapter.class, IContributorResourceAdapter2.class, ITaskListResourceAdapter.class, IContainmentAdapter.class, IActionFilter.class};
    private Object fSearchPageScoreComputer;
    private static IResourceLocator fgResourceLocator;
    private static DLTKWorkbenchAdapter fgScriptWorkbenchAdapter;
    private static DLTKElementContainmentAdapter fgScriptElementContainmentAdapter;

    public Class<?>[] getAdapterList() {
        this.updateLazyLoadedAdapters();
        return PROPERTIES;
    }

    public <T> T getAdapter(Object element, Class<T> key) {
        this.updateLazyLoadedAdapters();
        IModelElement modelElement = this.getModelElement(element);
        if (IPropertySource.class.equals(key)) {
            return (T)this.getProperties(modelElement);
        }
        if (IResource.class.equals(key)) {
            return (T)this.getResource(modelElement);
        }
        if (DLTKCore.DEBUG_SCOPES) {
            System.err.println("Add search scope computer support in ModelElementAdapterFactory");
        }
        if (this.fSearchPageScoreComputer != null && ISearchPageScoreComputer.class.equals(key)) {
            return (T)this.fSearchPageScoreComputer;
        }
        if (IWorkbenchAdapter.class.equals(key)) {
            return (T)ModelElementAdapterFactory.getScriptWorkbenchAdapter();
        }
        if (IResourceLocator.class.equals(key)) {
            return (T)ModelElementAdapterFactory.getResourceLocator();
        }
        if (IPersistableElement.class.equals(key)) {
            return (T)new PersistableModelElementFactory(modelElement);
        }
        if (IContributorResourceAdapter.class.equals(key)) {
            return (T)this;
        }
        if (IContributorResourceAdapter2.class.equals(key)) {
            return (T)this;
        }
        if (ITaskListResourceAdapter.class.equals(key)) {
            return (T)ModelElementAdapterFactory.getTaskListAdapter();
        }
        if (IContainmentAdapter.class.equals(key)) {
            return (T)ModelElementAdapterFactory.getScriptElementContainmentAdapter();
        }
        if (IActionFilter.class.equals(key)) {
            return (T)new ModelElementActionFilterAdapter();
        }
        return null;
    }

    private IResource getResource(IModelElement element) {
        switch (element.getElementType()) {
            case 7: {
                IModelElement parent = element.getParent();
                if (parent instanceof ISourceModule) {
                    return ((ISourceModule)parent).getPrimary().getResource();
                }
                return null;
            }
            case 5: {
                return ((ISourceModule)element).getPrimary().getResource();
            }
            case 3: {
                IProjectFragment root = (IProjectFragment)element.getAncestor(3);
                if (DLTKCore.DEBUG_SCOPES) {
                    System.err.println("Check for archives");
                }
                if (!root.isArchive()) {
                    return element.getResource();
                }
                return null;
            }
            case 1: 
            case 2: 
            case 4: {
                return element.getResource();
            }
        }
        return null;
    }

    public IResource getAdaptedResource(IAdaptable adaptable) {
        IModelElement je = this.getModelElement(adaptable);
        if (je != null) {
            return this.getResource(je);
        }
        return null;
    }

    public ResourceMapping getAdaptedResourceMapping(IAdaptable adaptable) {
        IModelElement je = this.getModelElement(adaptable);
        if (je != null) {
            return DLTKElementResourceMapping.create(je);
        }
        return null;
    }

    private IModelElement getModelElement(Object element) {
        if (element instanceof IModelElement) {
            return (IModelElement)element;
        }
        return null;
    }

    private IPropertySource getProperties(IModelElement element) {
        IResource resource = this.getResource(element);
        if (resource == null) {
            return new ScriptElementProperties(element);
        }
        if (resource.getType() == 1) {
            return new FilePropertySource((IFile)resource);
        }
        return new ResourcePropertySource(resource);
    }

    private void updateLazyLoadedAdapters() {
        if (DLTKCore.DEBUG_SCOPES) {
            System.err.println("Add search page scope compiler");
        }
        if (this.fSearchPageScoreComputer == null && SearchUtil.isSearchPlugInActivated()) {
            this.createSearchPageScoreComputer();
        }
    }

    private void createSearchPageScoreComputer() {
        if (DLTKCore.DEBUG_SCOPES) {
            System.err.println("Add search page scope compiler");
        }
        this.fSearchPageScoreComputer = new DLTKSearchPageScoreComputer();
        PROPERTIES = new Class[]{IPropertySource.class, IResource.class, ISearchPageScoreComputer.class, IWorkbenchAdapter.class, IResourceLocator.class, IPersistableElement.class, IProject.class, IContributorResourceAdapter.class, IContributorResourceAdapter2.class, ITaskListResourceAdapter.class, IContainmentAdapter.class, IActionFilter.class};
    }

    private static IResourceLocator getResourceLocator() {
        if (fgResourceLocator == null) {
            fgResourceLocator = new ResourceLocator();
        }
        return fgResourceLocator;
    }

    private static DLTKWorkbenchAdapter getScriptWorkbenchAdapter() {
        if (fgScriptWorkbenchAdapter == null) {
            fgScriptWorkbenchAdapter = new DLTKWorkbenchAdapter();
        }
        return fgScriptWorkbenchAdapter;
    }

    private static ITaskListResourceAdapter getTaskListAdapter() {
        if (DLTKCore.DEBUG_SCOPES) {
            System.err.println("Add Task list adaptor to ModelElementAdapterFactory");
        }
        return null;
    }

    private static DLTKElementContainmentAdapter getScriptElementContainmentAdapter() {
        if (fgScriptElementContainmentAdapter == null) {
            fgScriptElementContainmentAdapter = new DLTKElementContainmentAdapter();
        }
        return fgScriptElementContainmentAdapter;
    }
}

