// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.4.0,
// any modifications will be overwritten.
// ==============================================================

package org.eclipse.m2e.core.internal.lifecyclemapping.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadata;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;

/**
 * Class LifecycleMappingMetadataSourceXpp3Reader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class LifecycleMappingMetadataSourceXpp3Reader
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If set the parser will be loaded with all single characters
     * from the XHTML specification.
     * The entities used:
     * <ul>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent</li>
     * </ul>
     */
    private boolean addDefaultEntities = true;

    /**
     * Field contentTransformer.
     */
    public final ContentTransformer contentTransformer;


      //----------------/
     //- Constructors -/
    //----------------/

    public LifecycleMappingMetadataSourceXpp3Reader()
    {
        this( new ContentTransformer()
        {
            public String transform( String source, String fieldName )
            {
                return source;
            }
        } );
    } //-- org.eclipse.m2e.core.internal.lifecyclemapping.model.io.xpp3.LifecycleMappingMetadataSourceXpp3Reader()

    public LifecycleMappingMetadataSourceXpp3Reader(ContentTransformer contentTransformer)
    {
        this.contentTransformer = contentTransformer;
    } //-- org.eclipse.m2e.core.internal.lifecyclemapping.model.io.xpp3.LifecycleMappingMetadataSourceXpp3Reader(ContentTransformer)


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param parser a parser object.
     * @param parsed a parsed object.
     * @param alias a alias object.
     * @param tagName a tagName object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XmlPullParser parser, String tagName, String alias, java.util.Set<String> parsed )
        throws XmlPullParserException
    {
        if ( !( parser.getName().equals( tagName ) || parser.getName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XmlPullParserException( "Duplicated tag: '" + tagName + "'", parser, null );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XmlPullParser, String, String, java.util.Set )

    /**
     * Method checkUnknownAttribute.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @param tagName a tagName object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownAttribute( XmlPullParser parser, String attribute, String tagName, boolean strict )
        throws XmlPullParserException, IOException
    {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if ( strict )
        {
            throw new XmlPullParserException( "Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null );
        }
    } //-- void checkUnknownAttribute( XmlPullParser, String, String, boolean )

    /**
     * Method checkUnknownElement.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownElement( XmlPullParser parser, boolean strict )
        throws XmlPullParserException, IOException
    {
        if ( strict )
        {
            throw new XmlPullParserException( "Unrecognised tag: '" + parser.getName() + "'", parser, null );
        }

        for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )
        {
            int eventType = parser.next();
            if ( eventType == XmlPullParser.START_TAG )
            {
                unrecognizedTagCount++;
            }
            else if ( eventType == XmlPullParser.END_TAG )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XmlPullParser, boolean )

    /**
     * Returns the state of the "add default entities" flag.
     * 
     * @return boolean
     */
    public boolean getAddDefaultEntities()
    {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getBooleanValue( s, attribute, parser, null );
    } //-- boolean getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param defaultValue a defaultValue object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser, String defaultValue )
        throws XmlPullParserException
    {
        if ( s != null && s.length() != 0 )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        if ( defaultValue != null )
        {
            return Boolean.valueOf( defaultValue ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XmlPullParser, String )

    /**
     * Method getByteValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a byte", parser, nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XmlPullParser, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getDateValue( s, attribute, null, parser );
    } //-- java.util.Date getDateValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param dateFormat a dateFormat object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XmlPullParser )

    /**
     * Method getDoubleValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XmlPullParser, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return float
     */
    private float getFloatValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XmlPullParser, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be an integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XmlPullParser, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return long
     */
    private long getLongValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a long integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XmlPullParser, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XmlPullParserException( "Missing required value for attribute '" + attribute + "'", parser, null );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XmlPullParser, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return short
     */
    private short getShortValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a short integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XmlPullParser, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s a s object.
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method interpolatedTrimmed.
     * 
     * @param value a value object.
     * @param context a context object.
     * @return String
     */
    private String interpolatedTrimmed( String value, String context )
    {
        return getTrimmedValue( contentTransformer.transform( value, context ) );
    } //-- String interpolatedTrimmed( String, String )

    /**
     * Method nextTag.
     * 
     * @param parser a parser object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int nextTag( XmlPullParser parser )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.next();
        if ( eventType == XmlPullParser.TEXT )
        {
            eventType = parser.next();
        }
        if ( eventType != XmlPullParser.START_TAG && eventType != XmlPullParser.END_TAG )
        {
            throw new XmlPullParserException( "expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null );
        }
        return eventType;
    } //-- int nextTag( XmlPullParser )

    /**
     * Method read.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadataSource
     */
    public LifecycleMappingMetadataSource read( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        LifecycleMappingMetadataSource lifecycleMappingMetadataSource = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "lifecycleMappingMetadata".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'lifecycleMappingMetadata' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'lifecycleMappingMetadata'", parser, null );
                }
                lifecycleMappingMetadataSource = parseLifecycleMappingMetadataSource( parser, strict );
                lifecycleMappingMetadataSource.setModelEncoding( parser.getInputEncoding() );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return lifecycleMappingMetadataSource;
        }
        throw new XmlPullParserException( "Expected root element 'lifecycleMappingMetadata' but found no element at all: invalid XML document", parser, null );
    } //-- LifecycleMappingMetadataSource read( XmlPullParser, boolean )

    /**
     * @see XmlStreamReader
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadataSource
     */
    public LifecycleMappingMetadataSource read( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return read( parser, strict );
    } //-- LifecycleMappingMetadataSource read( Reader, boolean )

    /**
     * @see XmlStreamReader
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadataSource
     */
    public LifecycleMappingMetadataSource read( Reader reader )
        throws IOException, XmlPullParserException
    {
        return read( reader, true );
    } //-- LifecycleMappingMetadataSource read( Reader )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadataSource
     */
    public LifecycleMappingMetadataSource read( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return read( new XmlStreamReader( in ), strict );
    } //-- LifecycleMappingMetadataSource read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadataSource
     */
    public LifecycleMappingMetadataSource read( InputStream in )
        throws IOException, XmlPullParserException
    {
        return read( new XmlStreamReader( in ) );
    } //-- LifecycleMappingMetadataSource read( InputStream )

    /**
     * Method readLifecycleMappingFilter.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingFilter
     */
    public LifecycleMappingFilter readLifecycleMappingFilter( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        LifecycleMappingFilter lifecycleMappingFilter = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "lifecycleMappingFilter".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'lifecycleMappingFilter' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'lifecycleMappingFilter'", parser, null );
                }
                lifecycleMappingFilter = parseLifecycleMappingFilter( parser, strict );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return lifecycleMappingFilter;
        }
        throw new XmlPullParserException( "Expected root element 'lifecycleMappingFilter' but found no element at all: invalid XML document", parser, null );
    } //-- LifecycleMappingFilter readLifecycleMappingFilter( XmlPullParser, boolean )

    /**
     * @see XmlStreamReader
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingFilter
     */
    public LifecycleMappingFilter readLifecycleMappingFilter( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return readLifecycleMappingFilter( parser, strict );
    } //-- LifecycleMappingFilter readLifecycleMappingFilter( Reader, boolean )

    /**
     * @see XmlStreamReader
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingFilter
     */
    public LifecycleMappingFilter readLifecycleMappingFilter( Reader reader )
        throws IOException, XmlPullParserException
    {
        return readLifecycleMappingFilter( reader, true );
    } //-- LifecycleMappingFilter readLifecycleMappingFilter( Reader )

    /**
     * Method readLifecycleMappingFilter.
     * 
     * @param in a in object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingFilter
     */
    public LifecycleMappingFilter readLifecycleMappingFilter( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return readLifecycleMappingFilter( new XmlStreamReader( in ), strict );
    } //-- LifecycleMappingFilter readLifecycleMappingFilter( InputStream, boolean )

    /**
     * Method readLifecycleMappingFilter.
     * 
     * @param in a in object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingFilter
     */
    public LifecycleMappingFilter readLifecycleMappingFilter( InputStream in )
        throws IOException, XmlPullParserException
    {
        return readLifecycleMappingFilter( new XmlStreamReader( in ) );
    } //-- LifecycleMappingFilter readLifecycleMappingFilter( InputStream )

    /**
     * Method readLifecycleMappingMetadata.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadata
     */
    public LifecycleMappingMetadata readLifecycleMappingMetadata( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        LifecycleMappingMetadata lifecycleMappingMetadata = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "lifecycleMapping".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'lifecycleMapping' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'lifecycleMapping'", parser, null );
                }
                lifecycleMappingMetadata = parseLifecycleMappingMetadata( parser, strict );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return lifecycleMappingMetadata;
        }
        throw new XmlPullParserException( "Expected root element 'lifecycleMapping' but found no element at all: invalid XML document", parser, null );
    } //-- LifecycleMappingMetadata readLifecycleMappingMetadata( XmlPullParser, boolean )

    /**
     * @see XmlStreamReader
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadata
     */
    public LifecycleMappingMetadata readLifecycleMappingMetadata( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return readLifecycleMappingMetadata( parser, strict );
    } //-- LifecycleMappingMetadata readLifecycleMappingMetadata( Reader, boolean )

    /**
     * @see XmlStreamReader
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadata
     */
    public LifecycleMappingMetadata readLifecycleMappingMetadata( Reader reader )
        throws IOException, XmlPullParserException
    {
        return readLifecycleMappingMetadata( reader, true );
    } //-- LifecycleMappingMetadata readLifecycleMappingMetadata( Reader )

    /**
     * Method readLifecycleMappingMetadata.
     * 
     * @param in a in object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadata
     */
    public LifecycleMappingMetadata readLifecycleMappingMetadata( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return readLifecycleMappingMetadata( new XmlStreamReader( in ), strict );
    } //-- LifecycleMappingMetadata readLifecycleMappingMetadata( InputStream, boolean )

    /**
     * Method readLifecycleMappingMetadata.
     * 
     * @param in a in object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadata
     */
    public LifecycleMappingMetadata readLifecycleMappingMetadata( InputStream in )
        throws IOException, XmlPullParserException
    {
        return readLifecycleMappingMetadata( new XmlStreamReader( in ) );
    } //-- LifecycleMappingMetadata readLifecycleMappingMetadata( InputStream )

    /**
     * Method readPluginExecutionFilter.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionFilter
     */
    public PluginExecutionFilter readPluginExecutionFilter( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        PluginExecutionFilter pluginExecutionFilter = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "pluginExecutionFilter".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'pluginExecutionFilter' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'pluginExecutionFilter'", parser, null );
                }
                pluginExecutionFilter = parsePluginExecutionFilter( parser, strict );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return pluginExecutionFilter;
        }
        throw new XmlPullParserException( "Expected root element 'pluginExecutionFilter' but found no element at all: invalid XML document", parser, null );
    } //-- PluginExecutionFilter readPluginExecutionFilter( XmlPullParser, boolean )

    /**
     * @see XmlStreamReader
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionFilter
     */
    public PluginExecutionFilter readPluginExecutionFilter( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return readPluginExecutionFilter( parser, strict );
    } //-- PluginExecutionFilter readPluginExecutionFilter( Reader, boolean )

    /**
     * @see XmlStreamReader
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionFilter
     */
    public PluginExecutionFilter readPluginExecutionFilter( Reader reader )
        throws IOException, XmlPullParserException
    {
        return readPluginExecutionFilter( reader, true );
    } //-- PluginExecutionFilter readPluginExecutionFilter( Reader )

    /**
     * Method readPluginExecutionFilter.
     * 
     * @param in a in object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionFilter
     */
    public PluginExecutionFilter readPluginExecutionFilter( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return readPluginExecutionFilter( new XmlStreamReader( in ), strict );
    } //-- PluginExecutionFilter readPluginExecutionFilter( InputStream, boolean )

    /**
     * Method readPluginExecutionFilter.
     * 
     * @param in a in object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionFilter
     */
    public PluginExecutionFilter readPluginExecutionFilter( InputStream in )
        throws IOException, XmlPullParserException
    {
        return readPluginExecutionFilter( new XmlStreamReader( in ) );
    } //-- PluginExecutionFilter readPluginExecutionFilter( InputStream )

    /**
     * Method readPluginExecutionMetadata.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionMetadata
     */
    public PluginExecutionMetadata readPluginExecutionMetadata( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        PluginExecutionMetadata pluginExecutionMetadata = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "pluginExecution".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'pluginExecution' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'pluginExecution'", parser, null );
                }
                pluginExecutionMetadata = parsePluginExecutionMetadata( parser, strict );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return pluginExecutionMetadata;
        }
        throw new XmlPullParserException( "Expected root element 'pluginExecution' but found no element at all: invalid XML document", parser, null );
    } //-- PluginExecutionMetadata readPluginExecutionMetadata( XmlPullParser, boolean )

    /**
     * @see XmlStreamReader
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionMetadata
     */
    public PluginExecutionMetadata readPluginExecutionMetadata( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return readPluginExecutionMetadata( parser, strict );
    } //-- PluginExecutionMetadata readPluginExecutionMetadata( Reader, boolean )

    /**
     * @see XmlStreamReader
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionMetadata
     */
    public PluginExecutionMetadata readPluginExecutionMetadata( Reader reader )
        throws IOException, XmlPullParserException
    {
        return readPluginExecutionMetadata( reader, true );
    } //-- PluginExecutionMetadata readPluginExecutionMetadata( Reader )

    /**
     * Method readPluginExecutionMetadata.
     * 
     * @param in a in object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionMetadata
     */
    public PluginExecutionMetadata readPluginExecutionMetadata( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return readPluginExecutionMetadata( new XmlStreamReader( in ), strict );
    } //-- PluginExecutionMetadata readPluginExecutionMetadata( InputStream, boolean )

    /**
     * Method readPluginExecutionMetadata.
     * 
     * @param in a in object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionMetadata
     */
    public PluginExecutionMetadata readPluginExecutionMetadata( InputStream in )
        throws IOException, XmlPullParserException
    {
        return readPluginExecutionMetadata( new XmlStreamReader( in ) );
    } //-- PluginExecutionMetadata readPluginExecutionMetadata( InputStream )

    /**
     * Method parseLifecycleMappingFilter.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingFilter
     */
    private LifecycleMappingFilter parseLifecycleMappingFilter( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        LifecycleMappingFilter lifecycleMappingFilter = new LifecycleMappingFilter();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set<String> parsed = new java.util.HashSet<String>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "symbolicName", null, parsed ) )
            {
                lifecycleMappingFilter.setSymbolicName( interpolatedTrimmed( parser.nextText(), "symbolicName" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "versionRange", null, parsed ) )
            {
                lifecycleMappingFilter.setVersionRange( interpolatedTrimmed( parser.nextText(), "versionRange" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "pluginExecutions", null, parsed ) )
            {
                java.util.Set<PluginExecutionFilter> pluginExecutions = new java.util.HashSet<PluginExecutionFilter>();
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "pluginExecution".equals( parser.getName() ) )
                    {
                        pluginExecutions.add( parsePluginExecutionFilter( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
                lifecycleMappingFilter.setPluginExecutions( pluginExecutions );
            }
            else if ( checkFieldWithDuplicate( parser, "packagingTypes", null, parsed ) )
            {
                java.util.Set<String> packagingTypes = new java.util.HashSet<String>();
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "packagingType".equals( parser.getName() ) )
                    {
                        packagingTypes.add( interpolatedTrimmed( parser.nextText(), "packagingTypes" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
                lifecycleMappingFilter.setPackagingTypes( packagingTypes );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return lifecycleMappingFilter;
    } //-- LifecycleMappingFilter parseLifecycleMappingFilter( XmlPullParser, boolean )

    /**
     * Method parseLifecycleMappingMetadata.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadata
     */
    private LifecycleMappingMetadata parseLifecycleMappingMetadata( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        LifecycleMappingMetadata lifecycleMappingMetadata = new LifecycleMappingMetadata();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set<String> parsed = new java.util.HashSet<String>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "packagingType", null, parsed ) )
            {
                lifecycleMappingMetadata.setPackagingType( interpolatedTrimmed( parser.nextText(), "packagingType" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "lifecycleMappingId", null, parsed ) )
            {
                lifecycleMappingMetadata.setLifecycleMappingId( interpolatedTrimmed( parser.nextText(), "lifecycleMappingId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "lifecycleMappingVersionRange", null, parsed ) )
            {
                lifecycleMappingMetadata.setLifecycleMappingVersionRange( interpolatedTrimmed( parser.nextText(), "lifecycleMappingVersionRange" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "pluginExecutions", null, parsed ) )
            {
                java.util.List<PluginExecutionMetadata> pluginExecutions = new java.util.ArrayList<PluginExecutionMetadata>();
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "pluginExecution".equals( parser.getName() ) )
                    {
                        pluginExecutions.add( parsePluginExecutionMetadata( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
                lifecycleMappingMetadata.setPluginExecutions( pluginExecutions );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return lifecycleMappingMetadata;
    } //-- LifecycleMappingMetadata parseLifecycleMappingMetadata( XmlPullParser, boolean )

    /**
     * Method parseLifecycleMappingMetadataSource.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LifecycleMappingMetadataSource
     */
    private LifecycleMappingMetadataSource parseLifecycleMappingMetadataSource( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        LifecycleMappingMetadataSource lifecycleMappingMetadataSource = new LifecycleMappingMetadataSource();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "xmlns".equals( name ) )
            {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set<String> parsed = new java.util.HashSet<String>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "lifecycleMappings", null, parsed ) )
            {
                java.util.List<LifecycleMappingMetadata> lifecycleMappings = new java.util.ArrayList<LifecycleMappingMetadata>();
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "lifecycleMapping".equals( parser.getName() ) )
                    {
                        lifecycleMappings.add( parseLifecycleMappingMetadata( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
                lifecycleMappingMetadataSource.setLifecycleMappings( lifecycleMappings );
            }
            else if ( checkFieldWithDuplicate( parser, "pluginExecutions", null, parsed ) )
            {
                java.util.List<PluginExecutionMetadata> pluginExecutions = new java.util.ArrayList<PluginExecutionMetadata>();
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "pluginExecution".equals( parser.getName() ) )
                    {
                        pluginExecutions.add( parsePluginExecutionMetadata( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
                lifecycleMappingMetadataSource.setPluginExecutions( pluginExecutions );
            }
            else if ( checkFieldWithDuplicate( parser, "lifecycleMappingFilters", null, parsed ) )
            {
                java.util.List<LifecycleMappingFilter> lifecycleMappingFilters = new java.util.ArrayList<LifecycleMappingFilter>();
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "lifecycleMappingFilter".equals( parser.getName() ) )
                    {
                        lifecycleMappingFilters.add( parseLifecycleMappingFilter( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
                lifecycleMappingMetadataSource.setLifecycleMappingFilters( lifecycleMappingFilters );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return lifecycleMappingMetadataSource;
    } //-- LifecycleMappingMetadataSource parseLifecycleMappingMetadataSource( XmlPullParser, boolean )

    /**
     * Method parsePluginExecutionFilter.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionFilter
     */
    private PluginExecutionFilter parsePluginExecutionFilter( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        PluginExecutionFilter pluginExecutionFilter = new PluginExecutionFilter();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set<String> parsed = new java.util.HashSet<String>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "groupId", null, parsed ) )
            {
                pluginExecutionFilter.setGroupId( interpolatedTrimmed( parser.nextText(), "groupId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "artifactId", null, parsed ) )
            {
                pluginExecutionFilter.setArtifactId( interpolatedTrimmed( parser.nextText(), "artifactId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "versionRange", null, parsed ) )
            {
                pluginExecutionFilter.setVersionRange( interpolatedTrimmed( parser.nextText(), "versionRange" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "goals", null, parsed ) )
            {
                java.util.Set<String> goals = new java.util.HashSet<String>();
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "goal".equals( parser.getName() ) )
                    {
                        goals.add( interpolatedTrimmed( parser.nextText(), "goals" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
                pluginExecutionFilter.setGoals( goals );
            }
            else if ( checkFieldWithDuplicate( parser, "parameters", null, parsed ) )
            {
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    String key = parser.getName();
                    String value = parser.nextText().trim();
                    pluginExecutionFilter.addParameter( key, value );
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return pluginExecutionFilter;
    } //-- PluginExecutionFilter parsePluginExecutionFilter( XmlPullParser, boolean )

    /**
     * Method parsePluginExecutionMetadata.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginExecutionMetadata
     */
    private PluginExecutionMetadata parsePluginExecutionMetadata( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        PluginExecutionMetadata pluginExecutionMetadata = new PluginExecutionMetadata();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set<String> parsed = new java.util.HashSet<String>();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "pluginExecutionFilter", null, parsed ) )
            {
                pluginExecutionMetadata.setFilter( parsePluginExecutionFilter( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "action", null, parsed ) )
            {
                pluginExecutionMetadata.setActionDom( org.codehaus.plexus.util.xml.Xpp3DomBuilder.build( parser, true ) );
            }
            else if ( checkFieldWithDuplicate( parser, "comment", null, parsed ) )
            {
                pluginExecutionMetadata.setComment( interpolatedTrimmed( parser.nextText(), "comment" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return pluginExecutionMetadata;
    } //-- PluginExecutionMetadata parsePluginExecutionMetadata( XmlPullParser, boolean )

    /**
     * Sets the state of the "add default entities" flag.
     * 
     * @param addDefaultEntities a addDefaultEntities object.
     */
    public void setAddDefaultEntities( boolean addDefaultEntities )
    {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities( boolean )

    public static interface ContentTransformer
{
    /**
     * Interpolate the value read from the xpp3 document
     * @param source The source value
     * @param fieldName A description of the field being interpolated. The implementation may use this to
     *                           log stuff.
     * @return The interpolated value.
     */
    String transform( String source, String fieldName );
}

}
