/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContextImpl;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstanceFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;

public abstract class BlackboxProvider {
    private static final ResolutionContext GLOBAL_RESOLUTION_CONTEXT = new ResolutionContextImpl(BlackboxUnitResolver.GLOBAL_CONTEXT);

    protected BlackboxProvider() {
    }

    protected BlackboxUnit createBlackboxUnit(QvtOperationalModuleEnv moduleEnv) {
        return this.createBlackboxUnit(Collections.singletonList(moduleEnv));
    }

    protected BlackboxUnit createBlackboxUnit(final List<QvtOperationalModuleEnv> loadedModules) {
        return new BlackboxUnit(){

            @Override
            public List<QvtOperationalModuleEnv> getElements() {
                return Collections.unmodifiableList(loadedModules);
            }

            @Override
            public Diagnostic getDiagnostic() {
                return Diagnostic.OK_INSTANCE;
            }
        };
    }

    public static void setInstanceAdapterFactory(Module module, final InstanceAdapterFactory factory) {
        ModuleInstanceFactory moduleInstanceFactory = (ModuleInstanceFactory)module.getEFactoryInstance();
        moduleInstanceFactory.addPostCreateHandler(new ModuleInstanceFactory.PostCreateHandler(){

            @Override
            public void created(ModuleInstance moduleInstance) {
                Object adapterInstance = factory.createAdapter(moduleInstance);
                moduleInstance.getAdapter(ModuleInstance.Internal.class).addAdapter(adapterInstance);
            }
        });
    }

    protected void setOperationHandler(EOperation operation, final CallHandler handler, boolean adaptSource) {
        CallHandler actualHandler = handler;
        if (adaptSource) {
            actualHandler = new CallHandler(){

                @Override
                public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
                    return handler.invoke(module, source, args, evalEnv);
                }
            };
        }
        CallHandlerAdapter.attach(operation, actualHandler);
    }

    public abstract Collection<? extends BlackboxUnitDescriptor> getUnitDescriptors(ResolutionContext var1);

    public abstract BlackboxUnitDescriptor getUnitDescriptor(String var1, ResolutionContext var2);

    public abstract void cleanup();

    private ResolutionContext getResolutionContext(QvtOperationalModuleEnv env) {
        URI sourceURI = QvtOperationalUtil.getSourceURI(env);
        ArrayList<String> imports = new ArrayList<String>();
        for (Set<String> importSet : env.getImportedNativeLibs().values()) {
            imports.addAll(importSet);
        }
        return sourceURI != null ? new ResolutionContextImpl(sourceURI, imports) : GLOBAL_RESOLUTION_CONTEXT;
    }

    public Collection<CallHandler> getBlackboxCallHandler(ImperativeOperation operation, QvtOperationalModuleEnv env) {
        List<CallHandler> result = Collections.emptyList();
        for (BlackboxUnitDescriptor blackboxUnitDescriptor : this.getUnitDescriptors(this.getResolutionContext(env))) {
            if (!env.getImportedNativeLibs().isEmpty() && !env.getImportedNativeLibs().containsKey(blackboxUnitDescriptor.getURI())) continue;
            try {
                blackboxUnitDescriptor.load(new LoadContext(env.getEPackageRegistry()));
            }
            catch (BlackboxException e) {
                continue;
            }
            Collection<CallHandler> handlers = blackboxUnitDescriptor.getBlackboxCallHandler(operation, env);
            if (handlers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new LinkedList<CallHandler>();
            }
            result.addAll(handlers);
        }
        return result;
    }

    public Collection<CallHandler> getBlackboxCallHandler(OperationalTransformation transformation, QvtOperationalModuleEnv env) {
        List<CallHandler> result = Collections.emptyList();
        for (BlackboxUnitDescriptor blackboxUnitDescriptor : this.getUnitDescriptors(this.getResolutionContext(env))) {
            if (!env.getImportedNativeLibs().isEmpty() && !env.getImportedNativeLibs().containsKey(blackboxUnitDescriptor.getURI())) continue;
            try {
                blackboxUnitDescriptor.load(new LoadContext(env.getEPackageRegistry()));
            }
            catch (BlackboxException e) {
                continue;
            }
            Collection<CallHandler> handlers = blackboxUnitDescriptor.getBlackboxCallHandler(transformation, env);
            if (handlers.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new LinkedList<CallHandler>();
            }
            result.addAll(handlers);
        }
        return result;
    }

    public static interface InstanceAdapterFactory {
        public Object createAdapter(EObject var1);
    }
}

