/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.InstanceScopeAnalysis;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.Tuple;

public abstract class AbstractPathCache<StepType> {
    private final Map<Tuple.Pair<OCLExpression, List<String>>, StepType> subexpressionToPath = new HashMap<Tuple.Pair<OCLExpression, List<String>>, StepType>();
    private final OppositeEndFinder oppositeEndFinder;
    private InstanceScopeAnalysis instanceScopeAnalysis;

    public AbstractPathCache(OppositeEndFinder oppositeEndFinder) {
        this.oppositeEndFinder = oppositeEndFinder;
    }

    public void initInstanceScopeAnalysis(InstanceScopeAnalysis instanceScopeAnalysis) {
        if (this.instanceScopeAnalysis != null) {
            throw new IllegalStateException("instanceScopeAnalysis field on " + this + " already initialized");
        }
        this.instanceScopeAnalysis = instanceScopeAnalysis;
    }

    public InstanceScopeAnalysis getInstanceScopeAnalysis() {
        return this.instanceScopeAnalysis;
    }

    public OppositeEndFinder getOppositeEndFinder() {
        return this.oppositeEndFinder;
    }

    public StepType getPathForNode(OCLExpression subexpression, Stack<String> tupleLiteralPartNamesToLookFor) {
        return this.subexpressionToPath.get(new Tuple.Pair<OCLExpression, List<String>>(subexpression, AbstractPathCache.getTupleLiteralPartNamesToLookForAsList(tupleLiteralPartNamesToLookFor)));
    }

    public void put(OCLExpression subexpression, Stack<String> tupleLiteralPartNamesToLookFor, StepType path) {
        List<String> tupleLiteralPartNamesToLookForAsList = AbstractPathCache.getTupleLiteralPartNamesToLookForAsList(tupleLiteralPartNamesToLookFor);
        this.subexpressionToPath.put(new Tuple.Pair<OCLExpression, List<String>>(subexpression, tupleLiteralPartNamesToLookForAsList), path);
    }

    private static List<String> getTupleLiteralPartNamesToLookForAsList(Stack<String> tupleLiteralPartNamesToLookFor) {
        ArrayList<String> tupleLiteralPartNamesToLookForAsList;
        if (tupleLiteralPartNamesToLookFor == null || tupleLiteralPartNamesToLookFor.size() == 0) {
            tupleLiteralPartNamesToLookForAsList = null;
        } else {
            tupleLiteralPartNamesToLookForAsList = new ArrayList<String>();
            ListIterator it = tupleLiteralPartNamesToLookFor.listIterator();
            while (it.hasNext()) {
                tupleLiteralPartNamesToLookForAsList.add((String)it.next());
            }
        }
        return tupleLiteralPartNamesToLookForAsList;
    }

    public StepType getOrCreateNavigationPath(OCLExpression sourceExpression, EClass context, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor, OCLFactory oclFactory) {
        StepType result = this.getPathForNode(sourceExpression, tupleLiteralNamesToLookFor);
        if (result == null) {
            result = this.createStep(sourceExpression, context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, oclFactory);
            this.put(sourceExpression, tupleLiteralNamesToLookFor, result);
        }
        return result;
    }

    protected abstract StepType createStep(OCLExpression var1, EClass var2, OperationBodyToCallMapper var3, Stack<String> var4, OCLFactory var5);
}

