/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.EmptyResultNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.PathCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.PredicateCheckNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;

public class IteratorExpTracer
extends AbstractTracer<IteratorExp> {
    public IteratorExpTracer(IteratorExp expression, Stack<String> tuplePartNames, OCLFactory oclFactory) {
        super(expression, tuplePartNames, oclFactory);
    }

    @Override
    public NavigationStep traceback(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        NavigationStep result;
        String name = ((IteratorExp)this.getExpression()).getName();
        int opCode = OCLStandardLibraryUtil.getOperationCode((String)name);
        if (opCode == 209 || opCode == 210 || opCode == 211 || opCode == 205) {
            result = (NavigationStep)pathCache.getOrCreateNavigationPath((OCLExpression)((IteratorExp)this.getExpression()).getSource(), context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
            if (opCode == 209 || opCode == 210 || opCode == 205) {
                org.eclipse.ocl.expressions.Variable varDecl = (org.eclipse.ocl.expressions.Variable)((IteratorExp)this.getExpression()).getIterator().get(0);
                EClass iteratorType = this.getInnermostElementType((EClassifier)varDecl.getType());
                result = pathCache.navigationStepFromSequence((OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor(), new PredicateCheckNavigationStep(this.getInnermostElementType((EClassifier)((IteratorExp)this.getExpression()).getType()), iteratorType, (IteratorExp)this.getExpression(), pathCache, this.oclFactory), result);
            }
        } else {
            result = opCode == 206 || opCode == 207 || opCode == 208 ? (NavigationStep)pathCache.getOrCreateNavigationPath((OCLExpression)((IteratorExp)this.getExpression()).getBody(), context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory) : new EmptyResultNavigationStep((OCLExpression)this.getExpression());
        }
        this.applyScopesOnNavigationStep(result, operationBodyToCallMapper);
        return result;
    }

    @Override
    protected Set<Variable> calculateEnteringScope(OperationBodyToCallMapper operationBodyToCallMapper) {
        HashSet<Variable> result;
        int opCode = OCLStandardLibraryUtil.getOperationCode((String)((IteratorExp)this.getExpression()).getName());
        if (opCode == 206 || opCode == 207) {
            result = new HashSet();
            for (org.eclipse.ocl.expressions.Variable v : ((IteratorExp)this.getExpression()).getIterator()) {
                result.add((Variable)v);
            }
        } else {
            result = Collections.emptySet();
        }
        return result;
    }
}

