/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.TransactionHelper;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.editor.welcome.IWelcomePageService;
import org.eclipse.papyrus.infra.editor.welcome.SashColumn;
import org.eclipse.papyrus.infra.editor.welcome.SashRow;
import org.eclipse.papyrus.infra.editor.welcome.Welcome;
import org.eclipse.papyrus.infra.editor.welcome.WelcomeFactory;
import org.eclipse.papyrus.infra.editor.welcome.WelcomePackage;
import org.eclipse.papyrus.infra.editor.welcome.WelcomePage;
import org.eclipse.papyrus.infra.editor.welcome.WelcomeSection;
import org.eclipse.papyrus.infra.editor.welcome.internal.Activator;
import org.eclipse.papyrus.infra.editor.welcome.internal.WelcomeModelManager;
import org.eclipse.papyrus.infra.editor.welcome.internal.WelcomeTab;
import org.eclipse.papyrus.infra.editor.welcome.internal.dnd.WelcomeSectionTransfer;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.contexts.Tab;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

class WelcomeLayout {
    private static final int NUM_ROWS = 2;
    private static final int SASH_OFFEST = 5;
    private static final int SASH_MARGIN = 50;
    private static final Function<Control, Control> textLabelAccessor = WelcomeLayout.createTextLabelAccessor();
    private final int rowCount = 2;
    private final Composite parent;
    private final FormToolkit toolkit;
    private final IWelcomePageService welcomeService;
    private final AtomicReference<DeferredLayoutUpdate> deferredLayoutUpdate = new AtomicReference();
    private Map<Tab, Composite> tabControls = new HashMap<Tab, Composite>();
    private List<WelcomeTab> tabs;
    private Map<WelcomeTab, Composite> sections;
    private Sash[][] rowSashes;
    private Sash[] columnSashes;

    WelcomeLayout(Composite parent, FormToolkit toolkit, IWelcomePageService welcomeService) {
        this.parent = parent;
        this.toolkit = toolkit;
        this.welcomeService = welcomeService;
    }

    public void dispose() {
        this.tabControls.values().forEach(body -> {
            if (!body.isDisposed()) {
                body.getParent().dispose();
            }
        });
        this.tabControls.clear();
        if (this.rowSashes != null) {
            Stream.of(this.rowSashes).flatMap(sashArray -> Stream.of(sashArray)).filter(Objects::nonNull).filter(((Predicate<Sash>)Widget::isDisposed).negate()).forEach(Widget::dispose);
            this.rowSashes = null;
        }
        if (this.columnSashes != null) {
            Stream.of(this.columnSashes).filter(((Predicate<Sash>)Widget::isDisposed).negate()).forEach(Widget::dispose);
            this.columnSashes = null;
        }
        this.tabs = null;
        this.sections = null;
    }

    void createTabs(List<WelcomeTab> tabs) {
        this.sort(tabs);
        this.tabs = tabs;
        this.createSashes();
        this.createSections();
    }

    private void sort(List<WelcomeTab> tabs) {
        Welcome welcome = this.welcomeService.getWelcome();
        if (welcome.getWelcomePage() != null) {
            Collections.sort(tabs, this.userDefinedOrdering(welcome.getWelcomePage()));
        } else {
            Collections.sort(tabs);
        }
    }

    private Comparator<WelcomeTab> userDefinedOrdering(WelcomePage welcomePage) {
        return (tab1, tab2) -> {
            WelcomeSection section1 = welcomePage.getSection(tab1.getID());
            WelcomeSection section2 = welcomePage.getSection(tab2.getID());
            int index1 = welcomePage.getSections().indexOf((Object)section1);
            int index2 = welcomePage.getSections().indexOf((Object)section2);
            int result = index1 >= 0 && index2 >= 0 ? index1 - index2 : tab1.compareTo((WelcomeTab)tab2);
            return result;
        };
    }

    private void createSashes() {
        int rows = 2;
        int columns = (this.tabs.size() + this.tabs.size() % rows) / rows;
        int lastTab = this.tabs.size() - 1;
        if (rows == 0 || columns == 0) {
            return;
        }
        this.columnSashes = new Sash[columns - 1];
        this.rowSashes = new Sash[columns][rows - 1];
        int orientation = 256;
        int colIdx = 0;
        int rowIdx = 0;
        int i = 0;
        while (i < lastTab) {
            final Sash sash = new Sash(this.parent, orientation);
            sash.setBackground(this.parent.getBackground());
            switch (orientation) {
                case 256: {
                    sash.setData((Object)new Point(colIdx, rowIdx));
                    this.rowSashes[colIdx][rowIdx++] = sash;
                    break;
                }
                case 512: {
                    rowIdx = 0;
                    sash.setData((Object)new Point(colIdx, rowIdx));
                    this.columnSashes[colIdx++] = sash;
                }
            }
            sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Point cell = (Point)sash.getData();
                    if ((sash.getStyle() & 0x200) != 0) {
                        int newX;
                        Rectangle constraintBounds = cell.x == 0 ? null : WelcomeLayout.this.columnSashes[cell.x - 1].getBounds();
                        int minX = constraintBounds == null ? 50 : constraintBounds.x + constraintBounds.width + 50;
                        constraintBounds = cell.x >= WelcomeLayout.this.columnSashes.length - 1 ? null : WelcomeLayout.this.columnSashes[cell.x].getBounds();
                        int maxX = constraintBounds == null ? WelcomeLayout.this.parent.getBounds().width - 50 : constraintBounds.x - 50;
                        e.x = newX = Math.min(Math.max(e.x, minX), maxX);
                        ((FormData)sash.getLayoutData()).left = new FormAttachment(0, newX - 5);
                    } else {
                        int newY;
                        Rectangle constraintBounds = cell.y == 0 ? null : WelcomeLayout.this.rowSashes[cell.x][cell.y - 1].getBounds();
                        int minY = constraintBounds == null ? 50 : constraintBounds.y + constraintBounds.height + 50;
                        constraintBounds = cell.y >= WelcomeLayout.this.rowSashes[cell.x].length - 1 || WelcomeLayout.this.rowSashes[cell.x][cell.y] == null ? null : WelcomeLayout.this.rowSashes[cell.x][cell.y].getBounds();
                        int maxY = constraintBounds == null ? WelcomeLayout.this.parent.getBounds().height - 50 : constraintBounds.y - 50;
                        e.y = newY = Math.min(Math.max(e.y, minY), maxY);
                        ((FormData)sash.getLayoutData()).top = new FormAttachment(0, newY - 5);
                    }
                    WelcomeLayout.this.parent.layout();
                    WelcomeLayout.this.deferredUpdateWelcomeLayoutModel();
                }
            });
            orientation = (rowIdx + 1) % rows == 0 ? 512 : 256;
            ++i;
        }
        this.layoutSashes();
    }

    private void layoutSashes() {
        int rows = 2;
        int columns = Math.max(2, (this.tabs.size() + this.tabs.size() % rows) / rows);
        Welcome welcome = this.welcomeService.getWelcome();
        WelcomePage pageModel = welcome.getWelcomePage();
        int i = 0;
        while (i < this.columnSashes.length) {
            Sash column = this.columnSashes[i];
            FormData fd = new FormData();
            SashColumn columnModel = pageModel == null ? null : pageModel.getSashColumn(i);
            fd.top = new FormAttachment(0);
            fd.bottom = new FormAttachment(100);
            fd.left = columnModel != null && columnModel.isSetX() ? new FormAttachment(0, columnModel.getX()) : new FormAttachment(100 * (i + 1) / columns, -5);
            column.setLayoutData((Object)fd);
            Sash[] rowSashes = this.rowSashes[i];
            int j = 0;
            while (j < rowSashes.length) {
                Sash row = rowSashes[j];
                if (row != null) {
                    fd = new FormData();
                    SashRow rowModel = columnModel == null ? null : columnModel.getSashRow(j);
                    fd.top = rowModel != null && rowModel.isSetY() ? new FormAttachment(0, rowModel.getY()) : new FormAttachment(100 * (j + 1) / rows, -5);
                    fd.left = i == 0 ? new FormAttachment(0) : new FormAttachment((Control)this.columnSashes[i - 1], 0, 131072);
                    fd.right = new FormAttachment((Control)column, 0, 16384);
                    row.setLayoutData((Object)fd);
                }
                ++j;
            }
            ++i;
        }
        Sash[] rowSashes = this.rowSashes[this.columnSashes.length];
        int j = 0;
        while (j < rowSashes.length) {
            Sash row = rowSashes[j];
            if (row != null) {
                FormData fd = new FormData();
                SashRow rowModel = pageModel == null ? null : pageModel.getSashRow(this.columnSashes.length, j);
                fd.top = rowModel != null && rowModel.isSetY() ? new FormAttachment(0, rowModel.getY()) : new FormAttachment(100 * (j + 1) / rows, -5);
                fd.left = this.columnSashes.length == 0 ? new FormAttachment(0) : new FormAttachment((Control)this.columnSashes[this.columnSashes.length - 1], 0, 131072);
                fd.right = new FormAttachment(100);
                row.setLayoutData((Object)fd);
            }
            ++j;
        }
    }

    private void createSections() {
        this.sections = new HashMap<WelcomeTab, Composite>();
        int i = 0;
        while (i < this.tabs.size()) {
            WelcomeTab tab = this.tabs.get(i);
            Section control = this.toolkit.createSection(this.parent, 256);
            Composite body = this.toolkit.createComposite((Composite)control);
            body.setLayout((Layout)new GridLayout());
            control.setClient((Control)body);
            tab.register(body, this.tabControls);
            control.setData((Object)tab);
            this.sections.put(tab, (Composite)control);
            Transfer[] transfers = new Transfer[]{WelcomeSectionTransfer.getInstance()};
            this.addDragSourceAdapter((Control)control, transfers, (DragSourceListener)new DragSourceAdapter((ExpandableComposite)control){
                private final /* synthetic */ ExpandableComposite val$control;
                {
                    this.val$control = expandableComposite;
                }

                public void dragSetData(DragSourceEvent event) {
                    event.data = this.val$control;
                }
            });
            this.addDropTargetAdapter((Control)control, transfers, (DropTargetListener)new DropTargetAdapter((ExpandableComposite)control, tab){
                private final /* synthetic */ ExpandableComposite val$control;
                private final /* synthetic */ WelcomeTab val$tab;
                {
                    this.val$control = expandableComposite;
                    this.val$tab = welcomeTab;
                }

                public void drop(DropTargetEvent event) {
                    if (event.data != this.val$control) {
                        Composite target = (Composite)event.data;
                        WelcomeLayout.this.swapSections(this.val$tab, (WelcomeTab)target.getData());
                    }
                }
            });
            control.setText(tab.getLabel());
            ++i;
        }
        this.layoutTabSections();
        if (this.tabControls.isEmpty()) {
            Section messages = this.toolkit.createSection(this.parent, 4096);
            Composite blank = this.toolkit.createComposite((Composite)messages);
            messages.setClient((Control)blank);
            blank.setLayout((Layout)new GridLayout());
            this.toolkit.createLabel(blank, "No welcome content is configured in this workspace.");
            final Hyperlink hyperlink = this.toolkit.createHyperlink(blank, "Open Welcome Preferences", 64);
            this.tabControls.put(null, blank);
            hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)hyperlink.getShell(), (String)"org.eclipse.papyrus.infra.editor.welcome.content", null, null).open();
                }
            });
        }
    }

    private void layoutTabSections() {
        int rows = 2;
        int columns = (this.tabs.size() + this.tabs.size() % rows) / rows;
        int colIdx = 0;
        int rowIdx = -1;
        int i = 0;
        while (i < this.tabs.size()) {
            Control section = (Control)this.sections.get(this.tabs.get(i));
            FormData fd = new FormData();
            if (++rowIdx == rows) {
                ++colIdx;
                rowIdx = 0;
            }
            fd.top = rowIdx == 0 ? new FormAttachment(0) : new FormAttachment((Control)this.rowSashes[colIdx][rowIdx - 1], 0, 1024);
            fd.bottom = rowIdx < rows - 1 && this.rowSashes[colIdx][rowIdx] != null ? new FormAttachment((Control)this.rowSashes[colIdx][rowIdx], 0, 128) : new FormAttachment(100);
            fd.left = colIdx == 0 ? new FormAttachment(0) : new FormAttachment((Control)this.columnSashes[colIdx - 1], 0, 131072);
            fd.right = colIdx < columns - 1 ? new FormAttachment((Control)this.columnSashes[colIdx], 0, 16384) : new FormAttachment(100);
            section.setLayoutData((Object)fd);
            ++i;
        }
    }

    void swapSections(WelcomeTab tab1, WelcomeTab tab2) {
        Collections.swap(this.tabs, this.tabs.indexOf(tab1), this.tabs.indexOf(tab2));
        this.updateWelcomeLayoutModel();
        this.layoutTabSections();
        this.parent.layout();
    }

    Composite getTabControl(Tab tab) {
        return this.tabControls.get(tab);
    }

    private void addDragSourceAdapter(Control control, Transfer[] transferTypes, DragSourceListener listener) {
        Control textLabel = textLabelAccessor.apply(control);
        DragSource drag = new DragSource(textLabel, 2);
        drag.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                event.image = Activator.getIcon("obj:layout");
            }
        });
        drag.setTransfer(transferTypes);
        drag.addDragListener(listener);
        textLabel.addDisposeListener(event -> drag.dispose());
    }

    private void addDropTargetAdapter(Control control, Transfer[] transferTypes, DropTargetListener listener) {
        DropTarget drop = new DropTarget(control, 2);
        drop.setTransfer(transferTypes);
        drop.addDropListener(listener);
        control.addDisposeListener(event -> drop.dispose());
    }

    private void updateWelcomeLayoutModel() {
        SashModel sashModel = SashModelUtils.getSashModel((ServicesRegistry)this.welcomeService.getOwner());
        Resource res = sashModel.getResource();
        if (res != null) {
            Welcome welcome = this.welcomeService.getWelcome();
            try {
                TransactionHelper.run((EditingDomain)EMFHelper.resolveEditingDomain((EObject)welcome), () -> {
                    WelcomePage page;
                    if (welcome.eResource() != res) {
                        res.getContents().add((Object)welcome);
                    }
                    if ((page = welcome.getWelcomePage()) == null) {
                        page = welcome.createWelcomePage();
                    }
                    this.recordTabSectionOrder(page);
                    this.recordSashLayout(page);
                });
            }
            catch (Exception e) {
                Activator.log.error("Failed to update welcome page layout", (Throwable)e);
            }
        }
    }

    private void recordTabSectionOrder(WelcomePage page) {
        ArrayList<WelcomeSection> newSections = new ArrayList<WelcomeSection>(this.tabs.size());
        for (WelcomeTab tab : this.tabs) {
            WelcomeSection section = page.getSection(tab.getID());
            if (section == null) {
                section = WelcomeFactory.eINSTANCE.createWelcomeSection();
                section.getIdentifiers().addAll(tab.getAllTabIDs());
            }
            newSections.add(section);
        }
        ECollections.setEList(page.getSections(), newSections);
    }

    private void recordSashLayout(WelcomePage page) {
        ArrayList<SashColumn> newColumns = new ArrayList<SashColumn>(this.columnSashes.length + 1);
        int i = 0;
        while (i < this.columnSashes.length) {
            SashColumn column = page.getSashColumn(i);
            if (column == null) {
                column = WelcomeFactory.eINSTANCE.createSashColumn();
            }
            newColumns.add(column);
            column.setX(this.columnSashes[i].getLocation().x);
            this.recordRowLayout(column, this.rowSashes[i]);
            ++i;
        }
        SashColumn column = page.getSashColumn(this.columnSashes.length);
        if (column == null) {
            column = WelcomeFactory.eINSTANCE.createSashColumn();
        }
        newColumns.add(column);
        column.unsetX();
        this.recordRowLayout(column, this.rowSashes[this.columnSashes.length]);
        ECollections.setEList(page.getSashColumns(), newColumns);
    }

    private void recordRowLayout(SashColumn column, Sash[] rowSashes) {
        ArrayList<SashRow> newRows = new ArrayList<SashRow>(rowSashes.length);
        int i = 0;
        while (i < rowSashes.length) {
            SashRow row = column.getSashRow(i);
            if (row == null) {
                row = WelcomeFactory.eINSTANCE.createSashRow();
            }
            newRows.add(row);
            if (rowSashes[i] == null) {
                row.unsetY();
            } else {
                row.setY(rowSashes[i].getLocation().y);
            }
            ++i;
        }
        ECollections.setEList(column.getSashRows(), newRows);
    }

    void resetLayoutModel() {
        Welcome welcome = this.welcomeService.getWelcome();
        Resource res = this.welcomeService.getWelcomeResource();
        ModelSet modelSet = (ModelSet)res.getResourceSet();
        Resource sashResource = SashModelUtils.getSashModel((ModelSet)modelSet).getResource();
        Resource welcomeResource = Activator.getDefault().getWelcomeModelManager().getWelcomeResource((ResourceSet)modelSet);
        boolean[] recompute = new boolean[1];
        try {
            TransactionHelper.run((EditingDomain)EMFHelper.resolveEditingDomain((EObject)welcome), () -> {
                Welcome defaultWelcome = (Welcome)EcoreUtil.getObjectByType((Collection)welcomeResource.getContents(), (EClassifier)WelcomePackage.Literals.WELCOME);
                if (res == sashResource) {
                    if (defaultWelcome != null) {
                        EcoreUtil.replace((EObject)defaultWelcome, (EObject)welcome);
                    } else {
                        res.getContents().add((Object)welcome);
                    }
                }
                if (!EcoreUtil.equals((EObject)defaultWelcome, (EObject)welcome)) {
                    blArray[0] = true;
                    WelcomeModelManager.become(welcome, defaultWelcome);
                }
            });
        }
        catch (Exception e) {
            Activator.log.error("Failed to reset new welcome page layout", (Throwable)e);
        }
        if (recompute[0]) {
            this.layout();
        }
    }

    void deferredUpdateWelcomeLayoutModel() {
        if (this.deferredLayoutUpdate.get() == null) {
            new DeferredLayoutUpdate().post();
        }
    }

    void layout() {
        this.sort(this.tabs);
        this.layoutSashes();
        this.layoutTabSections();
        this.parent.layout();
    }

    private static Function<Control, Control> createTextLabelAccessor() {
        Function<Control, Control> result;
        try {
            Field textLabelField = ExpandableComposite.class.getDeclaredField("textLabel");
            textLabelField.setAccessible(true);
            result = section -> {
                try {
                    return (Control)textLabelField.get(section);
                }
                catch (Exception e) {
                    return section;
                }
            };
        }
        catch (Exception e) {
            result = control -> control;
        }
        return result;
    }

    private class DeferredLayoutUpdate
    implements Runnable {
        private long posted;

        private DeferredLayoutUpdate() {
        }

        @Override
        public void run() {
            if (this.isPending(true) && !WelcomeLayout.this.parent.isDisposed()) {
                WelcomeLayout.this.updateWelcomeLayoutModel();
            }
        }

        boolean isPending() {
            return this.isPending(false);
        }

        boolean isPending(boolean reset) {
            return reset ? WelcomeLayout.this.deferredLayoutUpdate.compareAndSet(this, null) : WelcomeLayout.this.deferredLayoutUpdate.get() == this;
        }

        void post() {
            DeferredLayoutUpdate pending = WelcomeLayout.this.deferredLayoutUpdate.get();
            if (pending == null || System.currentTimeMillis() - pending.posted <= 100L) {
                WelcomeLayout.this.deferredLayoutUpdate.set(this);
                Display.getCurrent().timerExec(500, (Runnable)this);
                this.posted = System.currentTimeMillis();
            }
        }
    }
}

