/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.newchild.ui.handler;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.newchild.CreationMenuRegistry;
import org.eclipse.papyrus.infra.newchild.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class DeployCreationMenuModelHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection && !currentSelection.isEmpty()) {
            final IStructuredSelection selection = (IStructuredSelection)currentSelection;
            final Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            Job job = new Job(Messages.DeployCreationMenuModelHandler_DeployMenuJobTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.DeployCreationMenuModelHandler_DoployingMonitorTasksLabel, selection.size());
                    return DeployCreationMenuModelHandler.this.doExecute(selection, monitor);
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(final IJobChangeEvent event) {
                    activeShell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (event.getResult().isOK()) {
                                MessageDialog.openInformation((Shell)activeShell, (String)Messages.DeployCreationMenuModelHandler_SuccesLabel, (String)event.getResult().getMessage());
                            } else if (4 != event.getResult().getSeverity()) {
                                StatusManager.getManager().handle(event.getResult(), 2);
                            }
                        }
                    });
                }
            });
            job.setUser(true);
            job.schedule();
        }
        return null;
    }

    protected IStatus doExecute(IStructuredSelection selection, IProgressMonitor monitor) {
        Iterator selectionIterator = selection.iterator();
        MultiStatus result = new MultiStatus("org.eclipse.papyrus.infra.newchild", 0, Messages.DeployCreationMenuModelHandler_DeploymentSuccess, null);
        while (selectionIterator.hasNext()) {
            Object selectedElement = selectionIterator.next();
            if (!(selectedElement instanceof IAdaptable)) continue;
            IFile selectedFile = (IFile)((IAdaptable)selectedElement).getAdapter(IFile.class);
            if (selectedFile == null) {
                monitor.worked(1);
                result.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.newchild", Messages.DeployCreationMenuModelHandler_ElementNotAFile + selectedElement.toString()));
                continue;
            }
            String fileName = selectedFile.getFullPath().removeFileExtension().lastSegment();
            monitor.subTask(Messages.DeployCreationMenuModelHandler_Deploy + fileName);
            try {
                CreationMenuRegistry.getInstance().loadCreationMenuModel(URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString(), (boolean)true));
                monitor.worked(1);
                result.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.newchild", Messages.DeployCreationMenuModelHandler_Status_deployed + fileName));
            }
            catch (Exception e) {
                monitor.worked(1);
                result.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.newchild", Messages.DeployCreationMenuModelHandler_ErrorDeployFile + String.valueOf(e)));
            }
        }
        IStatus returnedStatus = null;
        if (1 == result.getChildren().length) {
            returnedStatus = result.getChildren()[0];
        } else if (!result.isOK()) {
            returnedStatus = new MultiStatus("org.eclipse.papyrus.infra.newchild", result.getCode(), Messages.DeployCreationMenuModelHandler_SomeErorsOccured, result.getException());
            ((MultiStatus)returnedStatus).merge((IStatus)result);
        }
        return returnedStatus;
    }
}

