/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.services;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.properties.common.utils.SiriusInterpreterHelper;
import org.eclipse.papyrus.sirius.properties.uml.services.PropertiesCrudServices;
import org.eclipse.papyrus.sirius.properties.uml.services.PropertiesUMLServices;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;

public class PropertiesValueSpecificationServices {
    private static final String VALUE_0 = "0";
    private static final String VALUE_FEATURE_NAME = "value";
    private PropertiesUMLServices propertiesUMLServices = new PropertiesUMLServices();
    private PropertiesCrudServices propertiesCrudServices = new PropertiesCrudServices();

    public boolean setLiteralIntegerValue(LiteralInteger target, Object newValue, SiriusInputDescriptor input) {
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        if (interpreter != null) {
            SiriusInterpreterHelper.getInstance().clearValidationVariablesFromInterpreter(input);
            interpreter.setVariable("integerValue", newValue);
        }
        if (interpreter != null && this.validateLiteralIntegerField((EObject)target, input)) {
            Integer integerToSet = null;
            if (newValue instanceof Integer) {
                integerToSet = (Integer)newValue;
            } else if (newValue instanceof String) {
                integerToSet = this.propertiesUMLServices.convertStringToInteger(newValue);
            }
            return this.propertiesCrudServices.set((EObject)target, VALUE_FEATURE_NAME, integerToSet);
        }
        int originalValue = target.getValue();
        int fakeValue = originalValue == Integer.parseInt(VALUE_0) ? originalValue + 1 : Integer.parseInt(VALUE_0);
        target.setValue(fakeValue);
        target.setValue(originalValue);
        return false;
    }

    public boolean setLiteralRealValue(LiteralReal target, Object newValue, SiriusInputDescriptor input) {
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        if (interpreter != null) {
            SiriusInterpreterHelper.getInstance().clearValidationVariablesFromInterpreter(input);
            interpreter.setVariable("realValue", newValue);
        }
        if (interpreter != null && this.validateLiteralRealField((EObject)target, input)) {
            Double realToSet = null;
            if (newValue instanceof Double) {
                realToSet = (Double)newValue;
            } else if (newValue instanceof String) {
                realToSet = this.propertiesUMLServices.convertStringToReal(newValue);
            }
            return this.propertiesCrudServices.set((EObject)target, VALUE_FEATURE_NAME, realToSet);
        }
        double originalValue = target.getValue();
        double fakeValue = originalValue == Double.parseDouble(VALUE_0) ? originalValue + 1.0 : Double.parseDouble(VALUE_0);
        target.setValue(fakeValue);
        target.setValue(originalValue);
        return false;
    }

    public boolean setLiteralUnlimitedNaturalValue(LiteralUnlimitedNatural target, Object newValue, SiriusInputDescriptor input) {
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        if (interpreter != null) {
            SiriusInterpreterHelper.getInstance().clearValidationVariablesFromInterpreter(input);
            interpreter.setVariable("unlimitedNaturalValue", newValue);
        }
        if (interpreter != null && this.validateLiteralUnlimitedNaturalField((EObject)target, input)) {
            Integer unlimitedNaturalToSet = null;
            if (newValue instanceof Integer) {
                unlimitedNaturalToSet = (Integer)newValue;
            } else if (newValue instanceof String) {
                unlimitedNaturalToSet = this.propertiesUMLServices.convertStringToIUnlimitedNatural(newValue);
            }
            return this.propertiesCrudServices.set((EObject)target, VALUE_FEATURE_NAME, unlimitedNaturalToSet);
        }
        int originalValue = target.getValue();
        int fakeValue = originalValue == Integer.parseInt(VALUE_0) ? originalValue + 1 : Integer.parseInt(VALUE_0);
        target.setValue(fakeValue);
        target.setValue(originalValue);
        return false;
    }

    public String getLiteralIntegerValue(LiteralInteger target, SiriusInputDescriptor input) {
        return Integer.toString(target.getValue());
    }

    public String getLiteralRealValue(LiteralReal target, SiriusInputDescriptor input) {
        return Double.toString(target.getValue());
    }

    public String getLiteralUnlimitedNaturalValue(LiteralUnlimitedNatural target, SiriusInputDescriptor input) {
        return this.propertiesUMLServices.convertUnlimitedNaturalToString(target.getValue());
    }

    public boolean validateLiteralIntegerField(EObject target, SiriusInputDescriptor input) {
        boolean result = false;
        Object newValue = null;
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        if (interpreter != null && interpreter.getVariables().containsKey("integerValue")) {
            newValue = interpreter.getVariables().get("integerValue");
        } else {
            EStructuralFeature featureValue = target.eClass().getEStructuralFeature(VALUE_FEATURE_NAME);
            newValue = target.eGet(featureValue);
        }
        result = this.checkIntegerValue(newValue);
        return result;
    }

    public boolean validateLiteralRealField(EObject target, SiriusInputDescriptor input) {
        boolean result = false;
        Object newValue = null;
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        if (interpreter != null && interpreter.getVariables().containsKey("realValue")) {
            newValue = interpreter.getVariables().get("realValue");
        } else {
            EStructuralFeature featureValue = target.eClass().getEStructuralFeature(VALUE_FEATURE_NAME);
            newValue = target.eGet(featureValue);
        }
        result = this.checkRealValue(newValue);
        return result;
    }

    public boolean validateLiteralUnlimitedNaturalField(EObject target, SiriusInputDescriptor input) {
        boolean result = false;
        Object newValue = null;
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        if (interpreter != null && interpreter.getVariables().containsKey("unlimitedNaturalValue")) {
            newValue = interpreter.getVariables().get("unlimitedNaturalValue");
        } else {
            EStructuralFeature featureValue = target.eClass().getEStructuralFeature(VALUE_FEATURE_NAME);
            newValue = target.eGet(featureValue);
        }
        result = this.checkUnlimitedNaturalValue(newValue);
        return result;
    }

    private boolean checkIntegerValue(Object value) {
        boolean result = false;
        if (value instanceof Integer) {
            result = true;
        } else {
            try {
                Integer integerValue = this.propertiesUMLServices.convertStringToInteger(value);
                result = integerValue != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return result;
    }

    private boolean checkRealValue(Object value) {
        boolean result = false;
        if (value instanceof Double) {
            result = true;
        } else {
            try {
                Double real = this.propertiesUMLServices.convertStringToReal(value);
                result = real != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return result;
    }

    private boolean checkUnlimitedNaturalValue(Object value) {
        boolean result = false;
        if (value instanceof Integer) {
            result = true;
        } else if (value instanceof String) {
            if ("*".equals(value)) {
                result = true;
            } else {
                try {
                    result = this.propertiesUMLServices.convertStringToIUnlimitedNatural(value) != null;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return result;
    }

    public String getLiteralIntegerInputStringValue(SiriusInputDescriptor input) {
        String result = "";
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        if (interpreter != null && interpreter.getVariables().get("integerValue") instanceof String) {
            result = (String)interpreter.getVariables().get("integerValue");
        }
        return result;
    }

    public String getLiteralRealInputStringValue(SiriusInputDescriptor input) {
        String result = "";
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        if (interpreter != null && interpreter.getVariables().get("realValue") instanceof String) {
            result = (String)interpreter.getVariables().get("realValue");
        }
        return result;
    }

    public String getLiteralUnlimitedNaturalInputStringValue(SiriusInputDescriptor input) {
        String result = "";
        IInterpreter interpreter = this.getSiriusInterpreter(input);
        if (interpreter != null && interpreter.getVariables().get("unlimitedNaturalValue") instanceof String) {
            result = (String)interpreter.getVariables().get("unlimitedNaturalValue");
        }
        return result;
    }

    protected IInterpreter getSiriusInterpreter(SiriusInputDescriptor input) {
        return SiriusInterpreterHelper.getInstance().getSiriusInterpreter(input);
    }
}

