/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ProfileInternalSourceToRepresentationDropChecker
implements IInternalSourceToRepresentationDropChecker {
    @Override
    public CheckStatus canDragAndDrop(EObject elementToDrop, EObject newSemanticContainer) {
        return (CheckStatus)new ProfileDropOutsideRepresentationCheckerSwitch(newSemanticContainer).doSwitch(elementToDrop);
    }

    static class ProfileDropOutsideRepresentationCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private EObject newSemanticContainer;

        ProfileDropOutsideRepresentationCheckerSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public CheckStatus caseClass(Class clazz) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseComment(Comment comment) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseConstraint(Constraint constraint) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseDataType(DataType dataType) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseElementImport(ElementImport elementImport) {
            CheckStatus result = !(this.newSemanticContainer instanceof Profile) ? CheckStatus.no("Element Import can only be drag and drop on Profile.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseEnumeration(Enumeration enumeration) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseEnumerationLiteral(EnumerationLiteral enumerationLiteral) {
            CheckStatus result = !(this.newSemanticContainer instanceof Enumeration) ? CheckStatus.no("EnumerationLiteral can only be drag and drop on Enumeration.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseOperation(Operation operation) {
            CheckStatus result = !(this.newSemanticContainer instanceof Class) && !(this.newSemanticContainer instanceof DataType) || this.newSemanticContainer instanceof Enumeration ? CheckStatus.no("Operation can only be drag and drop on a Class or a DataType.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus casePackage(Package pack) {
            return this.handlePackageContainer();
        }

        public CheckStatus casePrimitiveType(PrimitiveType primitiveType) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseProfile(Profile profile) {
            return this.handlePackageContainer();
        }

        public CheckStatus caseProperty(Property property) {
            CheckStatus result = !(this.newSemanticContainer instanceof Class) && !(this.newSemanticContainer instanceof DataType) || this.newSemanticContainer instanceof Enumeration ? CheckStatus.no("Property can only be drag and drop on a Class or a DataType.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseStereotype(Stereotype object) {
            return this.handlePackageContainer();
        }

        public CheckStatus defaultCase(EObject object) {
            return CheckStatus.no("DnD is not authorized.");
        }

        private CheckStatus handlePackageContainer() {
            CheckStatus result = !(this.newSemanticContainer instanceof Package) ? CheckStatus.no(MessageFormat.format("{0} can only be drag and drop on a Package kind element.", this.newSemanticContainer.eClass().getName())) : CheckStatus.YES;
            return result;
        }
    }
}

