/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.profile;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ProfileVersion {
    public static final ProfileVersion EMPTY_VERSION = new ProfileVersion(0, 0, 0);
    private static final String SEPARATOR = ".";
    private int major;
    private int minor;
    private int micro;

    public ProfileVersion(int major, int minor, int micro) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
    }

    public ProfileVersion(String value) throws IllegalArgumentException {
        try {
            StringTokenizer st = new StringTokenizer(value, SEPARATOR, true);
            this.major = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                st.nextToken();
                this.minor = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    this.micro = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        throw new IllegalArgumentException("invalid format");
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("invalid format");
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public static ProfileVersion parseVersion(String version) throws IllegalArgumentException {
        if (version == null || version.trim().length() == 0) {
            return EMPTY_VERSION;
        }
        return new ProfileVersion(version);
    }

    public String toString() {
        return this.major + SEPARATOR + this.minor + SEPARATOR + this.micro;
    }
}

