/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.profile;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public class StereotypeUtil {
    public static boolean isStereotypeApplication(EObject self) {
        return self != null && StereotypeUtil.getInUsedBaseReference(self).isPresent();
    }

    public static Optional<EReference> getInUsedBaseReference(EObject self) {
        return StereotypeUtil.getBaseReferences(self.eClass()).filter(ref -> self.eGet((EStructuralFeature)ref) instanceof Element).findFirst();
    }

    public static Stream<EReference> getBaseReferences(EClass eClass) {
        return eClass.getEAllReferences().stream().filter(ref -> ref.getName().startsWith("base_") && !ref.isMany() && ref.getEType().getEPackage() == UMLPackage.eINSTANCE);
    }

    public static Element getBaseElement(EObject steretoypeApplication) {
        Optional<EReference> inUsedBaseReference = StereotypeUtil.getInUsedBaseReference(steretoypeApplication);
        return inUsedBaseReference.map(ref -> (Element)steretoypeApplication.eGet((EStructuralFeature)ref)).orElse(null);
    }

    public static EObject getStereotypeApplication(Element element, EClass stereotypeApplicationType) {
        return element.getStereotypeApplications().stream().filter(st -> stereotypeApplicationType.isSuperTypeOf(st.eClass())).findFirst().orElse(null);
    }
}

