/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class DNFType
extends Identifier {
    public static final int T_UNION = 1;
    public static final int T_INTERSECTION = 2;
    protected ASTNode.NodeList<Identifier> elements = new ASTNode.NodeList(this, ELEMENTS_PROPERTY);
    protected int type;
    public static final ChildListPropertyDescriptor ELEMENTS_PROPERTY = new ChildListPropertyDescriptor(DNFType.class, "elements", Identifier.class, false);
    public static final SimplePropertyDescriptor TYPE_PROPERTY = new SimplePropertyDescriptor(DNFType.class, "type", Integer.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(5);
        properyList.add(NAME_PROPERTY);
        properyList.add(ELEMENTS_PROPERTY);
        properyList.add(NULLABLE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public DNFType(AST ast) {
        super(ast);
    }

    public DNFType(int start, int end, AST ast, boolean nullable, List<Identifier> elements, int type) {
        super(start, end, ast, DNFType.buildName(elements, type));
        this.type = type;
        this.elements.addAll(elements);
        this.setNullable(nullable);
    }

    private static String buildName(List<Identifier> elements, int type) {
        StringBuilder sb = new StringBuilder();
        for (Identifier el : elements) {
            if (!sb.isEmpty()) {
                switch (type) {
                    case 1: {
                        sb.append('|');
                        break;
                    }
                    case 2: {
                        sb.append('&');
                    }
                }
            }
            if (el instanceof DNFType) {
                sb.append('(');
            }
            sb.append(el.getName());
            if (!(el instanceof DNFType)) continue;
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.elements) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.elements) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.elements) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<DNFType");
        this.appendInterval(buffer);
        buffer.append(" type='").append(this.type).append('\'');
        if (this.isNullable()) {
            buffer.append(" nullable='").append(this.isNullable()).append('\'');
        }
        buffer.append(">\n");
        for (ASTNode aSTNode : this.elements) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</DNFType>");
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public int getType() {
        return 88;
    }

    public void setType(int type) {
        this.preValueChange(TYPE_PROPERTY);
        this.type = type;
        this.postValueChange(TYPE_PROPERTY);
    }

    public List<Identifier> elements() {
        assert (this.elements.size() > 0);
        return this.elements;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    protected ASTNode clone0(AST target) {
        List<Identifier> segments = ASTNode.copySubtrees(target, this.elements());
        return new DNFType(this.getStart(), this.getEnd(), target, this.isNullable(), segments, this.type);
    }

    @Override
    protected List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == TYPE_PROPERTY) {
            if (get) {
                return this.getType();
            }
            this.setType(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    final List<? extends ASTNode> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == ELEMENTS_PROPERTY) {
            return this.elements();
        }
        return super.internalGetChildListProperty(property);
    }
}

