/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.figure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Layer;

public abstract class AbstractPositionFeedback {
    private final Layer m_layer;
    private final String m_hint;
    protected final Figure m_figure;
    private Object m_data;

    public AbstractPositionFeedback(Layer layer, Rectangle bounds, String hint) {
        this.m_layer = layer;
        this.m_hint = hint;
        this.m_figure = this.createFigure();
        this.m_layer.add((IFigure)this.m_figure);
        this.m_figure.setBounds(bounds);
    }

    public abstract void update(boolean var1);

    protected abstract Figure createFigure();

    public final String getHint() {
        return this.m_hint;
    }

    public final boolean update(Point location) {
        boolean contains = this.m_figure.getBounds().contains(location);
        this.update(contains);
        return contains;
    }

    public final void remove() {
        this.m_layer.remove((IFigure)this.m_figure);
    }

    public final Object getData() {
        return this.m_data;
    }

    public final void setData(Object data) {
        this.m_data = data;
    }
}

