/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.bindings;

import java.util.List;
import javax.swing.JList;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.parser.IModelResolver;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.TabContainerConfiguration;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swing.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.swing.databinding.model.ObserveCreationType;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.bindings.AutoBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.DetailBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.UpdateStrategyInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.ObjectPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.JListDetailContainerUiContentProvider;

public final class JListBindingInfo
extends AutoBindingInfo {
    private static final String DETAIL_BINDING_1 = "org.jdesktop.swingbinding.JListBinding.setDetailBinding(org.jdesktop.beansbinding.Property)";
    private static final String DETAIL_BINDING_2 = "org.jdesktop.swingbinding.JListBinding.setDetailBinding(org.jdesktop.beansbinding.Property,java.lang.String)";
    private static final IGenericType JLIST_CLASS = new ClassGenericType(JList.class, null, null);
    private DetailBindingInfo m_detailBinding;

    public JListBindingInfo(UpdateStrategyInfo strategyInfo, ObserveInfo target, ObserveInfo targetProperty, PropertyInfo targetAstProperty, ObserveInfo model, ObserveInfo modelProperty, PropertyInfo modelAstProperty) {
        super(strategyInfo, target, targetProperty, targetAstProperty, model, modelProperty, modelAstProperty);
    }

    @Override
    public AstObjectInfo parseExpression(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver, IDatabindingsProvider provider) throws Exception {
        if (DETAIL_BINDING_1.equals(signature) || DETAIL_BINDING_2.equals(signature)) {
            Assert.isNull((Object)((Object)this.m_detailBinding));
            this.m_detailBinding = this.createDetailBinding();
            this.m_detailBinding.setDetailProperty((PropertyInfo)resolver.getModel(arguments[0]));
            if (signature.endsWith(",java.lang.String)")) {
                String name = (String)CoreUtils.evaluate(String.class, (AstEditor)editor, (Expression)arguments[arguments.length - 1]);
                this.m_detailBinding.setName(StringEscapeUtils.unescapeJava((String)name));
            }
            return this.m_detailBinding;
        }
        return super.parseExpression(editor, signature, invocation, arguments, resolver, provider);
    }

    @Override
    public void create(List<BindingInfo> bindings) throws Exception {
        super.create(bindings);
        if (this.m_detailBinding == null) {
            this.m_detailBinding = this.createDefaultDetailBinding();
        }
        bindings.add(bindings.indexOf((Object)this) + 1, this.m_detailBinding);
        this.preCreate();
    }

    @Override
    public boolean delete(List<BindingInfo> bindings) throws Exception {
        this.m_detailBinding.postDelete();
        bindings.remove((Object)this.m_detailBinding);
        return true;
    }

    @Override
    public void move(List<BindingInfo> bindings) {
        bindings.remove((Object)this.m_detailBinding);
        bindings.add(bindings.indexOf((Object)this) + 1, this.m_detailBinding);
    }

    public DetailBindingInfo createDefaultDetailBinding() {
        DetailBindingInfo binding = this.createDetailBinding();
        binding.setDetailProperty(new ObjectPropertyInfo(this.getInputElementType()));
        return binding;
    }

    private DetailBindingInfo createDetailBinding() {
        if (JListBindingInfo.isJListBinding(this.m_target, this.m_targetProperty)) {
            return new DetailBindingInfo(this.m_target, this.m_targetProperty, this.m_targetAstProperty, this.m_model, this.m_modelProperty, this.m_modelAstProperty, this);
        }
        return new DetailBindingInfo(this.m_model, this.m_modelProperty, this.m_modelAstProperty, this.m_target, this.m_targetProperty, this.m_targetAstProperty, this);
    }

    @Override
    public void preCreate() throws Exception {
        BeanPropertyObserveInfo selectedElement = this.getSelectedElementProperty();
        selectedElement.setHostedType(this.getInputElementType());
    }

    @Override
    public void postDelete() throws Exception {
        super.postDelete();
        BeanPropertyObserveInfo selectedElement = this.getSelectedElementProperty();
        selectedElement.setHostedType(ClassGenericType.OBJECT_CLASS);
    }

    private BeanPropertyObserveInfo getSelectedElementProperty() throws Exception {
        return BeanSupport.getProperty(this, JListBindingInfo.isJListBinding(this.m_target, this.m_targetProperty), "selectedElement");
    }

    public IGenericType getInputElementType() {
        if (JListBindingInfo.isJListBinding(this.m_target, this.m_targetProperty)) {
            return this.m_modelProperty.getObjectType().getSubType(0);
        }
        return this.m_targetProperty.getObjectType().getSubType(0);
    }

    public String getTypeSourceCode(CodeGenerationSupport generationSupport) {
        IGenericType type1;
        IGenericType type0;
        if (!generationSupport.useGenerics()) {
            return "org.jdesktop.swingbinding.JListBinding";
        }
        if (JListBindingInfo.isJListBinding(this.m_target, this.m_targetProperty)) {
            if (this.m_modelAstProperty instanceof ObjectPropertyInfo) {
                type0 = this.m_model.getObjectType().getSubType(0);
                type1 = this.m_model.getObjectType();
            } else {
                type0 = this.m_modelProperty.getObjectType().getSubType(0);
                type1 = this.m_model.getObjectType();
            }
        } else if (this.m_targetAstProperty instanceof ObjectPropertyInfo) {
            type0 = this.m_target.getObjectType().getSubType(0);
            type1 = this.m_target.getObjectType();
        } else {
            type0 = this.m_targetProperty.getObjectType().getSubType(0);
            type1 = this.m_target.getObjectType();
        }
        return "org.jdesktop.swingbinding.JListBinding" + GenericUtils.getTypesSource(type0, type1, JLIST_CLASS);
    }

    public DetailBindingInfo getDetailBinding() {
        if (this.m_detailBinding == null) {
            this.m_detailBinding = this.createDefaultDetailBinding();
        }
        return this.m_detailBinding;
    }

    public void setDetailBinding(DetailBindingInfo detailBinding, List<BindingInfo> bindings) throws Exception {
        int index = bindings.indexOf((Object)this);
        if (index == -1) {
            this.m_detailBinding = detailBinding;
        } else {
            if (this.m_detailBinding != null) {
                bindings.remove((Object)this.m_detailBinding);
                this.m_detailBinding.postDelete();
            }
            this.m_detailBinding = detailBinding;
            bindings.add(index + 1, this.m_detailBinding);
        }
        this.m_detailBinding.create(bindings);
    }

    @Override
    public void createContentProviders(List<BindingInfo> bindings, List<IUiContentProvider> providers, IPageListener listener, DatabindingsProvider provider) throws Exception {
        super.createContentProviders(bindings, providers, listener, provider);
        providers.add((IUiContentProvider)new JListDetailContainerUiContentProvider(this.createTabConfiguration(), this, bindings, provider));
    }

    private TabContainerConfiguration createTabConfiguration() {
        TabContainerConfiguration configuration = new TabContainerConfiguration();
        configuration.setUseRemoveButton(true);
        return configuration;
    }

    @Override
    public void addSourceCode(List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        if (JListBindingInfo.isJListBinding(this.m_target, this.m_targetProperty)) {
            this.addSourceCode(this.m_target, this.m_model, this.m_modelProperty, this.m_modelAstProperty, lines, generationSupport);
        } else {
            this.addSourceCode(this.m_model, this.m_target, this.m_targetProperty, this.m_targetAstProperty, lines, generationSupport);
        }
    }

    private void addSourceCode(ObserveInfo component, ObserveInfo model, ObserveInfo modelProperty, PropertyInfo modelAstProperty, List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        boolean localVariable;
        if (this.getVariableIdentifier() == null) {
            this.setVariableIdentifier(generationSupport.generateLocalName(new String[]{"JListBinding"}));
        }
        StringBuffer line = new StringBuffer();
        boolean bl = localVariable = !this.isField();
        if (localVariable) {
            line.append("org.jdesktop.swingbinding.JListBinding");
        }
        if (modelAstProperty instanceof ObjectPropertyInfo) {
            if (localVariable) {
                if (generationSupport.useGenerics()) {
                    line.append(GenericUtils.getTypesSource(model.getObjectType().getSubType(0), model.getObjectType(), JLIST_CLASS));
                }
                line.append(" ");
            }
            line.append(this.getVariableIdentifier());
            line.append(" = org.jdesktop.swingbinding.SwingBindings.createJListBinding(");
            line.append(this.m_strategyInfo.getStrategySourceCode());
            line.append(", ");
            line.append(model.getReference());
            line.append(", ");
            line.append(component.getReference());
        } else {
            generationSupport.addSourceCode((AstObjectInfo)modelAstProperty, lines);
            if (localVariable) {
                if (generationSupport.useGenerics()) {
                    line.append(GenericUtils.getTypesSource(modelProperty.getObjectType().getSubType(0), model.getObjectType(), JLIST_CLASS));
                }
                line.append(" ");
            }
            line.append(this.getVariableIdentifier());
            line.append(" = org.jdesktop.swingbinding.SwingBindings.createJListBinding(");
            line.append(this.m_strategyInfo.getStrategySourceCode());
            line.append(", ");
            line.append(model.getReference());
            line.append(", ");
            line.append(modelAstProperty.getVariableIdentifier());
            line.append(", ");
            line.append(component.getReference());
        }
        line.append(this.getCreateMethodHeaderEnd());
        line.append(";");
        lines.add(line.toString());
        if (!this.m_detailBinding.isVirtual()) {
            lines.add("//");
            this.m_detailBinding.addDetailSourceCode(lines, generationSupport);
            lines.add("//");
        }
        this.addFinishSourceCode(lines, generationSupport, true);
    }

    @Override
    public void setVariableIdentifier(JavaInfo javaInfoRoot, String variable, boolean field) {
        Object type = "org.jdesktop.swingbinding.JListBinding";
        if (CoreUtils.useGenerics((IJavaProject)javaInfoRoot.getEditor().getJavaProject())) {
            type = JListBindingInfo.isJListBinding(this.m_target, this.m_targetProperty) ? (String)type + JListBindingInfo.getTypeSource(this.m_model, this.m_modelProperty, this.m_modelAstProperty, JLIST_CLASS) : (String)type + JListBindingInfo.getTypeSource(this.m_target, this.m_targetProperty, this.m_targetAstProperty, JLIST_CLASS);
        }
        this.setVariableIdentifier(javaInfoRoot, (String)type, variable, field);
    }

    private static boolean isJListBinding(ObserveInfo observe, ObserveInfo propertyObserve) {
        return observe.getCreationType() == ObserveCreationType.JListBinding && propertyObserve.getCreationType() == ObserveCreationType.SelfProperty;
    }
}

