/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessor;
import org.mvel2.ast.ASTNode;
import org.mvel2.compiler.Accessor;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;

public class Union
extends ASTNode {
    private ASTNode main;
    private transient Accessor accessor;

    public Union(char[] expr, int start, int offset, int fields, ASTNode main, ParserContext pCtx) {
        super(expr, start, offset, fields, pCtx);
        this.main = main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accessor != null) {
            return this.accessor.getValue(this.main.getReducedValueAccelerated(ctx, thisValue, factory), thisValue, factory);
        }
        try {
            AccessorOptimizer o = OptimizerFactory.getThreadAccessorOptimizer();
            this.accessor = o.optimizeAccessor(this.pCtx, this.expr, this.start, this.offset, this.main.getReducedValueAccelerated(ctx, thisValue, factory), thisValue, factory, false, this.main.getEgressType());
            Object object = o.getResultOptPass();
            return object;
        }
        finally {
            OptimizerFactory.clearThreadAccessorOptimizer();
        }
    }

    public ASTNode getMain() {
        return this.main;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return PropertyAccessor.get(this.expr, this.start, this.offset, this.main.getReducedValue(ctx, thisValue, factory), factory, thisValue, this.pCtx);
    }

    public Class getLeftEgressType() {
        return this.main.getEgressType();
    }

    @Override
    public String toString() {
        return (this.main != null ? this.main.toString() : "") + "-[union]->" + (this.accessor != null ? this.accessor.toString() : "");
    }
}

