/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.burningwave.core.Closeable;
import org.burningwave.core.LoggingLevel;
import org.burningwave.core.SLF4JManagedLoggerRepository;
import org.burningwave.core.SimpleManagedLoggerRepository;
import org.burningwave.core.assembler.ComponentContainer;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.iterable.IterableObjectHelper;
import org.burningwave.core.iterable.Properties;

public interface ManagedLogger {
    default public void logTrace(String message) {
        StaticComponentContainer.ManagedLoggerRepository.logTrace(this.getClass()::getName, message);
    }

    default public void logTrace(String message, Object ... arguments) {
        StaticComponentContainer.ManagedLoggerRepository.logTrace(this.getClass()::getName, message, arguments);
    }

    default public void logDebug(String message) {
        StaticComponentContainer.ManagedLoggerRepository.logDebug(this.getClass()::getName, message);
    }

    default public void logDebug(String message, Object ... arguments) {
        StaticComponentContainer.ManagedLoggerRepository.logDebug(this.getClass()::getName, message, arguments);
    }

    default public void logInfo(String message) {
        StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, message);
    }

    default public void logInfo(String message, Object ... arguments) {
        StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, message, arguments);
    }

    default public void logWarn(String message) {
        StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, message);
    }

    default public void logWarn(String message, Object ... arguments) {
        StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, message, arguments);
    }

    default public void logError(String message, Throwable exc, Object ... arguments) {
        StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, message, exc, arguments);
    }

    default public void logError(String message, Object ... arguments) {
        StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, message, arguments);
    }

    default public void logError(String message, Throwable exc) {
        StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, message, exc);
    }

    default public void logError(String message) {
        StaticComponentContainer.ManagedLoggerRepository.logError(() -> this.getClass().getName(), message);
    }

    default public void logError(Throwable exc) {
        StaticComponentContainer.ManagedLoggerRepository.logError(() -> this.getClass().getName(), exc);
    }

    public static interface Repository
    extends Closeable {
        public static Repository create(Map<?, ?> config) {
            try {
                String className = StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("managed-logger.repository").on(config)).withDefaultValues(Configuration.DEFAULT_VALUES));
                className = className.trim();
                if ("autodetect".equalsIgnoreCase(className)) {
                    try {
                        StaticComponentContainer.Driver.getClassByName("org.slf4j.Logger", Boolean.valueOf(false), Repository.class.getClassLoader(), Repository.class);
                        return new SLF4JManagedLoggerRepository(config);
                    }
                    catch (Throwable exc2) {
                        return new SimpleManagedLoggerRepository(config);
                    }
                }
                return (Repository)StaticComponentContainer.Driver.getClassByName(className, Boolean.valueOf(false), Repository.class.getClassLoader(), Repository.class).getConstructor(Map.class).newInstance(config);
            }
            catch (Throwable exc) {
                exc.printStackTrace();
                return (Repository)StaticComponentContainer.Driver.throwException(exc);
            }
        }

        public void setLoggingLevelFor(LoggingLevel var1, String ... var2);

        public void setLoggingLevelFlags(Class<?> var1, Integer var2);

        public Integer getLoggingLevelFlags(Class<?> var1);

        public void addLoggingLevelFor(LoggingLevel var1, String ... var2);

        public void removeLoggingLevelFor(LoggingLevel var1, String ... var2);

        public boolean isEnabled();

        public void disableLogging();

        public void enableLogging();

        public void disableLogging(String var1);

        public void enableLogging(String var1);

        public void logError(Supplier<String> var1, String var2, Object ... var3);

        public void logError(Supplier<String> var1, String var2, Throwable var3, Object ... var4);

        public void logError(Supplier<String> var1, String var2, Throwable var3);

        public void logError(Supplier<String> var1, String var2);

        public void logError(Supplier<String> var1, Throwable var2);

        public void logDebug(Supplier<String> var1, String var2);

        public void logDebug(Supplier<String> var1, String var2, Object ... var3);

        public void logInfo(Supplier<String> var1, String var2);

        public void logInfo(Supplier<String> var1, String var2, Object ... var3);

        public void logWarn(Supplier<String> var1, String var2);

        public void logWarn(Supplier<String> var1, String var2, Object ... var3);

        public void logTrace(Supplier<String> var1, String var2);

        public void logTrace(Supplier<String> var1, String var2, Object ... var3);

        public static abstract class Configuration {
            public static final Map<String, Object> DEFAULT_VALUES;

            static {
                HashMap<String, String> defaultValues = new HashMap<String, String>();
                defaultValues.put("managed-logger.repository", "autodetect");
                defaultValues.put("managed-logger.repository.enabled", String.valueOf(true));
                String defaultValuesSeparator = (String)IterableObjectHelper.Configuration.DEFAULT_VALUES.get("iterable-object-helper.default-values-separator");
                defaultValues.put("managed-logger.repository.logging.warn.disabled-for", ComponentContainer.class.getName() + "$ClassLoader" + defaultValuesSeparator + MemoryClassLoader.class.getName() + defaultValuesSeparator + PathScannerClassLoader.class.getName() + defaultValuesSeparator);
                DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
            }

            public static abstract class Key {
                public static final String TYPE = "managed-logger.repository";
                public static final String ENABLED_FLAG = "managed-logger.repository.enabled";
                private static final String LOGGING_LEVEL_FLAG_PREFIX = "managed-logger.repository.logging";
                private static final String LOGGING_LEVEL_DISABLED_FLAG_SUFFIX = "disabled-for";
                public static final String ALL_LOGGING_LEVEL_DISABLED_FOR = "managed-logger.repository.logging.all-levels.disabled-for";
                public static final String TRACE_LOGGING_DISABLED_FOR = "managed-logger.repository.logging.trace.disabled-for";
                public static final String DEBUG_LOGGING_DISABLED_FOR = "managed-logger.repository.logging.debug.disabled-for";
                public static final String INFO_LOGGING_DISABLED_FOR = "managed-logger.repository.logging.info.disabled-for";
                public static final String WARN_LOGGING_DISABLED_FOR = "managed-logger.repository.logging.warn.disabled-for";
                public static final String ERROR_LOGGING_DISABLED_FOR = "managed-logger.repository.logging.error.disabled-for";
            }
        }

        public static abstract class Abst
        implements Repository,
        Properties.Listener {
            boolean isEnabled;
            String instanceId;
            Map<?, ?> config;

            Abst(Map<?, ?> config) {
                this.config = config;
                this.instanceId = this.toString();
                this.initSpecificElements(config);
                if (this.getEnabledLoggingFlag(config)) {
                    this.enableLogging();
                }
                this.removeLoggingLevels(config);
                this.checkAndListenTo(config);
            }

            abstract void initSpecificElements(Map<?, ?> var1);

            abstract void resetSpecificElements();

            boolean getEnabledLoggingFlag(Map<?, ?> properties) {
                return StaticComponentContainer.Objects.toBoolean(StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("managed-logger.repository.enabled").on(properties)));
            }

            @Override
            public <K, V> void processChangeNotification(Properties properties, Properties.Event event, K key, V newValue, V oldValue) {
                if (key instanceof String) {
                    String keyAsString = (String)key;
                    if (keyAsString.equals("managed-logger.repository.enabled") && this.getEnabledLoggingFlag(properties)) {
                        this.enableLogging();
                    }
                    if (keyAsString.startsWith("managed-logger.repository.logging")) {
                        this.resetSpecificElements();
                        this.removeLoggingLevels(properties);
                    }
                }
            }

            void removeLoggingLevels(Map<?, ?> properties) {
                this.removeLoggingLevels(properties, "managed-logger.repository.logging.trace.disabled-for", LoggingLevel.TRACE);
                this.removeLoggingLevels(properties, "managed-logger.repository.logging.debug.disabled-for", LoggingLevel.DEBUG);
                this.removeLoggingLevels(properties, "managed-logger.repository.logging.info.disabled-for", LoggingLevel.INFO);
                this.removeLoggingLevels(properties, "managed-logger.repository.logging.warn.disabled-for", LoggingLevel.WARN);
                this.removeLoggingLevels(properties, "managed-logger.repository.logging.error.disabled-for", LoggingLevel.ERROR);
                this.removeLoggingLevels(properties, "managed-logger.repository.logging.all-levels.disabled-for", LoggingLevel.TRACE, LoggingLevel.DEBUG, LoggingLevel.INFO, LoggingLevel.WARN, LoggingLevel.ERROR);
            }

            protected void removeLoggingLevels(Map<?, ?> properties, String configKey, LoggingLevel ... loggingLevels) {
                String loggerDisabledFor = (String)properties.get(configKey);
                if (loggerDisabledFor != null) {
                    for (LoggingLevel loggingLevel : loggingLevels) {
                        this.removeLoggingLevelFor(loggingLevel, loggerDisabledFor.split(StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator()));
                    }
                }
            }

            protected void addLoggingLevels(java.util.Properties properties, String configKey, LoggingLevel ... loggingLevels) {
                String loggerEnabledFor = properties.getProperty(configKey);
                if (loggerEnabledFor != null) {
                    for (LoggingLevel loggingLevel : loggingLevels) {
                        this.addLoggingLevelFor(loggingLevel, loggerEnabledFor.split(StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator()));
                    }
                }
            }

            @Override
            public boolean isEnabled() {
                return this.isEnabled;
            }

            @Override
            public void disableLogging() {
                this.isEnabled = false;
            }

            @Override
            public void enableLogging() {
                this.isEnabled = true;
            }

            String addDetailsToMessage(String message, StackTraceElement stackTraceElement) {
                return "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ") - " + message;
            }

            @Override
            public void close() {
                this.checkAndUnregister(this.config);
                this.config = null;
                this.instanceId = null;
            }
        }
    }
}

