/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.editorext;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.sqltools.common.ui.util.HTMLTextPresenter;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.core.ui.DebuggerCoreUIPlugin;
import org.eclipse.datatools.sqltools.debugger.editorext.Messages;
import org.eclipse.datatools.sqltools.debugger.model.SPStackFrame;
import org.eclipse.datatools.sqltools.sqleditor.sql.AbstractSQLEditorTextHover;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class SQLDebugHover
extends AbstractSQLEditorTextHover
implements ITextHoverExtension,
ISelectionListener,
IPartListener,
IInformationProviderExtension2 {
    protected IInformationControlCreator _informationControlCreator;
    protected IEditorPart _fEditor;
    protected ISelection _fSelection = null;

    public SQLDebugHover() {
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this._fEditor)) {
            IWorkbenchPage page = this._fEditor.getSite().getPage();
            page.removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            page.removePartListener((IPartListener)this);
            this._fSelection = null;
            this._fEditor = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this._fSelection = selection;
    }

    public SQLDebugHover(IEditorPart editor) {
        this.setEditor(editor);
    }

    public void setEditor(IEditorPart editor) {
        if (editor != null) {
            this._fEditor = editor;
            final IWorkbenchPage page = editor.getSite().getPage();
            page.addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            page.addPartListener((IPartListener)this);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    SQLDebugHover.this._fSelection = page.getSelection("org.eclipse.debug.ui.DebugView");
                }
            };
            DebuggerCoreUIPlugin.getDisplay().asyncExec(r);
        }
    }

    protected SPStackFrame getFrame() {
        Object el;
        IStructuredSelection selection;
        if (this._fSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)this._fSelection).size() == 1 && (el = selection.getFirstElement()) instanceof IAdaptable) {
            return (SPStackFrame)((IAdaptable)el).getAdapter(SPStackFrame.class);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        SPStackFrame frame = this.getFrame();
        if (frame != null) {
            IDocument document;
            block7: {
                document = textViewer.getDocument();
                if (document != null) break block7;
                return null;
            }
            try {
                String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                StringBuffer buffer = new StringBuffer();
                IVariable[] variables = frame.getVariables();
                int i = 0;
                while (i < variables.length) {
                    IVariable localvar = variables[i];
                    if (localvar.getName().equals(variableName)) {
                        SQLDebugHover.appendVariable(buffer, localvar);
                        break;
                    }
                    ++i;
                }
                if (buffer.length() > 0) {
                    return buffer.toString();
                }
            }
            catch (Exception x) {
                DebuggerCorePlugin.getDefault().log(Messages.SQLDebugHover_error_getHoverInfo, (Throwable)x);
            }
        }
        return null;
    }

    private static void appendVariable(StringBuffer buffer, IVariable variable) throws DebugException {
        buffer.append("<p>");
        buffer.append("<pre>").append(variable.getName()).append("</pre>");
        buffer.append(" =");
        String type = SQLDebugHover.getTypeName(variable);
        String varValue = variable.getValue().getValueString();
        if (varValue != null) {
            varValue = varValue.replaceAll("<", "&lt;");
            varValue = varValue.replaceAll(">", "&gt;");
        }
        String value = "<b><pre>" + varValue + "</pre></b>";
        if (type == null) {
            buffer.append(" null");
        } else {
            buffer.append(" (");
            buffer.append("<pre>").append(type).append("</pre>");
            buffer.append(") ");
            buffer.append(value);
        }
        buffer.append("</p>");
    }

    private static String getTypeName(IVariable variable) throws DebugException {
        IValue value = variable.getValue();
        return value.getReferenceTypeName();
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = 0;
                DefaultInformationControl control = new DefaultInformationControl(parent, 16, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), SQLDebugHover.this.getTooltipAffordanceString());
                control.setSizeConstraints(60, 10);
                return control;
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this._informationControlCreator == null) {
            this._informationControlCreator = new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell shell) {
                    boolean cutDown = false;
                    int style = cutDown ? 0 : 768;
                    return new DefaultInformationControl(shell, 16, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
                }
            };
        }
        return this._informationControlCreator;
    }
}

