/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.internal.core.util.preferences.IXMLPreferencesStorable;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesReader;
import org.eclipse.php.internal.core.util.preferences.XMLPreferencesWriter;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsKind;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsProvider;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public abstract class AbstractDebuggerSettingsProvider
implements IDebuggerSettingsProvider {
    private final Map<String, IDebuggerSettings> settingsCache = new HashMap<String, IDebuggerSettings>();
    private final Map<String, IDebuggerSettings> defaultsCache = new HashMap<String, IDebuggerSettings>();
    private boolean cleanup = false;
    private String id;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IDebuggerSettings get(String ownerId) {
        IDebuggerSettings settings = this.settingsCache.get(ownerId);
        if (settings == null && (settings = this.defaultsCache.get(ownerId)) == null) {
            settings = this.createSettings(this.getKind(ownerId), ownerId);
            this.defaultsCache.put(ownerId, settings);
        }
        return settings;
    }

    @Override
    public List<IDebuggerSettings> getAll() {
        return new ArrayList<IDebuggerSettings>(this.settingsCache.values());
    }

    @Override
    public void save(IDebuggerSettings settings) {
        this.settingsCache.put(settings.getOwnerId(), settings);
        this.save();
    }

    @Override
    public void delete(IDebuggerSettings settings) {
        this.settingsCache.remove(settings.getOwnerId());
        this.save();
    }

    protected abstract IDebuggerSettings createSettings(DebuggerSettingsKind var1, String var2);

    protected abstract IDebuggerSettings createSettings(DebuggerSettingsKind var1, String var2, Map<String, String> var3);

    private IDebuggerSettings restoreSettings(String ownerId, Map<String, String> attributes) {
        return this.createSettings(this.getKind(ownerId), ownerId, attributes);
    }

    private DebuggerSettingsKind getKind(String ownerId) {
        Object owner = ServersManager.findServer((String)ownerId);
        if (owner != null) {
            return DebuggerSettingsKind.PHP_SERVER;
        }
        owner = PHPexes.getInstance().findItem(ownerId);
        if (owner != null) {
            return DebuggerSettingsKind.PHP_EXE;
        }
        if (owner == null) {
            if (ownerId.startsWith("php-server")) {
                return DebuggerSettingsKind.PHP_SERVER;
            }
            if (ownerId.startsWith("php-exe")) {
                return DebuggerSettingsKind.PHP_EXE;
            }
        }
        return DebuggerSettingsKind.UNKNOWN;
    }

    private void hookSettings() {
        IDebuggerSettings settings;
        PHPexeItem owner;
        PHPexeItem[] pHPexeItemArray = PHPexes.getInstance().getAllItems();
        int n = pHPexeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            owner = pHPexeItemArray[n2];
            settings = this.createSettings(DebuggerSettingsKind.PHP_EXE, owner.getUniqueId());
            this.save(settings);
            ++n2;
        }
        pHPexeItemArray = ServersManager.getServers();
        n = pHPexeItemArray.length;
        n2 = 0;
        while (n2 < n) {
            owner = pHPexeItemArray[n2];
            settings = this.createSettings(DebuggerSettingsKind.PHP_SERVER, owner.getUniqueId());
            this.save(settings);
            ++n2;
        }
    }

    private boolean exists(String ownerId) {
        return PHPexes.getInstance().findItem(ownerId) != null || ServersManager.findServer((String)ownerId) != null;
    }

    void setId(String id) {
        this.id = id;
    }

    void cleanup() {
        if (this.cleanup) {
            this.save();
        }
    }

    void save() {
        ArrayList<PersistentSettings> persistentSettings = new ArrayList<PersistentSettings>();
        for (IDebuggerSettings settings : this.settingsCache.values()) {
            persistentSettings.add(new PersistentSettings(settings));
        }
        XMLPreferencesWriter.write((IEclipsePreferences)InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core"), (String)this.getId(), persistentSettings);
    }

    void load() {
        List settingsList = XMLPreferencesReader.read((IEclipsePreferences)InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core"), (String)this.getId(), (boolean)false);
        if (settingsList.isEmpty()) {
            this.hookSettings();
        }
        for (Map settings : settingsList) {
            settings = (Map)settings.get("settings");
            HashMap<String, String> attributes = new HashMap<String, String>();
            String ownerId = null;
            for (String key : settings.keySet()) {
                if (key.equals("ownerId")) {
                    ownerId = (String)settings.get(key);
                    continue;
                }
                String value = (String)settings.get(key);
                attributes.put(key, value);
            }
            if (!this.exists(ownerId)) {
                this.cleanup = true;
                continue;
            }
            IDebuggerSettings restoredSettings = this.restoreSettings(ownerId, attributes);
            if (restoredSettings == null) continue;
            this.settingsCache.put(ownerId, restoredSettings);
        }
    }

    private final class PersistentSettings
    implements IXMLPreferencesStorable {
        private static final String TAG_OWNER = "ownerId";
        private static final String TAG_SETTINGS = "settings";
        private IDebuggerSettings settings;

        private PersistentSettings(IDebuggerSettings settings) {
            this.settings = settings;
        }

        public Map<String, Object> storeToMap() {
            HashMap<String, Object> settingsMap = new HashMap<String, Object>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(TAG_OWNER, this.settings.getOwnerId());
            for (String key : this.settings.getAttributes().keySet()) {
                attributes.put(key, this.settings.getAttribute(key));
            }
            settingsMap.put(TAG_SETTINGS, attributes);
            return settingsMap;
        }

        public void restoreFromMap(Map<String, Object> map) {
        }
    }
}

