/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HandshakeUtil {
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    public static final Charset ASCII_CHARSET = Charset.forName("ASCII");

    static ArrayList<String> createHttpFields(InetSocketAddress endpoint) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("Connection: Upgrade");
        return fields;
    }

    static void checkOriginString(String origin) {
        int i = 0;
        while (i < origin.length()) {
            char ch = origin.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                throw new IllegalArgumentException();
            }
            ++i;
        }
    }

    public static HttpResponse readHttpResponse(LineReader input) throws IOException {
        byte[] line;
        byte[] firstLine = input.readUpTo0x0D0A();
        if (firstLine.length < 5) {
            throw new IOException("Malformed response");
        }
        int space1Pos = HandshakeUtil.byteIndexOf((byte)32, firstLine, 0);
        if (space1Pos == -1) {
            throw new IOException("Malformed response");
        }
        int space2Pos = HandshakeUtil.byteIndexOf((byte)32, firstLine, space1Pos + 1);
        if (space2Pos == -1) {
            throw new IOException("Malformed response");
        }
        if (space2Pos - space1Pos != 4) {
            throw new IOException("Malformed response");
        }
        int codeTemp = 0;
        int i = space1Pos + 1;
        while (i < space2Pos) {
            codeTemp = codeTemp * 10 + firstLine[i] - 48;
            ++i;
        }
        final int code = codeTemp;
        int reasonPhraseStart = space2Pos + 1;
        final String reasonPhrase = new String(firstLine, reasonPhraseStart, firstLine.length - space2Pos - 1, ASCII_CHARSET);
        final HashMap<String, String> responseFields = new HashMap<String, String>();
        while ((line = input.readUpTo0x0D0A()).length != 0) {
            String value;
            String conflict;
            String lineStr = new String(line, UTF_8_CHARSET);
            int colonPos = lineStr.indexOf(58);
            if (colonPos == -1) {
                throw new IOException("Malformed response field");
            }
            if (colonPos == 0) {
                throw new IOException("Malformed response field: empty key");
            }
            String key = lineStr.substring(0, colonPos).toLowerCase();
            if (lineStr.length() > colonPos + 1 && lineStr.charAt(colonPos + 1) == ' ') {
                ++colonPos;
            }
            if ((conflict = responseFields.put(key, value = lineStr.substring(colonPos + 1))) == null) continue;
            throw new IOException("Malformed response field: duplicated field: " + key);
        }
        return new HttpResponse(){

            @Override
            public int getCode() {
                return code;
            }

            @Override
            public String getReasonPhrase() {
                return reasonPhrase;
            }

            @Override
            public Map<String, String> getFields() {
                return responseFields;
            }
        };
    }

    public static LineReader createLineReader(final InputStream input) {
        return new LineReader(){

            @Override
            byte[] readUpTo0x0D0A() throws IOException {
                byte b;
                int i;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                while (true) {
                    if ((i = input.read()) == -1) {
                        throw new IOException("End of stream");
                    }
                    b = (byte)i;
                    if (b == 13) break;
                    if (b == 10) {
                        throw new IOException("Malformed end of line");
                    }
                    outputStream.write(b);
                }
                i = input.read();
                if (i == -1) {
                    throw new IOException("End of stream");
                }
                b = (byte)i;
                if (b != 10) {
                    throw new IOException("Malformed end of line");
                }
                return outputStream.toByteArray();
            }
        };
    }

    private static int byteIndexOf(byte b, byte[] array, int start) {
        int i = start;
        while (i < array.length) {
            if (array[i] == b) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static interface HttpResponse {
        public int getCode();

        public Map<String, String> getFields();

        public String getReasonPhrase();
    }

    public static abstract class LineReader {
        abstract byte[] readUpTo0x0D0A() throws IOException;
    }
}

