/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.polarsys.reqcycle.traceability.storage.IStorageProvider;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.traceability.storage.NoProjectStorageException;
import org.polarsys.reqcycle.traceability.types.ITraceabilityAttributesManager;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Attribute;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.traceability.types.impl.FromStorageEditableAttribute;
import org.polarsys.reqcycle.uri.model.Reachable;

public class TraceabilityAttributesManager
implements ITraceabilityAttributesManager {
    public static final String RELATION_NAME = "relationKind";
    @Inject
    ITypesConfigurationProvider typesConfigurationProvider;
    @Inject
    IStorageProvider storageProvider;

    @Override
    public Collection<ITraceabilityAttributesManager.EditableAttribute> getAttributes(Reachable reachable) {
        Configuration defaultConfiguration = this.typesConfigurationProvider.getDefaultConfiguration();
        if (defaultConfiguration == null) {
            return Collections.emptyList();
        }
        try {
            ITraceabilityStorage storage = this.storageProvider.getProjectStorageFromLinkId(reachable);
            if (storage == null) {
                return Collections.emptyList();
            }
            return this.getAttributes(reachable, defaultConfiguration, storage);
        }
        catch (NoProjectStorageException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private Collection<ITraceabilityAttributesManager.EditableAttribute> getAttributes(Reachable reachable, Configuration configuration, ITraceabilityStorage storage) {
        Relation rel;
        final String relationName = storage.getProperty(reachable, RELATION_NAME);
        if (relationName != null && (rel = (Relation)Iterables.find(configuration.getRelations(), (Predicate)new Predicate<Relation>(){

            public boolean apply(Relation arg0) {
                return relationName.equals(arg0.getKind());
            }
        }, null)) != null) {
            return this.getAttributes(reachable, rel);
        }
        return Collections.emptyList();
    }

    private Collection<ITraceabilityAttributesManager.EditableAttribute> getAttributes(Reachable reachable, Relation rel) {
        ArrayList<ITraceabilityAttributesManager.EditableAttribute> attributes = new ArrayList<ITraceabilityAttributesManager.EditableAttribute>();
        for (Attribute a : rel.getAttributes()) {
            LazyStorageProvider lazyStorageProvider = new LazyStorageProvider(this.storageProvider, reachable);
            FromStorageEditableAttribute editableAttribute = new FromStorageEditableAttribute(a, reachable, lazyStorageProvider);
            attributes.add(editableAttribute);
        }
        return attributes;
    }

    private class LazyStorageProvider
    implements FromStorageEditableAttribute.ILazyStorageProvider {
        final IStorageProvider provider;
        final Reachable reachable;

        public LazyStorageProvider(IStorageProvider provider, Reachable reachable) {
            this.provider = provider;
            this.reachable = reachable;
        }

        @Override
        public ITraceabilityStorage getStorage() {
            try {
                return this.provider.getProjectStorageFromLinkId(this.reachable);
            }
            catch (NoProjectStorageException noProjectStorageException) {
                throw new RuntimeException("Can't open storage");
            }
        }
    }
}

