/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.preferences;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wb.swt.ResourceManager;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs.DecorationDialog;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.DecorationPredicate;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.RelationsPredicatesMapping;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeconfigurationFactory;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TTypeDecorationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ITypesConfigurationProvider typeConfProvider = (ITypesConfigurationProvider)ZigguratInject.make(ITypesConfigurationProvider.class);
    private Configuration defaultConfiguration;
    private Table tableOfMappings;
    private Table listOfRelations;
    private TableViewer listOfRelationsViewer;
    private TableViewer tableOfMappingViewer;
    private Button btnAdd;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        lblNewLabel.setText("To add predicates use the menu Predicate Editor for Traceability Relation");
        Label lblIfARelation = new Label(container, 0);
        lblIfARelation.setText("The predicates will be checked in the order they are displayed");
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        Label lblPredicates = new Label(composite, 0);
        lblPredicates.setBounds(0, 0, 55, 15);
        lblPredicates.setText("Traceability Relations");
        Label lblMappings = new Label(composite, 0);
        lblMappings.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        lblMappings.setText("Decorations");
        this.listOfRelationsViewer = new TableViewer(composite, 2560);
        this.listOfRelations = this.listOfRelationsViewer.getTable();
        this.listOfRelations.setLayoutData((Object)new GridData(4, 4, false, true, 2, 1));
        Composite composite_2 = new Composite(composite, 0);
        GridLayout gl_composite_2 = new GridLayout(2, false);
        gl_composite_2.marginHeight = 0;
        gl_composite_2.marginWidth = 0;
        gl_composite_2.verticalSpacing = 0;
        composite_2.setLayout((Layout)gl_composite_2);
        composite_2.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.tableOfMappingViewer = new TableViewer(composite_2, 67584);
        this.tableOfMappings = this.tableOfMappingViewer.getTable();
        this.tableOfMappings.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableOfMappings.setLinesVisible(true);
        Composite composite_1 = new Composite(composite_2, 0);
        composite_1.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        composite_1.setBounds(0, 0, 64, 64);
        GridLayout gl_composite_1 = new GridLayout(1, false);
        gl_composite_1.marginHeight = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        this.btnAdd = new Button(composite_1, 0);
        this.btnAdd.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.traceability.types.ui", "icons/add_obj.gif"));
        this.btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAdd.setBounds(0, 0, 75, 25);
        this.btnRemove = new Button(composite_1, 0);
        this.btnRemove.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.traceability.types.ui", "icons/delete_obj.gif"));
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EObject eobject;
                IStructuredSelection structured;
                if (TTypeDecorationPreferencePage.this.tableOfMappingViewer.getSelection() instanceof IStructuredSelection && (structured = (IStructuredSelection)TTypeDecorationPreferencePage.this.tableOfMappingViewer.getSelection()).getFirstElement() instanceof EObject && !((eobject = (EObject)structured.getFirstElement()) instanceof Relation)) {
                    EcoreUtil.delete((EObject)eobject);
                }
                TTypeDecorationPreferencePage.this.tableOfMappingViewer.refresh(true);
            }
        });
        this.btnUp = new Button(composite_1, 0);
        this.btnUp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnUp.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.traceability.types.ui", "icons/prev_nav-1.gif"));
        this.btnDown = new Button(composite_1, 0);
        this.btnDown.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDown.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.traceability.types.ui", "icons/next_nav-1.gif"));
        this.initProviders();
        this.defaultConfiguration = this.typeConfProvider.getDefaultConfiguration();
        if (this.defaultConfiguration != null) {
            this.typeConfProvider.getContainer();
            this.listOfRelationsViewer.setInput((Object)this.defaultConfiguration.getRelations());
        } else {
            this.setErrorMessage("A default configuration has to be set");
        }
        this.initListeners();
        return container;
    }

    private void initListeners() {
        this.listOfRelationsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RelationsPredicatesMapping m;
                TTypeDecorationPreferencePage.this.tableOfMappingViewer.setInput(Collections.emptyList());
                Relation rel = TTypeDecorationPreferencePage.this.getFromSelection(TTypeDecorationPreferencePage.this.listOfRelationsViewer.getSelection(), Relation.class);
                if (rel != null && (m = TTypeDecorationPreferencePage.this.getMapping(rel)) != null) {
                    TTypeDecorationPreferencePage.this.tableOfMappingViewer.setInput((Object)m.getDecorations());
                }
            }
        });
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean upEnabled = false;
                boolean downEnabled = false;
                boolean addEnabled = true;
                boolean deleteEnabled = false;
                if (TTypeDecorationPreferencePage.this.listOfRelationsViewer.getSelection().isEmpty()) {
                    addEnabled = false;
                }
                if (!TTypeDecorationPreferencePage.this.tableOfMappingViewer.getSelection().isEmpty()) {
                    deleteEnabled = true;
                    DecorationPredicate dec = TTypeDecorationPreferencePage.this.getFromSelection(TTypeDecorationPreferencePage.this.tableOfMappingViewer.getSelection(), DecorationPredicate.class);
                    if (dec != null) {
                        List decorations = (List)TTypeDecorationPreferencePage.this.tableOfMappingViewer.getInput();
                        int index = decorations.indexOf(dec);
                        if (index > 0) {
                            upEnabled = true;
                        }
                        if (index < decorations.size() - 1) {
                            downEnabled = true;
                        }
                    }
                }
                TTypeDecorationPreferencePage.this.btnAdd.setEnabled(addEnabled);
                TTypeDecorationPreferencePage.this.btnRemove.setEnabled(deleteEnabled);
                TTypeDecorationPreferencePage.this.btnUp.setEnabled(upEnabled);
                TTypeDecorationPreferencePage.this.btnDown.setEnabled(downEnabled);
            }
        };
        this.tableOfMappingViewer.addSelectionChangedListener(listener);
        this.listOfRelationsViewer.addSelectionChangedListener(listener);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecorationDialog d = new DecorationDialog(TTypeDecorationPreferencePage.this.getShell());
                ZigguratInject.inject((Object[])new Object[]{d});
                if (d.open() == 0) {
                    RelationsPredicatesMapping m = TTypeDecorationPreferencePage.this.getMapping(TTypeDecorationPreferencePage.this.getFromSelection(TTypeDecorationPreferencePage.this.listOfRelationsViewer.getSelection(), Relation.class));
                    DecorationPredicate p = TypeconfigurationFactory.eINSTANCE.createDecorationPredicate();
                    p.setStyle(d.getStyle());
                    p.setColor(d.getColor());
                    p.setPredicate(d.getPredicate());
                    m.getDecorations().add((Object)p);
                    TTypeDecorationPreferencePage.this.tableOfMappingViewer.refresh();
                }
            }
        });
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecorationPredicate dec = TTypeDecorationPreferencePage.this.getFromSelection(TTypeDecorationPreferencePage.this.tableOfMappingViewer.getSelection(), DecorationPredicate.class);
                EcoreUtil.delete((EObject)dec);
                TTypeDecorationPreferencePage.this.tableOfMappingViewer.refresh();
            }
        });
        this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EList mappings = (EList)TTypeDecorationPreferencePage.this.tableOfMappingViewer.getInput();
                DecorationPredicate d = TTypeDecorationPreferencePage.this.getFromSelection(TTypeDecorationPreferencePage.this.tableOfMappingViewer.getSelection(), DecorationPredicate.class);
                int index = mappings.indexOf((Object)d);
                mappings.move(index - 1, (Object)d);
                TTypeDecorationPreferencePage.this.tableOfMappingViewer.refresh();
            }
        });
        this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EList mappings = (EList)TTypeDecorationPreferencePage.this.tableOfMappingViewer.getInput();
                DecorationPredicate d = TTypeDecorationPreferencePage.this.getFromSelection(TTypeDecorationPreferencePage.this.tableOfMappingViewer.getSelection(), DecorationPredicate.class);
                int index = mappings.indexOf((Object)d);
                mappings.move(index + 1, (Object)d);
                TTypeDecorationPreferencePage.this.tableOfMappingViewer.refresh();
            }
        });
    }

    protected RelationsPredicatesMapping getMapping(Relation rel) {
        RelationsPredicatesMapping m2;
        for (RelationsPredicatesMapping m2 : this.defaultConfiguration.getParent().getMappings()) {
            if (!rel.equals(m2.getRelation())) continue;
            return m2;
        }
        m2 = TypeconfigurationFactory.eINSTANCE.createRelationsPredicatesMapping();
        m2.setRelation(rel);
        this.defaultConfiguration.getParent().getMappings().add((Object)m2);
        return m2;
    }

    public <T> T getFromSelection(ISelection selec, Class<T> clazz) {
        IStructuredSelection structured;
        if (selec instanceof IStructuredSelection && clazz.isInstance((structured = (IStructuredSelection)selec).getFirstElement())) {
            return (T)structured.getFirstElement();
        }
        return null;
    }

    private void initProviders() {
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.listOfRelationsViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)factory));
        this.listOfRelationsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableOfMappingViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableOfMappingViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontAndColorProvider((AdapterFactory)factory, (Viewer)this.tableOfMappingViewer){

            public Font getFont(Object object, int columnIndex) {
                if (object instanceof DecorationPredicate) {
                    DecorationPredicate d = (DecorationPredicate)object;
                    Font font = JFaceResources.getFontRegistry().get(d.getStyle());
                    if (font == null) {
                        JFaceResources.getFontRegistry().put(d.getStyle(), StringConverter.asFontDataArray((String)d.getStyle()));
                        font = JFaceResources.getFontRegistry().get(d.getStyle());
                    }
                    return font;
                }
                return super.getFont(object, columnIndex);
            }

            public Color getForeground(Object object, int columnIndex) {
                if (object instanceof DecorationPredicate) {
                    DecorationPredicate d = (DecorationPredicate)object;
                    Color color = JFaceResources.getColorRegistry().get(d.getColor());
                    if (color == null) {
                        JFaceResources.getColorRegistry().put(d.getColor(), StringConverter.asRGB((String)d.getColor()));
                        color = JFaceResources.getColorRegistry().get(d.getColor());
                    }
                    return color;
                }
                return super.getForeground(object, columnIndex);
            }
        });
    }

    public boolean performOk() {
        if (this.defaultConfiguration != null) {
            this.typeConfProvider.save((EObject)this.defaultConfiguration.getParent());
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }
}

