/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.update;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Display;
import org.polarsys.reqcycle.impact.Impact.ImpactAnalysis;
import org.polarsys.reqcycle.impact.Impact.ImpactFactory;
import org.polarsys.reqcycle.impact.Impact.RequirementImpacted;
import org.polarsys.reqcycle.repository.connector.ConnectorDescriptor;
import org.polarsys.reqcycle.repository.connector.ICallable;
import org.polarsys.reqcycle.repository.connector.IConnector;
import org.polarsys.reqcycle.repository.connector.IConnectorManager;
import org.polarsys.reqcycle.repository.connector.update.pages.DialogImpactAnalysis;
import org.polarsys.reqcycle.repository.connector.update.preferences.PreferenceController;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementSourceDataFactory;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Trash;
import org.polarsys.reqcycle.utils.collect.IterableFactory;
import org.polarsys.reqcycle.utils.collect.Picker;
import org.polarsys.reqcycle.utils.collect.exceptions.CannotPickException;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class UpdateRequirementSourcesHandler {
    private static final String FileExtension = "_impact_analysis.xmi";
    IConnectorManager connManager = (IConnectorManager)ZigguratInject.make(IConnectorManager.class);
    IDataManager requirementSourceManager = (IDataManager)ZigguratInject.make(IDataManager.class);
    private Map<RequirementSource, String> InputRequirementSources;
    private Map<RequirementSource, RequirementSource> storageOldNewReqSources;
    private Map<RequirementSource, ImpactAnalysis> mapReqSourcesWithImpactAna;
    private Map<RequirementSource, ImpactAnalysis> finalMapReqSourcesWithImpactAna;
    @Inject
    IEventBroker broker;

    public UpdateRequirementSourcesHandler(Map<RequirementSource, String> requirementSources) {
        ZigguratInject.inject((Object[])new Object[]{this});
        this.InputRequirementSources = requirementSources;
    }

    public UpdateRequirementSourcesHandler() {
    }

    public void run(IProgressMonitor monitor) {
        this.storageOldNewReqSources = new HashMap<RequirementSource, RequirementSource>();
        this.storageOldNewReqSources = this.createCopyReqSrc(this.InputRequirementSources, this.requirementSourceManager);
        this.mapReqSourcesWithImpactAna = new HashMap<RequirementSource, ImpactAnalysis>();
        this.mapReqSourcesWithImpactAna = this.generateAllImpacts(this.storageOldNewReqSources, monitor);
        monitor.done();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DialogImpactAnalysis impactAnaDialog = new DialogImpactAnalysis(Display.getDefault().getActiveShell(), UpdateRequirementSourcesHandler.this.InputRequirementSources);
                impactAnaDialog.setReqSourceWithImpAnalysis(UpdateRequirementSourcesHandler.this.mapReqSourcesWithImpactAna);
                impactAnaDialog.open();
                if (impactAnaDialog.getReturnCode() == 0) {
                    UpdateRequirementSourcesHandler.this.finalMapReqSourcesWithImpactAna = impactAnaDialog.getFinalMapReqSourcesWithImpactAna();
                    for (Map.Entry reqSrcWithImpact : UpdateRequirementSourcesHandler.this.finalMapReqSourcesWithImpactAna.entrySet()) {
                        if (((ImpactAnalysis)reqSrcWithImpact.getValue()).getRequirementsAdded().size() <= 0 && ((ImpactAnalysis)reqSrcWithImpact.getValue()).getRequirementsDeleted().size() <= 0 && ((ImpactAnalysis)reqSrcWithImpact.getValue()).getRequirementsModified().size() <= 0) continue;
                        UpdateRequirementSourcesHandler.this.finalizedUpdateReqSrc((RequirementSource)reqSrcWithImpact.getKey(), (ImpactAnalysis)reqSrcWithImpact.getValue(), UpdateRequirementSourcesHandler.this.requirementSourceManager, UpdateRequirementSourcesHandler.this.storageOldNewReqSources);
                    }
                }
            }
        });
    }

    private Map<RequirementSource, RequirementSource> createCopyReqSrc(Map<RequirementSource, String> InputRequirementSources, IDataManager requirementSourceManager) {
        HashMap<RequirementSource, RequirementSource> storageReqSources = new HashMap<RequirementSource, RequirementSource>();
        for (Map.Entry<RequirementSource, String> reqSrc : InputRequirementSources.entrySet()) {
            RequirementSource newReqSource = (RequirementSource)EcoreUtil.copy((EObject)reqSrc.getKey());
            try {
                newReqSource.setRepositoryURI(reqSrc.getValue());
                this.regenerateRequirementSource(newReqSource, requirementSourceManager);
                storageReqSources.put(reqSrc.getKey(), newReqSource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return storageReqSources;
    }

    protected Map<RequirementSource, RequirementSource> createCopyReqSrc(List<RequirementSource> InputRequirementSources, IDataManager requirementSourceManager) {
        HashMap<RequirementSource, RequirementSource> storageReqSources = new HashMap<RequirementSource, RequirementSource>();
        for (RequirementSource reqSrc : InputRequirementSources) {
            RequirementSource newReqSource = (RequirementSource)EcoreUtil.copy((EObject)reqSrc);
            this.regenerateRequirementSource(newReqSource, requirementSourceManager);
            storageReqSources.put(reqSrc, newReqSource);
        }
        return storageReqSources;
    }

    protected void finalizedUpdateReqSrc(RequirementSource currentReqSource, ImpactAnalysis currentImpact, IDataManager requirementSourceManager, Map<RequirementSource, RequirementSource> storageOldNewReqSources) {
        RequirementSource reqSource = currentReqSource;
        RequirementSource oldrqSources = this.getOldReqSource(storageOldNewReqSources, reqSource);
        Section sectionTrash = null;
        if (oldrqSources != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            Date date = new Date();
            String currentDate = "_Trash_" + dateFormat.format(date);
            Trash sectionReqDel = requirementSourceManager.createTrash(String.valueOf(reqSource.getName()) + currentDate, "Trash", "");
            ImpactAnalysis currentImpactA = currentImpact;
            ArrayList deletedRequirements = new ArrayList();
            if (currentImpactA != null) {
                deletedRequirements.addAll(currentImpactA.getRequirementsDeleted());
            }
            for (RequirementImpacted absreq : deletedRequirements) {
                EList listAbstractElem = oldrqSources.getRequirements();
                Iterable reqs = IterableFactory.createIterable((Iterable)listAbstractElem, (Picker)new Picker<AbstractElement>(){

                    public Iterable<AbstractElement> getNexts(AbstractElement element) throws CannotPickException {
                        if (element instanceof Section) {
                            return ((Section)element).getChildren();
                        }
                        return Collections.emptyList();
                    }
                });
                for (AbstractElement req : reqs) {
                    if (!(req instanceof AbstractElement) || !req.getId().equals(absreq.getId())) continue;
                    requirementSourceManager.addElementsToSection((Section)sectionReqDel, new AbstractElement[]{req});
                }
            }
            Boolean reqTrashIsFound = false;
            for (AbstractElement requirement : reqSource.getRequirements()) {
                if (!(requirement instanceof Trash)) continue;
                reqTrashIsFound = true;
                sectionTrash = (Section)requirement;
                break;
            }
            if (!reqTrashIsFound.booleanValue()) {
                sectionTrash = requirementSourceManager.createTrash(String.valueOf(reqSource.getName()) + "_Trash", "Trash", "");
                if (sectionReqDel.getChildren() != null && sectionReqDel.getChildren().size() > 0) {
                    requirementSourceManager.addElementsToSection(sectionTrash, new AbstractElement[]{sectionReqDel});
                }
                if (sectionTrash.getChildren() != null && sectionTrash.getChildren().size() > 0) {
                    requirementSourceManager.addElementsToSource(reqSource, new AbstractElement[]{sectionTrash});
                }
            }
            if (sectionReqDel.getChildren() != null && sectionReqDel.getChildren().size() > 0) {
                requirementSourceManager.addElementsToSection(sectionTrash, new AbstractElement[]{sectionReqDel});
            }
            requirementSourceManager.removeRequirementSource(oldrqSources, true);
            requirementSourceManager.addRequirementSource(reqSource);
            ArrayList list = Lists.newArrayList();
            list.add(oldrqSources);
            list.add(reqSource);
            this.broker.post("REQUIREMENTSOURCE/LISTENER", (Object)list);
        }
    }

    protected Map<RequirementSource, ImpactAnalysis> generateAllImpacts(Map<RequirementSource, RequirementSource> mapReq, IProgressMonitor monitor) {
        HashMap<RequirementSource, ImpactAnalysis> mapWhithAnalysis = new HashMap<RequirementSource, ImpactAnalysis>();
        monitor.beginTask("Updating", mapReq.entrySet().size());
        for (Map.Entry<RequirementSource, RequirementSource> reqSrc : mapReq.entrySet()) {
            ImpactAnalysis analysis = ImpactFactory.eINSTANCE.createImpactAnalysis();
            analysis.launchAnalysis(reqSrc.getKey(), reqSrc.getValue());
            mapWhithAnalysis.put(reqSrc.getValue(), analysis);
            monitor.worked(1);
        }
        return mapWhithAnalysis;
    }

    protected void saveImpactAnalysis(String destinationPath, ImpactAnalysis analysis, String fileName) {
        String destPath = fileName;
        if (analysis != null) {
            destPath = String.valueOf(PreferenceController.getPathForImpactAnalysis()) + "/" + destPath + "." + FileExtension;
            analysis.saveAnalysis(this.getURI(destPath));
        }
    }

    private URI getURI(String pathForImpactAnalysis) {
        Path path = new Path(pathForImpactAnalysis);
        IProject cont = null;
        if (path.segmentCount() == 1) {
            cont = ResourcesPlugin.getWorkspace().getRoot().getProject(pathForImpactAnalysis);
            if (!cont.exists()) {
                try {
                    cont.create((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else {
            cont = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
            if (!cont.exists()) {
                try {
                    ((IFolder)cont).create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        if (cont != null) {
            return URI.createPlatformResourceURI((String)cont.getFullPath().toString(), (boolean)true);
        }
        return null;
    }

    private RequirementSource getOldReqSource(Map<RequirementSource, RequirementSource> storageReqSources, RequirementSource newReqSource) {
        RequirementSource oldReqSource = null;
        for (Map.Entry<RequirementSource, RequirementSource> mapReq : storageReqSources.entrySet()) {
            if (!mapReq.getKey().getName().equals(newReqSource.getName())) continue;
            oldReqSource = mapReq.getKey();
        }
        return oldReqSource;
    }

    private void regenerateRequirementSource(RequirementSource source, IDataManager dataManager) {
        ICallable createRequirementSource = null;
        String idConnector = source.getConnectorId();
        if (idConnector != null && !idConnector.equals("")) {
            createRequirementSource = this.getRequirementsCreator(idConnector);
        }
        try {
            if (createRequirementSource == null) {
                throw new Exception("requirement source is null; Should not occur = bug");
            }
            EList sections = source.getRequirements();
            source.setContents(RequirementSourceDataFactory.eINSTANCE.createRequirementsContainer());
            Section sectionTrash = null;
            for (AbstractElement abs : sections) {
                if (!(abs instanceof Trash)) continue;
                sectionTrash = (Section)abs;
            }
            createRequirementSource.fillRequirementSource(source);
            if (sectionTrash != null && sectionTrash.getChildren() != null) {
                dataManager.addElementsToSource(source, new AbstractElement[]{sectionTrash});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ICallable getRequirementsCreator(String idConnector) {
        ConnectorDescriptor connectorD = this.connManager.get(idConnector);
        try {
            IConnector createConnector = connectorD.createConnector();
            ICallable callable = createConnector.getRequirementsCreator();
            if (idConnector.equals(connectorD.getId())) {
                return callable;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Map<RequirementSource, String> getInputRequirementSources() {
        return this.InputRequirementSources;
    }

    public void setInputRequirementSources(Map<RequirementSource, String> requirementSources) {
        this.InputRequirementSources = requirementSources;
    }

    public Map<RequirementSource, ImpactAnalysis> getFinalMapReqSourcesWithImpactAna() {
        return this.finalMapReqSourcesWithImpactAna;
    }

    public void setFinalMapReqSourcesWithImpactAna(Map<RequirementSource, ImpactAnalysis> finalMapReqSourcesWithImpactAna) {
        this.finalMapReqSourcesWithImpactAna = finalMapReqSourcesWithImpactAna;
    }
}

