/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.model.Styling.impl;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.polarsys.reqcycle.operations.IOperation;
import org.polarsys.reqcycle.operations.IReqCycleOperationManager;
import org.polarsys.reqcycle.operations.ReqCycleOperation;
import org.polarsys.reqcycle.styling.model.Styling.BooleanParameter;
import org.polarsys.reqcycle.styling.model.Styling.EObjectParameter;
import org.polarsys.reqcycle.styling.model.Styling.IntParameter;
import org.polarsys.reqcycle.styling.model.Styling.OperationPattern;
import org.polarsys.reqcycle.styling.model.Styling.Parameter;
import org.polarsys.reqcycle.styling.model.Styling.StringParameter;
import org.polarsys.reqcycle.styling.model.Styling.StylingPackage;
import org.polarsys.reqcycle.styling.model.Styling.impl.PatternImpl;
import org.polarsys.reqcycle.uri.IReachableListener;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.functions.URIFunctions;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class OperationPatternImpl
extends PatternImpl
implements OperationPattern,
IReachableListener {
    @Inject
    IReqCycleOperationManager reqCycleOperationlManager;
    @Inject
    IReachableListenerManager manager;
    Multimap<Reachable, Reachable> maps = HashMultimap.create();
    @Inject
    IEventBroker broker;
    public static final String copyright = "Copyright (c) 2014 AtoS\r\n    All rights reserved. This program and the accompanying materials\r\n    are made available under the terms of the Eclipse Public License v1.0\r\n    which accompanies this distribution, and is available at\r\n    http://www.eclipse.org/legal/epl-v10.html *\r\n    Contributors:\r\n      Sebastien Lemanceau (AtoS) - initial API and implementation and/or initial documentation";
    protected static final String OPERATION_EDEFAULT = null;
    protected String operation = OPERATION_EDEFAULT;
    protected EList<Parameter> parameters;

    protected OperationPatternImpl() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    @Override
    protected EClass eStaticClass() {
        return StylingPackage.Literals.OPERATION_PATTERN;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(String newOperation) {
        String oldOperation = this.operation;
        this.operation = newOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldOperation, (Object)this.operation));
        }
    }

    @Override
    public EList<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new EObjectContainmentEList(Parameter.class, (InternalEObject)this, 1);
        }
        return this.parameters;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getParameters()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getOperation();
            }
            case 1: {
                return this.getParameters();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setOperation((String)newValue);
                return;
            }
            case 1: {
                this.getParameters().clear();
                this.getParameters().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setOperation(OPERATION_EDEFAULT);
                return;
            }
            case 1: {
                this.getParameters().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return OPERATION_EDEFAULT == null ? this.operation != null : !OPERATION_EDEFAULT.equals(this.operation);
            }
            case 1: {
                return this.parameters != null && !this.parameters.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (operation: ");
        result.append(this.operation);
        result.append(')');
        return result.toString();
    }

    @Override
    public String getPatternValue(Object object) {
        EList<Parameter> parameters = this.getParameters();
        Class[] listTypes = new Class[parameters.size() + 1];
        Object[] listValues = new Object[parameters.size() + 1];
        listValues[0] = object;
        listTypes[0] = object.getClass();
        int i = 0;
        while (i < parameters.size()) {
            Parameter p = (Parameter)parameters.get(i);
            if (p instanceof StringParameter) {
                listTypes[i + 1] = String.class;
            } else if (p instanceof IntParameter) {
                listTypes[i + 1] = Integer.class;
            } else if (p instanceof BooleanParameter) {
                listTypes[i + 1] = Boolean.class;
            } else if (p instanceof EObjectParameter) {
                listTypes[i + 1] = EObject.class;
            } else {
                return this.getPattern();
            }
            listValues[i + 1] = p.getObjectValue();
            ++i;
        }
        ReqCycleOperation op = this.reqCycleOperationlManager.getOperation(this.getOperation(), listTypes);
        if (op != null) {
            String resultString = "";
            Object obj = op.execute(listValues);
            ArrayList toListen = Lists.newArrayList();
            toListen.add(object);
            if (obj instanceof IOperation.Result) {
                IOperation.Result result = (IOperation.Result)obj;
                if (result.getResult() != null) {
                    if (result.getObjectsToListen() != null) {
                        toListen.addAll(result.getObjectsToListen());
                    }
                    resultString = result.getResult().toString();
                }
            } else if (obj != null) {
                resultString = obj.toString();
            }
            this.register(object, toListen);
            return resultString;
        }
        return this.getPattern();
    }

    private void register(Object from, Collection<Object> iterable) {
        Reachable fromR = this.getReachable(from);
        if (iterable != null) {
            for (Object obj : iterable) {
                Reachable reachableObject = this.getReachable(obj);
                this.manager.addReachableListener(reachableObject, (IReachableListener)this);
                this.maps.put((Object)reachableObject, (Object)fromR);
            }
        }
    }

    private Reachable getReachable(Object obj) {
        Reachable reachableObject = null;
        if (obj instanceof Reachable) {
            reachableObject = (Reachable)obj;
        } else {
            Function obj2RO = URIFunctions.newObject2ReachableFunction();
            reachableObject = (Reachable)obj2RO.apply(obj);
        }
        return reachableObject;
    }

    @Override
    public String getPattern() {
        String pattern = "%" + this.getOperation() + "%";
        return pattern;
    }

    public void hasChanged(Reachable[] reachables) {
        HashSet message = Sets.newHashSet();
        message.addAll(Arrays.asList(reachables));
        Reachable[] reachableArray = reachables;
        int n = reachables.length;
        int n2 = 0;
        while (n2 < n) {
            Reachable r = reachableArray[n2];
            message.addAll(this.maps.get((Object)r));
            ++n2;
        }
        this.broker.post("STYLINGTOPIC/LISTENER", (Object)message);
    }
}

