/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ocl.traceability.visitor;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.reqcycle.ocl.traceability.types.OCLVolatileType;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityBuilder;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.uri.visitors.IVisitor;
import org.polarsys.reqcycle.utils.ocl.OCLEvaluator;
import org.polarsys.reqcycle.utils.ocl.ZigguratOCLPlugin;

public class OCLTraceabilityVisitor
implements IVisitor {
    private OCLEvaluator evaluator;
    private static IStatus initializationStatus = null;

    public void start(IAdaptable adaptable) {
    }

    public boolean visit(Object o, IAdaptable adaptable) {
        Resource resource;
        URI uri;
        ITraceabilityBuilder.IBuilderCallBack callBack = (ITraceabilityBuilder.IBuilderCallBack)adaptable.getAdapter(ITraceabilityBuilder.IBuilderCallBack.class);
        if (o instanceof Resource && (uri = (resource = (Resource)o).getURI()) != null && uri.fileExtension() != null && uri.fileExtension().equals("uml")) {
            if (initializationStatus == null) {
                initializationStatus = this.initializeOCLEvaluator(uri);
            }
            if (!initializationStatus.isOK()) {
                StatusManager.getManager().handle(initializationStatus, 1);
                return false;
            }
            this.go(resource, callBack);
        }
        return false;
    }

    public void end(IAdaptable adaptable) {
    }

    private void go(Resource resource, ITraceabilityBuilder.IBuilderCallBack callback) {
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            EOperation operation = this.evaluator.getCompiledOperation("getLinkTypes", (Object)eObject);
            this.evaluateOperationOnEObject(callback, eObject, operation);
            int i = 1;
            while (i <= 20) {
                operation = this.evaluator.getCompiledOperation("getLinkTypes" + i, (Object)eObject);
                this.evaluateOperationOnEObject(callback, eObject, operation);
                ++i;
            }
        }
    }

    private void evaluateOperationOnEObject(ITraceabilityBuilder.IBuilderCallBack callback, EObject eObject, EOperation operation) {
        if (operation != null) {
            Object result = this.evaluator.evaluateOperation(operation, eObject, new Object[0]);
            if (result instanceof Collection) {
                for (Object o : (Collection)result) {
                    if (!(o instanceof String)) continue;
                    this.computeTraceability((String)o, eObject, callback);
                }
            } else if (result instanceof String) {
                this.computeTraceability((String)result, eObject, callback);
            }
        }
    }

    private IStatus computeTraceability(String linkType, EObject from, ITraceabilityBuilder.IBuilderCallBack callBack) {
        OCLVolatileType ttype = new OCLVolatileType(linkType);
        String operationName = ttype.getOperationName();
        EOperation traceaOperation = this.evaluator.getCompiledOperation(operationName, (Object)from);
        if (traceaOperation != null) {
            Object result = this.evaluator.evaluateOperation(traceaOperation, from, new Object[0]);
            if (result instanceof Collection) {
                for (Object o : (Collection)result) {
                    callBack.newUpwardRelation((Object)from, (Object)from.eResource(), o, Collections.singletonList(from), (TType)ttype);
                }
                return Status.OK_STATUS;
            }
            if (result != null) {
                callBack.newUpwardRelation((Object)from, (Object)from.eResource(), result, Collections.singletonList(from), (TType)ttype);
                return Status.OK_STATUS;
            }
            return new Status(4, "org.polarsys.reqcycle.ocl.traceability", "Traceability operation -" + traceaOperation.getName() + "- returned null");
        }
        return new Status(4, "org.polarsys.reqcycle.ocl.traceability", "Could not find a matching operation named " + operationName + " for object " + from.toString());
    }

    private IStatus initializeOCLEvaluator(URI uri) {
        String[] segments;
        if (uri.isPlatformResource() && (segments = uri.segments()).length > 1) {
            String projectName = segments[1];
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IResource resource = project.findMember("traceability.ocl");
            if (resource instanceof IFile && resource.exists()) {
                String location = resource.getFullPath().toOSString();
                URI oclURI = URI.createPlatformResourceURI((String)location, (boolean)true);
                try {
                    this.evaluator = ZigguratOCLPlugin.compileOCL((ResourceSet)new ResourceSetImpl(), (URI)oclURI);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e instanceof CoreException) {
                        return ((CoreException)e).getStatus();
                    }
                    return new Status(4, "org.polarsys.reqcycle.ocl.traceability", e.getMessage());
                }
            }
            return new Status(4, "org.polarsys.reqcycle.ocl.traceability", "An ocl file named 'traceability.ocl' should be present at the root of the project");
        }
        return Status.OK_STATUS;
    }
}

