/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.persistance.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.persistance.PredicatesConfFactory;
import org.polarsys.reqcycle.predicates.persistance.api.PredicatesConf;
import org.polarsys.reqcycle.predicates.persistance.util.IPredicatesConfManager;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;

@Singleton
public class PredicatesConfManager
implements IPredicatesConfManager {
    private static final String PREDICATESCONF_EXTENSION = "predicatesconf";
    public static final String PREDICATES_ENTRIES_CONF_ID = "org.polarsys.reqcycle.predicates.entries";
    public PredicatesConf predicates;
    @Inject
    IConfigurationManager confManager;

    @Inject
    public PredicatesConfManager(IConfigurationManager confManager) {
        this.confManager = confManager;
        this.predicates = this.getConf(true);
        if (this.predicates == null) {
            this.predicates = PredicatesConfFactory.eINSTANCE.createPredicatesConf();
        }
    }

    @Override
    public boolean storePredicate(IPredicate predicate) {
        boolean added = false;
        try {
            added = this.predicates.getPredicates().add((Object)predicate);
            this.confManager.saveConfiguration(Collections.singleton(this.predicates), null, null, PREDICATES_ENTRIES_CONF_ID, null, PREDICATESCONF_EXTENSION);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            added = false;
        }
        return added;
    }

    @Override
    public void save() {
        try {
            this.confManager.saveConfiguration(Collections.singleton(this.predicates), null, null, PREDICATES_ENTRIES_CONF_ID, null, PREDICATESCONF_EXTENSION);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Collection<IPredicate> getStoredPredicates() {
        this.predicates = this.getConf(true);
        try {
            if (this.predicates == null) {
                this.predicates = PredicatesConfFactory.eINSTANCE.createPredicatesConf();
                this.confManager.saveConfiguration(Collections.singleton(this.predicates), null, null, PREDICATES_ENTRIES_CONF_ID, null, PREDICATESCONF_EXTENSION);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.predicates.getPredicates();
    }

    @Override
    public Collection<IPredicate> getPredicates(boolean reload) {
        return this.getStoredPredicates();
    }

    @Override
    public boolean isPredicateNameAlreadyUsed(String predicateName) {
        boolean alreadyUsed = false;
        if (predicateName != null && this.predicates != null) {
            for (IPredicate p : this.predicates.getPredicates()) {
                if (!predicateName.equals(p.getDisplayName())) continue;
                alreadyUsed = true;
                break;
            }
        }
        return alreadyUsed;
    }

    @Override
    public IPredicate getPredicateByName(String predicateName) {
        if (predicateName != null) {
            for (IPredicate p : this.getPredicates(false)) {
                if (!predicateName.equals(p.getDisplayName())) continue;
                return p;
            }
        }
        return null;
    }

    @Override
    public boolean removePredicate(String predicateName) {
        IPredicate predicate = this.getPredicateByName(predicateName);
        if (predicate != null) {
            return this.removePredicate(predicate);
        }
        return false;
    }

    @Override
    public boolean removePredicate(IPredicate predicate) {
        if (this.predicates != null) {
            EcoreUtil.delete((EObject)predicate, (boolean)true);
            return !this.predicates.getPredicates().contains((Object)predicate);
        }
        return false;
    }

    protected PredicatesConf getConf(boolean reload) {
        Collection conf = this.confManager.getConfiguration(null, null, PREDICATES_ENTRIES_CONF_ID, null, PREDICATESCONF_EXTENSION, reload);
        EObject element = null;
        if (conf != null && !conf.isEmpty()) {
            element = (EObject)conf.iterator().next();
        }
        if (element instanceof PredicatesConf) {
            return (PredicatesConf)element;
        }
        return null;
    }
}

