/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.document.traceability;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.polarsys.reqcycle.document.traceability.DocumentElement;
import org.polarsys.reqcycle.document.traceability.DocumentModelFactory;
import org.polarsys.reqcycle.document.traceability.DocumentTraceLabelProvider;
import org.polarsys.reqcycle.document.traceability.visitor.DocumentVisitable;
import org.polarsys.reqcycle.uri.exceptions.VisitableException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.uri.visitors.EmptyVisitable;
import org.polarsys.reqcycle.uri.visitors.IVisitable;

public class DocumentReachableObject
implements ReachableObject {
    public static final String PLATFORM = "platform:";
    private Reachable reachable = null;
    IFile file = null;
    private DocumentElement element = null;

    public DocumentReachableObject(Reachable t) {
        this.reachable = t;
        String path = t.trimFragment().toString().replaceFirst(PLATFORM, "");
        this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        this.element = t.getFragment() == null ? this.getModel((IResource)this.file) : null;
    }

    private DocumentElement getModel(IResource res) {
        return DocumentModelFactory.getModel(res);
    }

    public Object getAdapter(Class adapter) {
        if (ILabelProvider.class.equals((Object)adapter)) {
            return new DocumentTraceLabelProvider();
        }
        if (DocumentElement.class.equals((Object)adapter)) {
            return this.element;
        }
        if (IFile.class.equals((Object)adapter)) {
            return this.file;
        }
        return null;
    }

    public IVisitable getVisitable() throws VisitableException {
        if (this.element != null) {
            return new DocumentVisitable(this.element);
        }
        return new EmptyVisitable();
    }

    public String getRevisionIdentification() {
        return String.valueOf(this.file.getLocalTimeStamp());
    }

    public Reachable getReachable() {
        return this.reachable;
    }
}

