/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.reachable;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.openrdf.rio.RDFWriterRegistry;
import org.polarsys.reqcycle.traceability.storage.sesame.reachable.SesameReachableObject;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.IObjectHandler;
import org.polarsys.reqcycle.uri.model.IReachableHandler;
import org.polarsys.reqcycle.uri.model.ProxyResolver;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class SesameHandler
implements IObjectHandler,
IReachableHandler {
    @Inject
    IReachableCreator creator;

    @PostConstruct
    public void init() {
    }

    public ReachableObject getFromObject(Object object) {
        SesameReachableObject result = null;
        if (object instanceof File) {
            URI uri = ((File)object).toURI();
            result = new SesameReachableObject(this.creator.getReachable(uri, object));
        } else if (object instanceof IFile) {
            try {
                URI uri = new URI("platform:" + ((IFile)object).getFullPath().toString());
                result = new SesameReachableObject(this.creator.getReachable(uri, object));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        if (result != null) {
            ZigguratInject.inject((Object[])new Object[]{result});
        }
        return result;
    }

    public boolean handlesObject(Object object) {
        if (object instanceof File) {
            return RDFWriterRegistry.getInstance().getFileFormatForFileName(((File)object).getName()) != null;
        }
        if (object instanceof IFile) {
            return RDFWriterRegistry.getInstance().getFileFormatForFileName(((IFile)object).getName()) != null;
        }
        return false;
    }

    public ReachableObject getFromReachable(Reachable t) {
        SesameReachableObject sesameReachableObject = new SesameReachableObject(t);
        ZigguratInject.inject((Object[])new Object[]{sesameReachableObject});
        return sesameReachableObject;
    }

    public boolean handlesReachable(Reachable t) {
        return t.getPath() != null && RDFWriterRegistry.getInstance().getFileFormatForFileName(t.getPath()) != null;
    }

    public ProxyResolver getProxyResolver() {
        return null;
    }
}

