/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.tikaparsing;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.polarsys.kitalpha.doc.doc2model.core.IContentHandler;
import org.polarsys.kitalpha.doc.doc2model.core.IParsingFacility;
import org.polarsys.kitalpha.doc.doc2model.core.ModelContentHandler;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.ITikaParser;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.picture.PictureParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaParsingFacility
implements IParsingFacility {
    static Set<ITikaParser> parsers = TikaParsingFacility.loadParsers();
    static String FILE_PATH = "filePath";

    private static Set<ITikaParser> loadParsers() {
        IConfigurationElement[] elements;
        HashSet result = Sets.newHashSet();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.doc.doc2model.tikaparsing", "tikaParser");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement conf = iConfigurationElementArray[n2];
            try {
                ITikaParser p = (ITikaParser)conf.createExecutableExtension("instance");
                result.add(p);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return result;
    }

    public String getFileTypeInAnyCase(String filePath) {
        MediaType mediaType = MediaType.TEXT_PLAIN;
        try {
            FileInputStream content = new FileInputStream(new File(filePath));
            TikaConfig config = TikaConfig.getDefaultConfig();
            Detector detector = config.getDetector();
            TikaInputStream stream = TikaInputStream.get((InputStream)content);
            Metadata metadata = new Metadata();
            mediaType = detector.detect((InputStream)stream, metadata);
            return mediaType.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getFileType(String filePath) {
        String result = this.getFileTypeInAnyCase(filePath);
        Parser parser = this.getParser(result);
        if (parser == null) {
            return null;
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public <T> T transform(InputStream content, IContentHandler<T> handler, String fileType, Metadata metadata) {
        ModelContentHandler contentHandler;
        block21: {
            Parser parser;
            ParseContext context = new ParseContext();
            if (content instanceof FileInputStream) {
                PictureParser pictureParser = new PictureParser(metadata.get(FILE_PATH));
                context.set(Parser.class, (Object)pictureParser);
            }
            if ((parser = this.getParser(fileType)) == null) {
                return null;
            }
            contentHandler = handler.getContentHandler();
            try {
                parser.parse(content, (ContentHandler)contentHandler, metadata, context);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    content.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                break block21;
            }
            catch (SAXException e) {
                e.printStackTrace();
                break block21;
            }
            catch (TikaException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    content.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                break block21;
            }
            {
                finally {
                    try {
                        content.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                content.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (T)contentHandler.getResult();
    }

    protected Parser getParser(String fileType) {
        for (ITikaParser p : parsers) {
            if (!p.handles(fileType)) continue;
            return p.getParser();
        }
        return null;
    }

    public <T> T transform(String filePath, IContentHandler<T> handler) {
        try {
            FileInputStream content = new FileInputStream(new File(filePath));
            Metadata metadata = new Metadata();
            metadata.add(FILE_PATH, filePath);
            return this.transform(content, handler, this.getFileTypeInAnyCase(filePath), metadata);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

