/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.reviews.core.GitPatchPathFindingStrategy;
import org.eclipse.mylyn.reviews.core.ITargetPathStrategy;
import org.eclipse.mylyn.reviews.core.ReviewSubTask;
import org.eclipse.mylyn.reviews.core.SimplePathFindingStrategy;
import org.eclipse.mylyn.reviews.core.model.review.Patch;
import org.eclipse.mylyn.reviews.core.model.review.Review;
import org.eclipse.mylyn.reviews.core.model.review.ReviewPackage;
import org.eclipse.mylyn.reviews.core.model.review.ScopeItem;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.data.ITaskDataManager;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewsUtil {
    private static List<ITargetPathStrategy> strategies = new ArrayList<ITargetPathStrategy>();

    static {
        strategies.add(new SimplePathFindingStrategy());
        strategies.add(new GitPatchPathFindingStrategy());
    }

    public static List<ReviewSubTask> getReviewSubTasksFor(ITaskContainer taskContainer, ITaskDataManager taskDataManager, IRepositoryModel repositoryModel, IProgressMonitor monitor) {
        ArrayList<ReviewSubTask> resultList = new ArrayList<ReviewSubTask>();
        try {
            for (ITask subTask : taskContainer.getChildren()) {
                if (!subTask.getSummary().startsWith("Review")) continue;
                for (Review review : ReviewsUtil.getReviewAttachmentFromTask(taskDataManager, repositoryModel, subTask)) {
                    if (review.getResult() == null) continue;
                    resultList.add(new ReviewSubTask(ReviewsUtil.getPatchFile(review.getScope()), ReviewsUtil.getPatchCreationDate(review.getScope()), ReviewsUtil.getAuthorString(review.getScope()), subTask.getOwner(), review.getResult().getRating(), review.getResult().getText(), subTask));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultList;
    }

    private static String getPatchFile(EList<ScopeItem> scope) {
        if (scope.size() == 1 && scope.get(0) instanceof Patch) {
            return ((Patch)scope.get(0)).getFileName();
        }
        return "";
    }

    private static Date getPatchCreationDate(EList<ScopeItem> scope) {
        if (scope.size() == 1 && scope.get(0) instanceof Patch) {
            return ((Patch)scope.get(0)).getCreationDate();
        }
        return null;
    }

    private static String getAuthorString(EList<ScopeItem> scope) {
        if (scope.size() == 0) {
            return "none";
        }
        if (scope.size() == 1) {
            return ((ScopeItem)scope.get(0)).getAuthor();
        }
        if (scope.size() < 3) {
            StringBuilder sb = new StringBuilder();
            for (ScopeItem item : scope) {
                sb.append(item.getAuthor());
                sb.append(", ");
            }
            return sb.substring(0, sb.length() - 2);
        }
        return "Multiple Authors";
    }

    static List<Review> parseAttachments(TaskAttribute attribute, IProgressMonitor monitor) {
        ArrayList<Review> reviewList = new ArrayList<Review>();
        try {
            URL url = new URL(attribute.getMappedAttribute("task.common.attachment.url").getValue());
            ZipInputStream stream = new ZipInputStream(url.openStream());
            while (!stream.getNextEntry().getName().equals("reviews-data.xml")) {
            }
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getPackageRegistry().put((Object)"org.eclipse.mylyn.reviews", (Object)ReviewPackage.eINSTANCE);
            Resource resource = resourceSet.createResource(URI.createURI((String)""));
            resource.load((InputStream)stream, null);
            for (EObject item : resource.getContents()) {
                if (!(item instanceof Review)) continue;
                Review review = (Review)item;
                reviewList.add(review);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reviewList;
    }

    public static List<Review> getReviewAttachmentFromTask(ITaskDataManager taskDataManager, IRepositoryModel repositoryModel, ITask task) throws CoreException {
        ArrayList<Review> reviews = new ArrayList<Review>();
        TaskData taskData = taskDataManager.getTaskData(task);
        if (taskData != null) {
            List attributesByType = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment");
            for (TaskAttribute attribute : attributesByType) {
                ITaskAttachment taskAttachment = ((RepositoryModel)repositoryModel).createTaskAttachment(attribute);
                if (taskAttachment == null || !taskAttachment.getFileName().equals("review-data.zip")) continue;
                reviews.addAll(ReviewsUtil.parseAttachments(attribute, (IProgressMonitor)new NullProgressMonitor()));
            }
        }
        return reviews;
    }

    public static List<? extends ITargetPathStrategy> getPathFindingStrategies() {
        return strategies;
    }
}

