/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.model.review;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Rating implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    PASSED(0, "PASSED", "PASSED"),
    WARNING(0, "WARNING", "WARNING"),
    FAILED(0, "FAILED", "FAILED");

    public static final int NONE_VALUE = 0;
    public static final int PASSED_VALUE = 0;
    public static final int WARNING_VALUE = 0;
    public static final int FAILED_VALUE = 0;
    private static final Rating[] VALUES_ARRAY;
    public static final List<Rating> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Rating[]{NONE, PASSED, WARNING, FAILED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Rating get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Rating result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Rating getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Rating result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Rating get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
        }
        return null;
    }

    private Rating(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

