/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.model.review.impl;

import org.eclipse.compare.patch.IFilePatch2;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.mylyn.reviews.core.model.review.Patch;
import org.eclipse.mylyn.reviews.core.model.review.Rating;
import org.eclipse.mylyn.reviews.core.model.review.Review;
import org.eclipse.mylyn.reviews.core.model.review.ReviewFactory;
import org.eclipse.mylyn.reviews.core.model.review.ReviewPackage;
import org.eclipse.mylyn.reviews.core.model.review.ReviewResult;
import org.eclipse.mylyn.reviews.core.model.review.ScopeItem;
import org.eclipse.mylyn.reviews.core.model.review.impl.PatchImpl;
import org.eclipse.mylyn.reviews.core.model.review.impl.ReviewImpl;
import org.eclipse.mylyn.reviews.core.model.review.impl.ReviewResultImpl;
import org.eclipse.mylyn.reviews.core.model.review.impl.ScopeItemImpl;

public class ReviewFactoryImpl
extends EFactoryImpl
implements ReviewFactory {
    public static ReviewFactory init() {
        try {
            ReviewFactory theReviewFactory = (ReviewFactory)EPackage.Registry.INSTANCE.getEFactory("org.eclipse.mylyn.reviews");
            if (theReviewFactory != null) {
                return theReviewFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ReviewFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createReview();
            }
            case 1: {
                return this.createReviewResult();
            }
            case 2: {
                return this.createPatch();
            }
            case 3: {
                return this.createScopeItem();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createRatingFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createIFilePatch2FromString(eDataType, initialValue);
            }
            case 6: {
                return this.createIProgressMonitorFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertRatingToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertIFilePatch2ToString(eDataType, instanceValue);
            }
            case 6: {
                return this.convertIProgressMonitorToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Review createReview() {
        ReviewImpl review = new ReviewImpl();
        return review;
    }

    public ReviewResult createReviewResult() {
        ReviewResultImpl reviewResult = new ReviewResultImpl();
        return reviewResult;
    }

    public Patch createPatch() {
        PatchImpl patch = new PatchImpl();
        return patch;
    }

    public ScopeItem createScopeItem() {
        ScopeItemImpl scopeItem = new ScopeItemImpl();
        return scopeItem;
    }

    public Rating createRatingFromString(EDataType eDataType, String initialValue) {
        Rating result = Rating.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRatingToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public IFilePatch2 createIFilePatch2FromString(EDataType eDataType, String initialValue) {
        return (IFilePatch2)super.createFromString(eDataType, initialValue);
    }

    public String convertIFilePatch2ToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public IProgressMonitor createIProgressMonitorFromString(EDataType eDataType, String initialValue) {
        return (IProgressMonitor)super.createFromString(eDataType, initialValue);
    }

    public String convertIProgressMonitorToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public ReviewPackage getReviewPackage() {
        return (ReviewPackage)this.getEPackage();
    }

    @Deprecated
    public static ReviewPackage getPackage() {
        return ReviewPackage.eINSTANCE;
    }
}

