/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.editors;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.reviews.core.model.review.Rating;
import org.eclipse.mylyn.reviews.core.model.review.Review;
import org.eclipse.mylyn.reviews.core.model.review.ReviewFactory;
import org.eclipse.mylyn.reviews.ui.Images;
import org.eclipse.mylyn.reviews.ui.editors.ReviewTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DelegateReviewTaskEditorPart
extends AbstractTaskEditorPart {
    public static final String ID_PART_REVIEW = "org.eclipse.mylyn.reviews.ui.editors.DelegateReviewTaskEditorPart";

    public DelegateReviewTaskEditorPart() {
        this.setPartName("Review");
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Section section = this.createSection(parent, toolkit, true);
        EditorUtil.setTitleBarForeground((ExpandableComposite)section, (Color)toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridLayout gl = new GridLayout();
        GridData gd = new GridData(4, 0, false, false);
        gd.horizontalSpan = 4;
        section.setLayout((Layout)gl);
        section.setLayoutData((Object)gd);
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        Composite resultComposite = toolkit.createComposite(composite);
        resultComposite.setLayoutData((Object)new GridData(4, -1, true, false));
        resultComposite.setLayout((Layout)new GridLayout(2, false));
        ComboViewer ratingList = new ComboViewer(resultComposite, 0x800808);
        ratingList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ratingList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Rating)element).getName();
            }

            public Image getImage(Object element) {
                Rating rating = (Rating)element;
                switch (rating) {
                    case FAILED: {
                        return Images.REVIEW_RESULT_FAILED.createImage();
                    }
                    case NONE: {
                        return Images.REVIEW_RESULT_NONE.createImage();
                    }
                    case PASSED: {
                        return Images.REVIEW_RESULT_PASSED.createImage();
                    }
                    case WARNING: {
                        return Images.REVIEW_RESULT_WARNING.createImage();
                    }
                }
                return super.getImage(element);
            }
        });
        ratingList.setInput((Object)Rating.VALUES);
        ratingList.getControl().setLayoutData((Object)new GridData(16384, 128, false, false));
        final Text commentText = toolkit.createText(resultComposite, "", 2050);
        gd = new GridData(4, -1, true, false);
        gd.heightHint = 30;
        commentText.setLayoutData((Object)gd);
        Review review = this.getTaskEditorPage().getReview();
        if (review.getResult() != null) {
            Rating rating = review.getResult().getRating();
            ratingList.setSelection((ISelection)new StructuredSelection((Object)rating));
            commentText.setText(review.getResult().getText());
        }
        commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DelegateReviewTaskEditorPart.this.getTaskEditorPage().setDirty();
                Review review = DelegateReviewTaskEditorPart.this.getTaskEditorPage().getReview();
                if (review.getResult() == null) {
                    review.setResult(ReviewFactory.eINSTANCE.createReviewResult());
                }
                review.getResult().setText(commentText.getText());
            }
        });
        ratingList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DelegateReviewTaskEditorPart.this.getTaskEditorPage().setDirty();
                Rating rating = (Rating)((IStructuredSelection)event.getSelection()).getFirstElement();
                Review review = DelegateReviewTaskEditorPart.this.getTaskEditorPage().getReview();
                if (review.getResult() == null) {
                    review.setResult(ReviewFactory.eINSTANCE.createReviewResult());
                }
                review.getResult().setRating(rating);
            }
        });
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.setSection(toolkit, section);
    }

    public ReviewTaskEditorPage getTaskEditorPage() {
        return (ReviewTaskEditorPage)super.getTaskEditorPage();
    }
}

