/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.reviews.core.model.review.ScopeItem;
import org.eclipse.mylyn.reviews.ui.IPatchCreator;
import org.eclipse.mylyn.reviews.ui.PatchCreator;
import org.eclipse.mylyn.reviews.ui.editors.Messages;
import org.eclipse.mylyn.reviews.ui.editors.TableLabelProvider;
import org.eclipse.mylyn.reviews.ui.wizard.CreateReviewWizard;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewScopeWizardPage
extends WizardPage {
    private IPatchCreator selectedPatch;

    protected ReviewScopeWizardPage() {
        super("ReviewScopeWizardPage");
        this.setTitle("Review scope");
        this.setDescription("Select the scope of the review");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        TableViewer patchTable = new TableViewer(composite);
        patchTable.getTable().setHeaderVisible(true);
        patchTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        patchTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof PatchCreator) {
                    ReviewScopeWizardPage.this.selectedPatch = (IPatchCreator)selection.getFirstElement();
                    ReviewScopeWizardPage.this.setPageComplete(true);
                }
            }
        });
        this.createColumn(patchTable, Messages.CreateReviewTaskEditorPart_Header_Filename);
        this.createColumn(patchTable, Messages.CreateReviewTaskEditorPart_Header_Author);
        this.createColumn(patchTable, Messages.CreateReviewTaskEditorPart_Header_Date);
        patchTable.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(){
            final int COLUMN_FILENAME = 0;
            final int COLUMN_AUTHOR = 1;
            final int COLUMN_DATE = 2;

            public String getColumnText(Object element, int columnIndex) {
                IPatchCreator patch = (IPatchCreator)element;
                switch (columnIndex) {
                    case 0: {
                        return patch.getFileName();
                    }
                    case 1: {
                        return patch.getAuthor();
                    }
                    case 2: {
                        return patch.getCreationDate().toString();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        patchTable.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        patchTable.setInput(this.parseAttachmentForPatches());
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private TableViewerColumn createColumn(TableViewer parent, String columnTitle) {
        TableViewerColumn column = new TableViewerColumn(parent, 16384);
        column.getColumn().setText(columnTitle);
        column.getColumn().setWidth(100);
        column.getColumn().setResizable(true);
        return column;
    }

    private List<PatchCreator> parseAttachmentForPatches() {
        try {
            TaskDataModel model = ((CreateReviewWizard)this.getWizard()).getModel();
            TaskData taskData = model.getTaskData();
            List attributesByType = taskData.getAttributeMapper().getAttributesByType(taskData, "attachment");
            ArrayList<PatchCreator> patchFiles = new ArrayList<PatchCreator>();
            for (TaskAttribute attribute : attributesByType) {
                if (!attribute.getMappedAttribute("task.common.attachment.patch").getValue().equals("1")) continue;
                patchFiles.add(new PatchCreator(attribute));
            }
            return patchFiles;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public ScopeItem getScope() throws CoreException {
        return this.selectedPatch.create();
    }
}

